/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.Map;
import java.util.WeakHashMap;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.Cleanable;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.SystemManager;
import org.opengion.hayabusa.resource.CalendarDBData;
import org.opengion.hayabusa.resource.CalendarData;
import org.opengion.hayabusa.resource.CalendarQuery;

public final class CalendarFactory {
    private static final Map<String, CalendarData> DATA_POOL = new WeakHashMap<String, CalendarData>();
    private static final Map<String, CalendarQuery> QUERY_POOL = new WeakHashMap<String, CalendarQuery>();
    private static CalendarData pgCalData;
    private static final String PG_CALENDAR_DATA_CLASS;
    private static final Object LOCK;
    private static final String DBID;
    private static boolean useDB;
    private static final ApplicationInfo APP_INFO;

    private CalendarFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalendarData getCalendarData(String string2, String ... stringArray) {
        Object object = LOCK;
        synchronized (object) {
            if (pgCalData == null) {
                pgCalData = (CalendarData)HybsSystem.newInstance(PG_CALENDAR_DATA_CLASS);
            }
        }
        if (!useDB || string2 == null) {
            return pgCalData;
        }
        String string3 = string2 + ":" + String.join((CharSequence)":", stringArray);
        Object object2 = LOCK;
        synchronized (object2) {
            object = DATA_POOL.get(string3);
        }
        if (object == null) {
            object2 = QUERY_POOL.computeIfAbsent(string2, string -> (CalendarQuery)HybsSystem.newInstance("CalendarQuery_", string));
            String[] stringArray2 = object2.checkArgment(stringArray);
            String[][] stringArray3 = DBUtil.dbExecute((String)object2.getQuery(), (String[])stringArray2, (ApplicationInfo)APP_INFO, (String)DBID);
            boolean bl = object2.isFlatTable();
            if (stringArray3 != null && stringArray3.length > 0) {
                object = new CalendarDBData(stringArray3, bl);
                Object object3 = LOCK;
                synchronized (object3) {
                    DATA_POOL.put(string3, (CalendarData)object);
                }
            } else {
                object = pgCalData;
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Object object = LOCK;
        synchronized (object) {
            DATA_POOL.clear();
            QUERY_POOL.clear();
            useDB = HybsSystem.sysBool("USE_CALENDAR_DATABASE");
        }
    }

    static {
        PG_CALENDAR_DATA_CLASS = HybsSystem.sys("DEFAULT_CALENDAR_CLASS");
        LOCK = new Object();
        DBID = HybsSystem.sys("RESOURCE_CALENDAR_DBID");
        useDB = HybsSystem.sysBool("USE_CALENDAR_DATABASE");
        Cleanable cleanable = new Cleanable(){

            public void clear() {
                CalendarFactory.clear();
            }
        };
        SystemManager.addCleanable(cleanable);
        boolean bl = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
        if (bl) {
            String string = HybsSystem.sys("SYSTEM_ID");
            APP_INFO = new ApplicationInfo();
            APP_INFO.setClientInfo(string, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            APP_INFO.setModuleInfo("CalendarFactory", null, null);
        } else {
            APP_INFO = null;
        }
    }
}

