/****************************************************************************/
/* GE31 ( 定型文ﾏｽﾀ )                                                       */
/*                                                                          */
/* Created : 2022/11/10 17:46:32                                            */
/****************************************************************************/


CREATE TABLE GE31 (
   SYSTEM_ID    VARCHAR2 (   10 )                   NOT NULL            /*  10 ｼｽﾃﾑID       */
 , PTN_ID       VARCHAR2 (   20 )                   NOT NULL            /*  20 定型文ID     */
 , FROM_ID      VARCHAR2 (   50 )                                       /*  30 送信者ID     */
 , TO_ID        VARCHAR2 ( 4000 )                                       /*  40 宛先(TO)     */
 , CC_ID        VARCHAR2 ( 4000 )                                       /*  50 宛先(CC)     */
 , BCC_ID       VARCHAR2 ( 4000 )                                       /*  60 宛先(BCC)    */
 , TITLE        VARCHAR2 (  300 )                   NOT NULL            /*  70 ﾀｲﾄﾙ         */
 , CONTENTS     CLOB                                                    /*  80 内容         */
 , JOKEN        VARCHAR2 (   20 )                                       /*  85 振分条件     */
 , UNIQ         NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 800 ﾕﾆｰｸｷｰ       */
 , FGJ          VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 810 状態ﾌﾗｸﾞ     */
 , DYSET        VARCHAR2 (   14 )                                       /* 820 作成日時     */
 , PGSET        VARCHAR2 (   50 )                                       /* 830 作成PG       */
 , PGPSET       VARCHAR2 (   50 )                                       /* 840 作成親PG     */
 , USRSET       VARCHAR2 (   30 )                                       /* 850 作成者       */
 , DYUPD        VARCHAR2 (   14 )                                       /* 860 更新日時     */
 , PGUPD        VARCHAR2 (   50 )                                       /* 870 更新PG       */
 , PGPUPD       VARCHAR2 (   50 )                                       /* 880 更新親PG     */
 , USRUPD       VARCHAR2 (   30 )                                       /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K );



CREATE SEQUENCE GE31S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GE31T00 
  BEFORE INSERT ON GE31
  FOR EACH ROW 
  BEGIN 
    SELECT GE31S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
