/****************************************************************************/
/* GEA08 ( ﾗﾍﾞﾙ定義 )                                                       */
/*                                                                          */
/* Created : 2022/11/10 17:46:32                                            */
/****************************************************************************/


CREATE TABLE GEA08 (
   SYSTEM_ID        VARCHAR2 (   10 )                   NOT NULL            /*  10 ｼｽﾃﾑID   */
 , LANG             VARCHAR2 (    2 )                   NOT NULL            /*  20 言語     */
 , CLM              VARCHAR2 (   50 )                   NOT NULL            /*  30 項目     */
 , NAME_JA          VARCHAR2 (  200 )                                       /*  40 名称     */
 , SNAME            VARCHAR2 (  200 )                                       /*  50 名前(短) */
 , LNAME            VARCHAR2 (  500 )                                       /*  60 名前(長) */
 , DESCRIPTION      VARCHAR2 ( 4000 )                                       /*  70 概要説明 */
 , KBLBL            VARCHAR2 (    1 )                   NOT NULL            /*  80 ﾗﾍﾞﾙ区分 */
 , COMMENTS         VARCHAR2 (  500 )                                       /*  90 ｺﾒﾝﾄ     */
 , CDKH             VARCHAR2 (    1 )                                       /* 100 改廃ｺｰﾄﾞ */
 , FGLOAD           VARCHAR2 (    1 )       DEFAULT '0' NOT NULL            /* 110 読込F    */
 , KBSAKU           VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 120 作成区分 */
 , SUBSYS           VARCHAR2 (  200 )                                       /* 130 ｻﾌﾞｼｽﾃﾑ  */
 , RELEASE_NOTES    VARCHAR2 (  120 )                                       /* 140 ﾘﾘｰｽﾉｰﾄ  */
 , RDC_CODE         VARCHAR2 (   20 )                                       /* 150 設変番号 */
 , UNIQ             NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 800 ﾕﾆｰｸｷｰ   */
 , FGJ              VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 810 状態ﾌﾗｸﾞ */
 , DYSET            VARCHAR2 (   14 )                                       /* 820 作成日時 */
 , PGSET            VARCHAR2 (   50 )                                       /* 830 作成PG   */
 , PGPSET           VARCHAR2 (   50 )                                       /* 840 作成親PG */
 , USRSET           VARCHAR2 (   30 )                                       /* 850 作成者   */
 , DYUPD            VARCHAR2 (   14 )                                       /* 860 更新日時 */
 , PGUPD            VARCHAR2 (   50 )                                       /* 870 更新PG   */
 , PGPUPD           VARCHAR2 (   50 )                                       /* 880 更新親PG */
 , USRUPD           VARCHAR2 (   30 )                                       /* 890 更新者   */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K );



CREATE SEQUENCE GEA08S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GEA08T00 
  BEFORE INSERT ON GEA08
  FOR EACH ROW 
  BEGIN 
    SELECT GEA08S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
