/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.table;

import java.util.Arrays;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.db.AbstractTableFilter;
import org.opengion.hayabusa.db.DBTableModel;

public class TableFilter_NORMALIZE
extends AbstractTableFilter {
    private static final String VERSION = "8.4.1.0 (2023/02/10)";
    private DBTableModel table;

    public TableFilter_NORMALIZE() {
        this.initSet("VAL_CLMS", "\u6b63\u898f\u5316(\u30b9\u30b1\u30fc\u30ea\u30f3\u30b0)\u3092\u884c\u3046\u30ab\u30e9\u30e0\u5217");
        this.initSet("FORMAT", "\u6570\u5024\u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8 (\u521d\u671f\u5024:%.3f \uff65\uff65\uff65 \u5c0f\u6570\u4ee3\uff13\u4f4d\u4ee5\u4e0b\u3092\u3001\u56db\u6368\u4e94\u5165\u3059\u308b)");
    }

    public DBTableModel execute() {
        String[] stringArray;
        int n;
        this.table = this.getDBTableModel();
        int n2 = this.table.getRowCount();
        if (n2 == 0) {
            return this.table;
        }
        String[] stringArray2 = StringUtil.csv2Array((String)this.getValue("VAL_CLMS"));
        int[] nArray = this.getTableColumnNo(stringArray2);
        String string = this.getValue("FORMAT");
        String string2 = string == null || string.isEmpty() ? "%.3f" : string;
        Normalization normalization = new Normalization(nArray, string2);
        for (n = 0; n < n2; ++n) {
            stringArray = (String[])this.table.getValues(n);
            normalization.check(stringArray);
        }
        for (n = 0; n < n2; ++n) {
            stringArray = (String[])this.table.getValues(n);
            normalization.chenge(stringArray);
        }
        return this.table;
    }

    private static final class Normalization {
        private final int[] clmNos;
        private final int clmSize;
        private final double[] minVals;
        private final double[] maxVals;
        private final String format;

        public Normalization(int[] nArray, String string) {
            this.clmNos = nArray;
            this.clmSize = nArray.length;
            this.format = string;
            this.minVals = new double[this.clmSize];
            this.maxVals = new double[this.clmSize];
            Arrays.fill(this.minVals, Double.POSITIVE_INFINITY);
            Arrays.fill(this.maxVals, Double.NEGATIVE_INFINITY);
        }

        public void check(String[] stringArray) {
            for (int i = 0; i < this.clmSize; ++i) {
                String string = stringArray[this.clmNos[i]];
                if (StringUtil.isNull((CharSequence[])new CharSequence[]{string})) continue;
                double d = Double.parseDouble(string);
                if (this.minVals[i] > d) {
                    this.minVals[i] = d;
                }
                if (!(this.maxVals[i] < d)) continue;
                this.maxVals[i] = d;
            }
        }

        public void chenge(String[] stringArray) {
            for (int i = 0; i < this.clmSize; ++i) {
                String string = stringArray[this.clmNos[i]];
                if (StringUtil.isNull((CharSequence[])new CharSequence[]{string})) continue;
                double d = Double.parseDouble(string);
                stringArray[this.clmNos[i]] = String.format(this.format, (d - this.minVals[i]) / (this.maxVals[i] - this.minVals[i]));
            }
        }
    }
}

