<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE7001"
	title    = "取込要求ﾃｰﾌﾞﾙ"
	date     = "2017/06/27"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:columnCheck command="{@command}" />
<og:entry command="{@command}" />

<!-- 7.2.9.5 (2020/11/28) sqlType はﾏｰｼﾞ対応。ﾒﾓﾘ内での重複ﾁｪｯｸも同時実行 -->
<og:dataCheck
	dbid		= "{@MEM.TO_DBID}"
	command 	= "{@command}"
	sqlType		= "{@sqlType}"
	from		= "GE70"
	where		= "SYSTEM_ID=[SYSTEM_ID] AND RSRV_NO=[RSRV_NO]"
	uniqCheckClms	= "SYSTEM_ID,RSRV_NO"
	errRemove	= "{@errRemove}"
/>

<og:transaction>
	<!-- GE72.NAME_JA を取ってきて、GE70.NAME_JA にセットしているので、全カラムをセットする。 -->
	<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate" debug="{@debug}">
		<og:tableUpdateParam
			sqlType		= "{@sqlType}"
			table		= "GE70"
			where		= "SYSTEM_ID=[SYSTEM_ID] AND RSRV_NO=[RSRV_NO]"
		/>
	</og:tableUpdate>
</og:transaction>

<!-- ファイル取込システムの使用が true の場合のみ、再実行処理を行います。 -->
<og:equals val1="{@SYS.USE_FILEEXEC}" val2="true">
	<jsp:scriptlet>
		org.opengion.fukurou.fileexec.MainProcess.shutdown( false );	// 再実行できるようにして停止

		org.opengion.fukurou.fileexec.MainProcess.start();				// ﾌｧｲﾙ取込処理を開始
	</jsp:scriptlet>
</og:equals>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
