<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<jsp:directive.page import="org.opengion.hayabusa.report2.ExecThreadManager" />

<og:head headType="init" />
<og:comment
	system   = "GE"
	pgid     = "REP21"
	title    = "新帳票起動・停止"
	date     = "2008/10/14"
	author   = "M.Takahashi"
	text     = "新規作成"
	version  = "001"
/>

<!-- エラー時の戻るボタン。書き換えないで下さい。-->
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheck のみ有効です。カラムに付いては、全カラムをチェックしています。-->
<og:columnCheck
	command		= "{@command}"
/>

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}"  />

<og:transaction>
	<!-- 登録時の動作です -->
	<og:equals val1="{@action}" val2="entry" >
		<!-- 同じCONTXT_PATH以外でPARAM_IDが登録されている場合はエラー -->
		<og:dataCheck
			command	= "{@command}"
			exist	= "false"
			>
			SELECT count(*) FROM GE12
				WHERE	PARAM		like '%' {@DBF.CON} [THREAD]
				AND		PARAM_ID 	like 'REPORT2_HANDLE_DAEMON_%'
				AND		CONTXT_PATH	!= '{@SYS.HOST_URL}'
				AND		FGJ			= '1'
		</og:dataCheck>

		<!-- 選択したデーモングループを削除後に追加（STOPも再開させるため） -->
		<og:tableUpdate
			command		= "{@command}"
			queryType	= "JDBCTableUpdate"
		>
			DELETE FROM GE12
				WHERE	SYSTEM_ID	= '{@SYS.SYSTEM_ID}'
				AND		PARAM		like '%' {@DBF.CON} [THREAD]
				AND		CONTXT_PATH = [CONTXT_PATH]
				AND		PARAM_ID 	like ('REPORT2_HANDLE_DAEMON_%')
				AND		FGJ			= '1'
		</og:tableUpdate>

		<og:tableUpdate
			command		= "{@command}"
			queryType	= "JDBCTableUpdate"
		>
		INSERT INTO GE12 (
			SYSTEM_ID,
			PARAM_ID,
			SEQNO,
			TITLE,
			PARAM,
			CONTENTS,
			PARAM_LVL,
			KBSAKU,
			FGJ,
			DYSET,
			USRSET,
			PGUPD,
			FGCRYPT,
			CONTXT_PATH,
			FGREBOOT
		)
		VALUES (
			'{@SYS.SYSTEM_ID}',
			'REPORT2_HANDLE_DAEMON_' {@DBF.CON} [SYSTEM_ID] {@DBF.CON} '_' {@DBF.CON} [DMN_GRP],
			2100,
			'Calc帳票で処理するデーモングループ',
			'RUN_' {@DBF.CON} [THREAD],
			'CONTXT_PATHのCalc帳票システムで処理するデーモングループです。通常は新帳票起動画面で設定します。',
			'2',
			'1',
			'1',
			'{@USER.YMDH}',
			'{@USER.ID}',
			'{@GUI.KEY}',
			'0',
			'{@SYS.HOST_URL}',
			'0'
		)
		</og:tableUpdate>

		<!-- 以下自動実行の設定 -->
		<og:value command="SQL">
			SELECT COUNT(*) AS CNT FROM GE12
				WHERE SYSTEM_ID = '{@SYS.SYSTEM_ID}'
				AND   PARAM_ID = 'CONTEXT_INITIAL_CALL_URL_REPORT2_DAEMON'
				AND   FGJ = '1'
				AND   CONTXT_PATH = '{@SYS.HOST_URL}'
		</og:value>

		<!-- 存在しなければ、追加 -->
		<og:equals val1="{@CNT}" val2="0" >
		  <og:query command="NEW" debug="{@debug}" maxRowCount="{@maxRowCount}">
				INSERT INTO GE12
					(SYSTEM_ID
					,PARAM_ID
					,PARAM,PARAM_LVL,TITLE,CONTENTS,SEQNO,KBSAKU,
					 FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD,CONTXT_PATH)
				VALUES
					('{@SYS.SYSTEM_ID}'
					,'CONTEXT_INITIAL_CALL_URL_REPORT2_DAEMON'
					,'<og:link href="{@REQ.Scheme}://{@SYS.HOST_URL}jsp/REP21/result2.jsp" hrefOnly="true" useGamenId="false"
						keys="command,SYSTEM_ID,DMN_GRP,CMD,NAME,PERIOD"
						vals="NEW,GE,'',SET,REPORT2_DAEMON,5" />'
					,'7','','','1000','1'
					,'1','{@USER.YMDH}','{@USER.YMDH}','{@USER.ID}','{@USER.ID}','{@GUI.KEY}','{@SYS.HOST_URL}')
		  </og:query>

	<!-- {@SYS.CONTEXT_URL} で、ｻｰﾊﾞｰ名だと、逆引きできない環境では動かない
					,'<og:link href="{@SYS.CONTEXT_URL}jsp/REP21/result2.jsp" hrefOnly="true" useGamenId="false"
						keys="command,SYSTEM_ID,DMN_GRP,CMD,NAME,PERIOD"
						vals="NEW,GE,'',SET,REPORT2_DAEMON,5" />'
	-->

		</og:equals>
		<!-- デーモンを実行します -->
		<og:schedule
			command		= "SET"
			scope		= "request"
			timerTask	= "org.opengion.plugin.daemon.Daemon_Report2"
			name		= "REPORT2_DAEMON"
			comment		= "Start-up By {@USER.INFO}"
			singleton	= "true"
			delay		= "0"
			period		= "5000"
			fixedDelay	= "true"
			keys		= "DEBUG"
			vals		= "{@debug}"
		/>
	</og:equals>

	<!-- 特定スレッド一時停止時の動作 -->
	<og:equals val1="{@action}" val2="stop">
		<og:tableUpdate
			command		= "{@command}"
			queryType	= "JDBCTableUpdate"
		>
			UPDATE	GE12
				SET		PARAM = 'STP_' {@DBF.CON} [THREAD]
				WHERE	SYSTEM_ID	= '{@SYS.SYSTEM_ID}'
				AND		PARAM		= 'RUN_' {@DBF.CON} [THREAD]
				AND		CONTXT_PATH = [CONTXT_PATH]
				AND		PARAM_ID 	like ('REPORT2_HANDLE_DAEMON_%')
				AND		FGJ			= '1'
		</og:tableUpdate>

		<!-- 選択スレッド停止 -->
		<og:value command="SETTBL" key="THREAD" action="APPEND" />

		<c:forTokens items="${THREAD}" delims="," var="SYS_THREAD" >
				<jsp:scriptlet>
						ExecThreadManager.finishThread( pageContext.getAttribute( "SYS_THREAD", PageContext.PAGE_SCOPE ).toString() );
				</jsp:scriptlet>
		</c:forTokens>
	</og:equals>

	<!-- 除外時の動作 -->
	<og:equals val1="{@action}" val2="omit" >
		<og:tableUpdate
			command		= "{@command}"
			queryType	= "JDBCTableUpdate"
		>
			DELETE FROM GE12
				WHERE	SYSTEM_ID	= '{@SYS.SYSTEM_ID}'
				AND		PARAM		like '%' {@DBF.CON} [THREAD]
				AND		CONTXT_PATH like [CONTXT_PATH]
				AND		PARAM_ID 	like 'REPORT2_HANDLE_DAEMON_%'
				AND		FGJ			= '1'
		</og:tableUpdate>

		<!-- 選択スレッド停止 -->
		<og:value command="SETTBL" key="THREAD" action="APPEND" />

		<c:forTokens items = "${THREAD}" delims = "," var = "SYS_THREAD" >
				<jsp:scriptlet>
						ExecThreadManager.finishThread( pageContext.getAttribute( "SYS_THREAD", PageContext.PAGE_SCOPE ).toString() );
				</jsp:scriptlet>
		</c:forTokens>
	</og:equals>
</og:transaction>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
