<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<jsp:directive.page import="java.util.Map" />
<jsp:directive.page import="org.opengion.hayabusa.report2.ExecThreadManager" />
<jsp:directive.page import="org.opengion.hayabusa.report2.ProcessFactory" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE"
	pgid     = "REP21"
	title    = "新帳票起動・停止"
	date     = "2008/10/14"
	author   = "M.Takahashi"
	text     = "新規作成"
	version  = "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "DMN_GRP"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="NEW" debug="{@debug}" maxRowCount="{@maxRowCount}" quotCheck="false">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		SELECT
			A.SYSTEM_ID
			,A.DMN_GRP
			,'' CONTXT_PATH
			,'' PROCESSING
			,A.SYSTEM_ID{@DBF.CON}'_'{@DBF.CON}A.DMN_GRP AS THREAD
		FROM GE53 A
		WHERE 	A.FGJ = '1'
	<og:where startKey="AND">
		<og:and value = "DMN_GRP	like	'{@DMN_GRP}'" />
		<og:and value = "SYSTEM_ID	=		'{@SYSTEM_ID}'" />
	</og:where>
		GROUP BY SYSTEM_ID,DMN_GRP
		ORDER BY SYSTEM_ID,DMN_GRP
</og:query>

<og:equals val1="{@CONTXT_PATH}{@PROCESSING}" notNull="true">
	<og:value command="SET" key="INNER_JOIN" value="true" />
</og:equals>
<og:tableFilter classId="DBSELECT" selectedAll="true" keys="INNER_JOIN" vals="{@INNER_JOIN}" >
	select
		A.CONTXT_PATH
		,CASE
			WHEN A.PARAM like '%STP_%' THEN '9'
			WHEN A.PARAM like '%RUN_%' THEN '1'
		ELSE '0'
		END AS PROCESSING
	from GE12 A
	where A.PARAM_ID = 'REPORT2_HANDLE_DAEMON_'{@DBF.CON}[SYSTEM_ID]{@DBF.CON}'_'{@DBF.CON}[DMN_GRP]
	and A.SYSTEM_ID  = '{@SYS.SYSTEM_ID}'
	and A.FGJ = '1'
	<og:where startKey="and">
		<og:and value = "A.CONTXT_PATH  like '{@CONTXT_PATH}'" />
	</og:where>
	order by A.CONTXT_PATH
</og:tableFilter>

<og:viewLink command="{@command}">
	<og:link column="DMN_GRP" gamenId="REP04" href="index.jsp" target="CONTENTS"
		keys="DMN_GRP,command" vals="[DMN_GRP],NEW" />
</og:viewLink>

<og:viewMarker command="{@command}">
	<og:columnMarker column="PROCESSING" onMark="[PROCESSING]" markList="1" >
		<span style="background-color:cornflowerblue">[PROCESSING]</span>
	</og:columnMarker>
	<og:columnMarker column="PROCESSING" onMark="[PROCESSING]" markList="9" >
		<span style="background-color:tomato">[PROCESSING]</span>
	</og:columnMarker>
	<og:columnMarker column="CONTXT_PATH" onMark="[CONTXT_PATH]" markList="{@SYS.HOST_URL}" >
		<strong>[CONTXT_PATH]</strong>
	</og:columnMarker>
</og:viewMarker>

<!-- ２重押し防止 oneClick()関数は、useAjaxSubmit='true' 使用時には使えません。 -->
<form method="POST" action="forward.jsp" target="RESULT">

	<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
	<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:writeCheck>
		<og:submit value="entry" command="ENTRY" lbl="START" accesskey="E" keys="action" vals="entry" />
		<og:submit value="entry" command="ENTRY" lbl="STOP"  accesskey="S" keys="action" vals="stop" />
		<og:submit value="entry" command="ENTRY" lbl="OMIT"  accesskey="J" keys="action" vals="omit" />

		<og:submit value="result2" lbl="DAEMON_STOP" keys="CMD" vals="CANCEL" />
		<og:submit value="result2" lbl="VIEW"        keys="CMD" vals="VIEW" />
	</og:writeCheck>

	<div>
	<og:message lbl="MSG0078"/>
	</div>
	<!-- DB検索結果を表示させます。 -->
	<!-- checked="true" で、チェック済みの状態で表示できます。 -->
	<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
	<og:view
		viewFormType = "HTMLTable"
		command    = "{@command}"
		noDisplay  = "THREAD"
		checked    = "{@checked}"
		startNo    = "{@startNo}"
		pageSize   = "{@pageSize}"
	/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
