/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.opengion.fukurou.process.ChainProcess;
import org.opengion.fukurou.process.FirstProcess;
import org.opengion.fukurou.process.HybsProcess;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.LoggerProcess;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.process.Process_Logger;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.StringUtil;

public final class MainProcess
implements Runnable {
    public static final int RETURN_INIT = -1;
    public static final int RETURN_OK = 0;
    public static final int RETURN_WARN = 1;
    public static final int RETURN_NG = 2;
    private List<HybsProcess> list;
    private ParamProcess param;
    private LoggerProcess logger;
    private int kekka = -1;

    public void setList(List<HybsProcess> list) {
        if (list == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306e List \u306b\u3001null \u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        this.list = new ArrayList<HybsProcess>(list);
    }

    private void init() {
        if (this.list == null) {
            throw new OgRuntimeException("\u30ea\u30b9\u30c8 \u304c null \u3067\u3059\u3002\u307e\u305a\u3001setList( List<HybsProcess> ) \u304c\u5fc5\u8981\u3067\u3059\u3002");
        }
        try {
            HybsProcess hybsProcess = this.list.get(0);
            if (hybsProcess instanceof LoggerProcess) {
                this.logger = (LoggerProcess)hybsProcess;
                this.logger.init(null);
                this.list.remove(0);
                hybsProcess = this.list.get(0);
            } else {
                this.logger = new Process_Logger();
                this.logger.putArgument("logFile", "System.out");
                this.logger.putArgument("dispFile", "System.out");
                this.logger.init(null);
            }
            if (hybsProcess instanceof ParamProcess) {
                this.param = (ParamProcess)hybsProcess;
                this.param.setLoggerProcess(this.logger);
                this.param.init(null);
                this.list.remove(0);
            }
        }
        catch (Throwable throwable) {
            StringBuilder stringBuilder = new StringBuilder(200).append("\u521d\u671f\u5316\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002").append(HybsConst.CR).append(throwable.getMessage());
            String string = stringBuilder.toString();
            this.logger.errLog(string, throwable);
            LogWriter.log(string);
            if (this.param != null) {
                this.param.end(false);
            }
            this.logger.end(false);
            throw new OgRuntimeException(string, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        this.init();
        long l = System.currentTimeMillis();
        this.logger.logging("=================================================================");
        this.logger.logging(new Date(l) + " \u51e6\u7406\u3092\u958b\u59cb\u3057\u307e\u3059\u3002");
        this.logger.logging(this.getClass().getName());
        this.kekka = 2;
        LineModel lineModel = null;
        int n = 0;
        int n2 = this.list.size();
        try {
            this.logger.logging("\u521d\u671f\u5316\u51e6\u7406\u3092\u884c\u3044\u307e\u3059\u3002");
            for (int i = 0; i < n2; ++i) {
                object = this.list.get(i);
                object.setLoggerProcess(this.logger);
                object.init(this.param);
            }
            this.logger.logging("Process \u3092\u5b9f\u884c\u3057\u307e\u3059\u3002");
            FirstProcess firstProcess = (FirstProcess)this.list.get(0);
            while (firstProcess.next()) {
                lineModel = firstProcess.makeLineModel(n);
                for (int i = 1; i < n2 && lineModel != null; ++i) {
                    ChainProcess chainProcess = (ChainProcess)this.list.get(i);
                    lineModel = chainProcess.action(lineModel);
                }
                if (++n % 50 == 0) {
                    System.err.print(".");
                }
                if (n % 1000 != 0) continue;
                System.err.println("  Count=[" + n + "]");
            }
            this.kekka = 0;
            this.logger.logging("  Total=[" + n + "]");
            System.err.println("  Total=[" + n + "]");
        }
        catch (Throwable throwable) {
            HybsProcess hybsProcess;
            try {
                this.kekka = 2;
                StringBuilder stringBuilder = new StringBuilder(200).append(HybsConst.CR).append("\u30c7\u30fc\u30bf\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 [").append(n).append("]\u884c\u76ee").append(HybsConst.CR).append(throwable.getMessage()).append(HybsConst.CR);
                if (lineModel != null) {
                    stringBuilder.append(lineModel.toString()).append(HybsConst.CR);
                }
                for (int i = 0; i < n2; ++i) {
                    hybsProcess = this.list.get(i);
                    stringBuilder.append(hybsProcess.toString());
                }
                String string = stringBuilder.toString();
                this.logger.errLog(string, throwable);
                LogWriter.log(string);
            }
            catch (Throwable throwable2) {
                this.logger.logging("\u7d42\u4e86\u51e6\u7406\u3092\u884c\u3044\u307e\u3059\u3002");
                StringBuilder stringBuilder = new StringBuilder(200);
                if (this.param != null) {
                    stringBuilder.append(this.logger.report()).append(HybsConst.CR);
                    stringBuilder.append(this.param.report());
                }
                boolean bl = this.kekka == 0;
                for (int i = 0; i < n2; ++i) {
                    HybsProcess hybsProcess2 = this.list.get(i);
                    if (hybsProcess2 == null) continue;
                    stringBuilder.append(HybsConst.CR).append(hybsProcess2.report());
                    hybsProcess2.end(bl);
                }
                if (this.param != null) {
                    this.param.end(bl);
                }
                stringBuilder.append(HybsConst.CR);
                this.logger.logging(stringBuilder.toString());
                this.logger.logging("\u5b9f\u884c\u7d50\u679c\u306f\u3001[" + this.errCode(this.kekka) + "] \u3067\u3059\u3002");
                long l2 = System.currentTimeMillis();
                this.logger.logging("\u5408\u8a08\u51e6\u7406\u6642\u9593 = " + (l2 - l) + " (ms) \u3067\u3059\u3002");
                this.logger.logging(new Date(l2) + " \u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
                this.logger.end(bl);
                throw throwable2;
            }
            this.logger.logging("\u7d42\u4e86\u51e6\u7406\u3092\u884c\u3044\u307e\u3059\u3002");
            StringBuilder stringBuilder = new StringBuilder(200);
            if (this.param != null) {
                stringBuilder.append(this.logger.report()).append(HybsConst.CR);
                stringBuilder.append(this.param.report());
            }
            boolean bl = this.kekka == 0;
            for (int i = 0; i < n2; ++i) {
                hybsProcess = this.list.get(i);
                if (hybsProcess == null) continue;
                stringBuilder.append(HybsConst.CR).append(hybsProcess.report());
                hybsProcess.end(bl);
            }
            if (this.param != null) {
                this.param.end(bl);
            }
            stringBuilder.append(HybsConst.CR);
            this.logger.logging(stringBuilder.toString());
            this.logger.logging("\u5b9f\u884c\u7d50\u679c\u306f\u3001[" + this.errCode(this.kekka) + "] \u3067\u3059\u3002");
            long l3 = System.currentTimeMillis();
            this.logger.logging("\u5408\u8a08\u51e6\u7406\u6642\u9593 = " + (l3 - l) + " (ms) \u3067\u3059\u3002");
            this.logger.logging(new Date(l3) + " \u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
            this.logger.end(bl);
        }
        this.logger.logging("\u7d42\u4e86\u51e6\u7406\u3092\u884c\u3044\u307e\u3059\u3002");
        object = new StringBuilder(200);
        if (this.param != null) {
            ((StringBuilder)object).append(this.logger.report()).append(HybsConst.CR);
            ((StringBuilder)object).append(this.param.report());
        }
        boolean bl = this.kekka == 0;
        for (int i = 0; i < n2; ++i) {
            HybsProcess hybsProcess = this.list.get(i);
            if (hybsProcess == null) continue;
            ((StringBuilder)object).append(HybsConst.CR).append(hybsProcess.report());
            hybsProcess.end(bl);
        }
        if (this.param != null) {
            this.param.end(bl);
        }
        ((StringBuilder)object).append(HybsConst.CR);
        this.logger.logging(((StringBuilder)object).toString());
        this.logger.logging("\u5b9f\u884c\u7d50\u679c\u306f\u3001[" + this.errCode(this.kekka) + "] \u3067\u3059\u3002");
        long l4 = System.currentTimeMillis();
        this.logger.logging("\u5408\u8a08\u51e6\u7406\u6642\u9593 = " + (l4 - l) + " (ms) \u3067\u3059\u3002");
        this.logger.logging(new Date(l4) + " \u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
        this.logger.end(bl);
    }

    public int getKekka() {
        return this.kekka;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            LogWriter.log(MainProcess.usage());
            return;
        }
        List<HybsProcess> list = MainProcess.makeHybsProcessList(stringArray);
        MainProcess mainProcess = new MainProcess();
        mainProcess.setList(list);
        mainProcess.run();
        System.exit(mainProcess.getKekka());
    }

    private static List<HybsProcess> makeHybsProcessList(String ... stringArray) {
        ArrayList<HybsProcess> arrayList = new ArrayList<HybsProcess>();
        HybsProcess hybsProcess = null;
        Argument argument = new Argument(MainProcess.class.getName());
        block5: for (int i = 0; i < stringArray.length; ++i) {
            int n = argument.getArgumentType(stringArray[i]);
            switch (n) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    hybsProcess = (HybsProcess)StringUtil.newInstance(stringArray[i]);
                    arrayList.add(hybsProcess);
                    continue block5;
                }
                case 2: {
                    if (hybsProcess == null) continue block5;
                    hybsProcess.putArgument(stringArray[i]);
                    continue block5;
                }
            }
        }
        return arrayList;
    }

    public String errCode(int n) {
        return switch (n) {
            case -1 -> "\u521d\u671f\u5316";
            case 0 -> "\u6b63\u5e38";
            case 1 -> "\u8b66\u544a";
            case 2 -> "\u7570\u5e38";
            default -> "\u672a\u5b9a\u7fa9\u30a8\u30e9\u30fc";
        };
    }

    private static String usage() {
        StringBuilder stringBuilder = new StringBuilder(200).append("ChainProcess \u3092\u5b9f\u88c5\u3057\u305f\u5404\u30af\u30e9\u30b9\u3092\u3001\u9806\u6b21\u5b9f\u884c\u3057\u307e\u3059\u3002").append(HybsConst.CR).append("\u30ad\u30fc\u3068\u5024\u306e\u9593\u306b\u306f\u3001\u30b9\u30d9\u30fc\u30b9\u3092\u5165\u308c\u306a\u3044\u3067\u4e0b\u3055\u3044\u3002").append(HybsConst.CR).append(HybsConst.CR).append("Usage: java org.opengion.fukurou.process.MainProcess \u30b5\u30d6ChainProcess\u30af\u30e9\u30b9 [[-\u30ad\u30fc=\u5024] \uff65\uff65\uff65] [\uff65\uff65\uff65]  ").append(HybsConst.CR).append("   \u30b5\u30d6ChainProcess\u30af\u30e9\u30b9 \uff1aChainProcess \u3092\u5b9f\u88c5\u3057\u305f\u30af\u30e9\u30b9").append(HybsConst.CR).append("     -\u30ad\u30fc=\u5024             \uff1a\u5404\u30b5\u30d6\u30af\u30e9\u30b9\u6bce\u306e\u5f15\u6570\u3002 - \u3067\u59cb\u307e\u308a\u3001= \u3067\u5206\u5272\u3057\u307e\u3059\u3002").append(HybsConst.CR).append("     -AAA=BBB             \uff1a\u8907\u6570\u6307\u5b9a\u3067\u304d\u307e\u3059\u3002").append(HybsConst.CR).append("   \u30b5\u30d6ChainProcess\u30af\u30e9\u30b9 \uff1a\u8907\u6570\u6307\u5b9a\u3067\u304d\u307e\u3059\u3002").append(HybsConst.CR).append("     -CCC=DDD ").append(HybsConst.CR);
        return stringBuilder.toString();
    }
}

