/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;

public class QrcodeImage
extends Component {
    private static final String VERSION = "8.4.1.0 (2023/02/10)";
    private static final long serialVersionUID = 841020230210L;
    public static final int DEF_VERSION = 5;
    public static final int MARGIN = 4;
    public static final int PIXEL = 3;
    public static final String IMAGE_TYPE = "PNG";
    private String qrData;
    private String saveFile;
    private String imgType = "PNG";
    private ErrCrct errCo = ErrCrct.DEF;
    private int version = 5;
    private String txtEnc;
    private int imageSize;

    public void init(String string, String string2) {
        this.init(string, string2, 5, ErrCrct.DEF, IMAGE_TYPE, 3, this.txtEnc);
    }

    public void init(String string, String string2, int n) {
        this.init(string, string2, n, ErrCrct.DEF, IMAGE_TYPE, 3, this.txtEnc);
    }

    public void init(String string, String string2, int n, ErrCrct errCrct, String string3, int n2, String string4) {
        this.qrData = string;
        this.saveFile = string2;
        this.imgType = string3;
        this.errCo = errCrct;
        this.version = n;
        this.txtEnc = string4;
        this.imageSize = (25 + n * 4) * n2;
    }

    public void saveImage() {
        try {
            BufferedImage bufferedImage;
            if (this.qrData == null || this.qrData.isEmpty()) {
                bufferedImage = new BufferedImage(this.imageSize, this.imageSize, 4);
            } else {
                String string = this.txtEnc == null || this.txtEnc.isEmpty() ? HybsConst.DEFAULT_CHARSET.displayName() : this.txtEnc;
                HashMap<EncodeHintType, Object> hashMap = new HashMap<EncodeHintType, Object>();
                hashMap.put(EncodeHintType.QR_VERSION, this.version);
                hashMap.put(EncodeHintType.ERROR_CORRECTION, Character.valueOf(this.errCo.getCh()));
                hashMap.put(EncodeHintType.CHARACTER_SET, string);
                QRCodeWriter qRCodeWriter = new QRCodeWriter();
                BitMatrix bitMatrix = qRCodeWriter.encode(this.qrData, BarcodeFormat.QR_CODE, this.imageSize, this.imageSize, hashMap);
                bufferedImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
            }
            ImageIO.write((RenderedImage)bufferedImage, this.imgType, new File(this.saveFile));
        }
        catch (WriterException writerException) {
            String string = "QR\u30b3\u30fc\u30c9\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002Data=[" + this.qrData + "]";
            throw new OgRuntimeException(string, writerException);
        }
        catch (IOException iOException) {
            String string = "\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002File=[" + this.saveFile + "]";
            throw new OgRuntimeException(string, iOException);
        }
    }

    public static enum ErrCrct {
        L(1),
        M(0),
        Q(3),
        H(2);

        private int no;
        public static final ErrCrct DEF;

        private ErrCrct(int n2) {
            this.no = n2;
        }

        public int getNo() {
            return this.no;
        }

        public char getCh() {
            return switch (this) {
                case L -> 'L';
                case Q -> 'Q';
                case H -> 'H';
                default -> 'M';
            };
        }

        public static ErrCrct get(char c) {
            return switch (c) {
                case 'L' -> L;
                case 'Q' -> Q;
                case 'H' -> H;
                default -> M;
            };
        }

        static {
            DEF = M;
        }
    }
}

