/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.model.POIUtil;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.ArraySet;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.fukurou.util.ZipArchive;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.io.HybsFileOperationFactory;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class FileTag
extends CommonTagSupport {
    private static final String VERSION = "8.0.1.0 (2021/10/29)";
    private static final long serialVersionUID = 801020211029L;
    public static final String ACT_CANREAD = "canRead";
    public static final String ACT_CANWRITE = "canWrite";
    public static final String ACT_CREATENEWFILE = "createNewFile";
    public static final String ACT_DELETE = "delete";
    public static final String ACT_EXISTS = "exists";
    public static final String ACT_ISDIRECTORY = "isDirectory";
    public static final String ACT_ISFILE = "isFile";
    public static final String ACT_ISHIDDEN = "isHidden";
    public static final String ACT_MKDIR = "mkdir";
    public static final String ACT_MKDIRS = "mkdirs";
    public static final String ACT_RENAMETO = "renameTo";
    public static final String ACT_READ = "read";
    public static final String ACT_EXISTSLENGTH = "existsLength";
    public static final String ACT_COPY = "copy";
    public static final String ACT_COPYST = "copyST";
    public static final String ACT_LIST = "list";
    public static final String ACT_ZIP = "zip";
    public static final String ACT_TIMESTAMP = "timeStamp";
    private static final Set<String> ACTION_SET = new ArraySet((Object[])new String[]{"canRead", "canWrite", "createNewFile", "delete", "exists", "isDirectory", "isFile", "isHidden", "mkdir", "mkdirs", "renameTo", "read", "existsLength", "copy", "copyST", "list", "zip", "timeStamp"});
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String file1 = "";
    private String file2;
    private String action;
    private boolean rtnCode;
    private boolean notEquals;
    private boolean useStop = true;
    private String encode;
    private boolean fromLocal;
    private boolean toLocal;
    private boolean useLocal;

    @Override
    public int doStartTag() {
        if (this.useTag()) {
            if (this.useLocal) {
                this.fromLocal = true;
                this.toLocal = true;
            }
            try {
                this.rtnCode = this.notEquals ^ this.actionExec(this.action);
            }
            catch (IOException iOException) {
                String string = "\u6307\u5b9a\u306e\uff71\uff78\uff7c\uff6e\uff9d\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\uff61\uff71\uff78\uff7c\uff6e\uff9d\uff74\uff97\uff70" + CR + "\t  action=[" + this.action + "]" + CR + "\t  fileURL=[" + this.fileURL + "]" + CR + "\t  file1=[" + this.file1 + "]" + CR + "\t  file2=[" + this.file2 + "]" + CR;
                throw new HybsSystemException(string, iOException);
            }
            if (this.rtnCode) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        return this.useTag() && this.useStop && !this.rtnCode ? 5 : 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.file1 = "";
        this.file2 = null;
        this.action = null;
        this.rtnCode = false;
        this.notEquals = false;
        this.useStop = true;
        this.encode = null;
        this.fromLocal = false;
        this.useLocal = false;
        this.toLocal = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean actionExec(String string) throws IOException {
        if (string == null) {
            String string2 = "\uff71\uff78\uff7c\uff6e\uff9d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff61\uff71\uff78\uff7c\uff6e\uff9d NULL \uff74\uff97\uff70" + CR + "\t  file=[" + this.file1 + "]" + CR + "\t  matches=[" + this.file2 + "]" + CR;
            throw new HybsSystemException(string2);
        }
        String string3 = HybsSystem.url2dir(this.fileURL);
        FileOperation fileOperation = HybsFileOperationFactory.create(this.fromLocal, StringUtil.urlAppend((CharSequence)string3, (CharSequence[])new CharSequence[]{this.file1}));
        boolean bl = false;
        if (ACT_CANREAD.equalsIgnoreCase(string)) {
            return fileOperation.canRead();
        }
        if (ACT_CANWRITE.equalsIgnoreCase(string)) {
            return fileOperation.canWrite();
        }
        if (ACT_CREATENEWFILE.equalsIgnoreCase(string)) {
            return fileOperation.createNewFile();
        }
        if (ACT_DELETE.equalsIgnoreCase(string)) {
            return FileUtil.deleteFiles((File)fileOperation);
        }
        if (ACT_EXISTS.equalsIgnoreCase(string)) {
            return fileOperation.exists();
        }
        if (ACT_ISDIRECTORY.equalsIgnoreCase(string)) {
            return fileOperation.isDirectory();
        }
        if (ACT_ISFILE.equalsIgnoreCase(string)) {
            return fileOperation.isFile();
        }
        if (ACT_ISHIDDEN.equalsIgnoreCase(string)) {
            return fileOperation.isHidden();
        }
        if (ACT_MKDIR.equalsIgnoreCase(string)) {
            if (!fileOperation.isDirectory()) return fileOperation.mkdir();
            return true;
        }
        if (ACT_MKDIRS.equalsIgnoreCase(string)) {
            if (!fileOperation.isDirectory()) return fileOperation.mkdirs();
            return true;
        }
        if (ACT_RENAMETO.equalsIgnoreCase(string)) {
            if (this.file2 == null) return bl;
            FileOperation fileOperation2 = HybsFileOperationFactory.create(this.fromLocal, StringUtil.urlAppend((CharSequence)string3, (CharSequence[])new CharSequence[]{this.file2}));
            if (!fileOperation2.exists()) return fileOperation.renameTo((File)fileOperation2);
            if (fileOperation2.delete()) return fileOperation.renameTo((File)fileOperation2);
            String string4 = "\u6240\u5b9a\u306e\uff8c\uff67\uff72\uff99\u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff61[" + (File)fileOperation2 + "]";
            throw new OgRuntimeException(string4);
        }
        if (ACT_READ.equalsIgnoreCase(string)) {
            String string5;
            if (!fileOperation.isFile()) {
                String string6 = "\uff8c\uff67\uff72\uff99\u304c\u5b58\u5728\u3057\u306a\u3044\u304b\uff64\uff8c\uff67\uff72\uff99\u3067\u306f\u3042\u308a\u307e\u305b\u3093\uff61" + CR + "\t  action=[" + string + "]" + CR + "\t  fileURL=[" + this.fileURL + "]" + CR + "\t  directory=[" + string3 + "]" + CR + "\t  file1=[" + this.file1 + "]" + CR;
                throw new HybsSystemException(string6);
            }
            if (POIUtil.isPOI((File)fileOperation)) {
                string5 = POIUtil.extractor((File)fileOperation);
            } else {
                String string7 = this.encode == null ? "UTF-8" : this.encode;
                string5 = POIUtil.extractor((File)fileOperation, (String)string7);
            }
            bl = true;
            this.setRequestAttribute(ACT_READ, string5);
            return bl;
        }
        if (ACT_EXISTSLENGTH.equalsIgnoreCase(string)) {
            if (!fileOperation.exists()) return false;
            if (fileOperation.length() <= 0L) return false;
            return true;
        }
        if (ACT_COPY.equalsIgnoreCase(string) && this.file2 != null) {
            FileOperation fileOperation3 = HybsFileOperationFactory.create(this.toLocal, StringUtil.urlAppend((CharSequence)string3, (CharSequence[])new CharSequence[]{this.file2}));
            if (fileOperation.exists()) {
                return FileUtil.copy((File)fileOperation, (File)fileOperation3);
            }
            String string8 = "copy\u5143(file1)\u306e\uff8c\uff67\uff72\uff99\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\uff61" + CR + "\t  action=[" + string + "]" + CR + "\t  fileURL=[" + this.fileURL + "]" + CR + "\t  directory=[" + string3 + "]" + CR + "\t  file1=[" + this.file1 + "]" + CR + "\t  file2=[" + this.file2 + "]" + CR;
            throw new HybsSystemException(string8);
        }
        if (ACT_COPYST.equalsIgnoreCase(string) && this.file2 != null) {
            String string9 = StringUtil.urlAppend((CharSequence)string3, (CharSequence[])new CharSequence[]{this.file2});
            File file = new File(string9);
            ServletContext servletContext = this.pageContext.getServletContext();
            bl = FileUtil.copy((InputStream)servletContext.getResourceAsStream(this.file1), (File)file);
            if (!bl) {
                String string10 = string + " \uff71\uff78\uff7c\uff6e\uff9d\u304c\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff61" + CR + "\t  action=[" + string + "]" + CR + "\t  fileURL=[" + this.fileURL + "]" + CR + "\t  directory=[" + string3 + "]" + CR + "\t  file1=[" + this.file1 + "]" + CR + "\t  file2=[" + this.file2 + "]" + CR;
                throw new HybsSystemException(string10);
            }
            FileOperation fileOperation4 = HybsFileOperationFactory.create(this.toLocal, string9);
            if (!fileOperation4.isCloud()) return bl;
            FileUtil.copy((File)file, (File)fileOperation4);
            file.delete();
            return bl;
        }
        if (ACT_LIST.equalsIgnoreCase(string)) {
            String[] stringArray;
            if (fileOperation.isDirectory()) {
                stringArray = fileOperation.list();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = fileOperation.getName();
            }
            String[] stringArray3 = stringArray;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray3 != null) {
                boolean bl2 = this.file2 == null || this.file2.isEmpty();
                for (String string11 : stringArray3) {
                    if (!bl2 && !string11.matches(this.file2)) continue;
                    arrayList.add(string11);
                }
            }
            this.setRequestAttribute(ACT_LIST, arrayList);
            return true;
        }
        if (ACT_ZIP.equalsIgnoreCase(string) && this.file2 != null) {
            File file;
            File file2;
            if (this.file2.toLowerCase(Locale.JAPAN).indexOf(".zip") < 0) {
                this.file2 = this.file2 + ".zip";
            }
            if ((file2 = (file = new File(StringUtil.urlAppend((CharSequence)string3, (CharSequence[])new CharSequence[]{this.file2}))).getParentFile()) == null || !file2.exists() && !file2.mkdirs()) {
                String string12 = "zipFile\uff8c\uff67\uff72\uff99\u306e\u89aa\uff8c\uff6b\uff99\uff80\uff9e\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff61" + CR + " zipFile=[" + file + "]" + CR;
                throw new HybsSystemException(string12);
            }
            List list = ZipArchive.compress((File)fileOperation, (File)file);
            if (list.isEmpty()) return false;
            return true;
        }
        if (!ACT_TIMESTAMP.equalsIgnoreCase(string)) return bl;
        return fileOperation.setLastModified(System.currentTimeMillis());
    }

    public void setAction(String string) {
        this.action = this.getRequestParameter(string);
        if (!this.check(this.action, ACTION_SET)) {
            String string2 = "\u6307\u5b9a\u306e\uff71\uff78\uff7c\uff6e\uff9d\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\uff61\uff71\uff78\uff7c\uff6e\uff9d\uff74\uff97\uff70" + CR + "\t  action=[" + this.action + "]" + CR + "\t  actionList=" + String.join((CharSequence)", ", ACTION_SET);
            throw new HybsSystemException(string2);
        }
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.fileURL = StringUtil.urlAppend((CharSequence)this.fileURL, (CharSequence[])new CharSequence[]{string2});
        }
    }

    public void setFile1(String string) {
        this.file1 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.file1);
    }

    public void setFile2(String string) {
        this.file2 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.file2);
    }

    public void setNotEquals(String string) {
        this.notEquals = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.notEquals);
    }

    public void setUseStop(String string) {
        this.useStop = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useStop);
    }

    public void setEncode(String string) {
        this.encode = StringUtil.nval((String)this.getRequestParameter(string), (String)this.encode);
    }

    public void setUseLocal(String string) {
        this.useLocal = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useLocal);
    }

    public void setFromLocal(String string) {
        this.fromLocal = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.fromLocal);
    }

    public void setToLocal(String string) {
        this.toLocal = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.toLocal);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("fileURL", (Object)this.fileURL).println("file1", (Object)this.file1).println("file2", (Object)this.file2).println("action", (Object)this.action).println("rtnCode", (Object)this.rtnCode).println("notEquals", (Object)this.notEquals).println("useStop", (Object)this.useStop).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

