<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="query" >
	<script>
		function check(value){
			if(value == "RSC"){
				document.getElementById("KBSAKU"		).disabled = false;
				document.getElementById("RELEASE_NOTES"	).disabled = false;
				document.getElementById("RDC_CODE"		).disabled = false;
			}
			else if( value == "SYS" ) {
				document.getElementById("KBSAKU"		).disabled = false;
				document.getElementById("RELEASE_NOTES"	).disabled = true;
				document.getElementById("RDC_CODE"		).disabled = true;
			}
			else if( value == "RPT" ) {
				document.getElementById("KBSAKU"		).disabled = true;
				document.getElementById("RELEASE_NOTES"	).disabled = false;
				document.getElementById("RDC_CODE"		).disabled = false;
			}
			else if( value == "RPD" ) {
				document.getElementById("KBSAKU"		).disabled = true;
				document.getElementById("RELEASE_NOTES"	).disabled = true;
				document.getElementById("RDC_CODE"		).disabled = true;
			}
		}
	</script>
</og:head>

<jsp:directive.include file="/jsp/custom/query_info.jsp" />
<og:comment
	system	= "GE:エンジンサンプル"
	pgid	= "GE0009"
	title	= "XML抜き出し"
	date	= "2007/12/12"
	author	= "K.HASEGAWA"
	text	= "ZZZZ"
	version	= "001"
/>

<form method="GET" action="forward.jsp" target="RESULT" onSubmit="timeSet();">
	<table >
		<tr>
			<og:column name="SYSTEM_ID" defaultVal="{@U_SYSID}" must="true" >
				<og:text caseKey="{@USER.roles}" caseVal="root" >
					(<og:input type="checkbox" name="AST" value="**" lbl="**" td="no" checked="{@NN.AST checked}" />)
				</og:text>
			</og:column>
			<og:select name="TargetDB"	lbl="Target DB" must="true" onChange="check(value);" >
				<og:option value="RSC"	lbl="Resource"		selected="selected" />
				<og:option value="SYS"	lbl="System,User"	/>
				<og:option value="RPT"	lbl="Report"		/>
				<og:option value="RPD"	lbl="ReportData"	/>
			</og:select>
			<og:column name="KBSAKU" defaultVal="null" />
			<og:column name="SUBSYS" aimai="V*" />
			<og:space width="10px" />
			<og:input name="VIEW" type="checkbox" value="true" />
			<og:space width="10px" />
			<og:column name="ZIP_FILE" lbl="MSG0052" size="10" >.zip</og:column>	<!-- MSG0052:ZIP圧縮 -->
			<og:select name="EXT_SQL" lbl="ExtendSQL" >
				<og:option value="MERGE"	lbl="Merge SQL"		selected="selected" />
				<og:option value="DELETE"	lbl="All Delete"	/>
			</og:select>
		</tr>
	</table>

	<!-- 7.4.0.1 (2021/04/16) 状態フラグの初期値をクリアする為 -->
	<og:value key="FGJ" value="_" />												<!-- 状態フラグ	-->
	<jsp:directive.include file="/jsp/custom/releaseNotes.jsp" />

	<og:queryButton maxRowCount="0" />

	<og:hideMenu>
		<table>
			<tr>
				<og:column name="DBID" codeKeyVal="{@DBID_INFO}" />
				<og:space width="10px" />
				<og:input type="checkbox" name="CDKH" value="is not null" />
				<og:space width="10px" />
				<og:input type="checkbox" name="DEL" value="true" checked="checked" lbl="{@LBL.OUT_DIR} {@LBL.MSG0058}" />	<!-- OUT_DIR:出力ﾌｧｲﾙDIR MSG0058:削除 -->
			</tr>
		</table>
	</og:hideMenu>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
