/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.List;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.model.FileOperationFactory;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.system.ThrowUtil;
import org.opengion.fukurou.util.FileInfo;

public final class FileUtil {
    private static final NonClosePrintWriter OUT_WRITER = new NonClosePrintWriter(System.out);
    private static final NonClosePrintWriter ERR_WRITER = new NonClosePrintWriter(System.err);
    public static final char EXTENSION_SEPARATOR = '.';
    private static final byte B_CR = 13;
    private static final byte B_LF = 10;
    private static final int BUFSIZE = 8192;

    private FileUtil() {
    }

    public static PrintWriter getPrintWriter(File file, String string) {
        return FileUtil.getPrintWriter(file, string, false);
    }

    public static PrintWriter getPrintWriter(File file, String string, boolean bl) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, bl), string)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = "\u6307\u5b9a\u3055\u308c\u305f\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" + HybsConst.CR + unsupportedEncodingException.getMessage() + HybsConst.CR + "File=[" + file + " , encode=[" + string + "]";
            throw new OgRuntimeException(string2, unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u30aa\u30fc\u30d7\u30f3\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsConst.CR + fileNotFoundException.getMessage() + HybsConst.CR + "File=[" + file + " , encode=[" + string + "]";
            throw new OgRuntimeException(string3, fileNotFoundException);
        }
        return printWriter;
    }

    public static PrintWriter getLogWriter(String string) {
        if (string == null) {
            throw new IllegalArgumentException("\u30d5\u30a1\u30a4\u30eb\u540d\u306b\u3001null \u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        PrintWriter printWriter = "System.out".equalsIgnoreCase(string) ? OUT_WRITER : ("System.err".equalsIgnoreCase(string) ? ERR_WRITER : FileUtil.getPrintWriter(new File(string), "UTF-8", true));
        return printWriter;
    }

    public static PrintWriter getPrintWriter(OutputStream outputStream, String string) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, string)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = "\u6307\u5b9a\u3055\u308c\u305f\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" + HybsConst.CR + unsupportedEncodingException.getMessage() + HybsConst.CR + "encode=[" + string + "]";
            throw new OgRuntimeException(string2, unsupportedEncodingException);
        }
        return printWriter;
    }

    public static PrintWriter getNonFlushPrintWriter(Writer writer) {
        return new NonFlushPrintWriter(writer);
    }

    public static BufferedReader getBufferedReader(File file, String string) {
        BufferedReader bufferedReader;
        try {
            if (file instanceof FileOperation) {
                FileOperation fileOperation = (FileOperation)file;
                bufferedReader = new BufferedReader(new InputStreamReader(fileOperation.read(), string));
            } else {
                bufferedReader = Files.newBufferedReader(file.toPath(), Charset.forName(string));
            }
        }
        catch (IOException iOException) {
            String string2 = "\u30d5\u30a1\u30a4\u30eb\u306e\u30aa\u30fc\u30d7\u30f3\u4e2d\u306b\u5165\u51fa\u529b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + iOException.getMessage() + HybsConst.CR + "File=[" + file + "] , encode=[" + string + "]";
            throw new OgRuntimeException(string2, iOException);
        }
        catch (RuntimeException runtimeException) {
            String string3 = "\u6307\u5b9a\u3055\u308c\u305f\u6587\u5b57\u30bb\u30c3\u30c8\u304c\u4e0d\u6b63\u304b\u3001\u73fe\u5728\u306eJava\u4eee\u60f3\u30de\u30b7\u30f3\u3067\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093\u3002" + HybsConst.CR + runtimeException.getMessage() + HybsConst.CR + "File=[" + file + "] , encode=[" + string + "]";
            throw new OgRuntimeException(string3, runtimeException);
        }
        return bufferedReader;
    }

    public static File checkFile(String string, String string2) {
        return FileUtil.checkFile(string, string2, 3);
    }

    public static File checkFile(String string, String string2, int n) {
        File file = null;
        for (int i = n; i > 0 && !(file = new File(string, string2)).exists(); --i) {
            if (i == 1) {
                return null;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("InterruptedException");
            }
            System.out.println();
            System.out.print("CHECK File Error! CNT=" + i);
            System.out.print(" File=" + file.getAbsolutePath());
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            String string3 = "\u30d5\u30a1\u30a4\u30eb\u306e\u6b63\u5f0f\u30d1\u30b9\u540d\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002[" + file.getAbsolutePath() + "]";
            throw new OgRuntimeException(string3, iOException);
        }
    }

    public static boolean copy(String string, String string2) {
        return FileUtil.copy(new File(string), new File(string2), false);
    }

    public static boolean copy(String string, String string2, boolean bl) {
        return FileUtil.copy(new File(string), new File(string2), bl);
    }

    public static boolean copy(File file, File file2) {
        return FileUtil.copy(file, file2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File file, File file2, boolean bl) {
        File file3;
        InputStream inputStream;
        FileChannel fileChannel;
        FileChannel fileChannel2;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        block12: {
            block11: {
                File file4;
                block10: {
                    fileInputStream = null;
                    fileOutputStream = null;
                    fileChannel2 = null;
                    fileChannel = null;
                    inputStream = null;
                    file3 = file2;
                    if (!file.isDirectory()) break block10;
                    boolean bl2 = FileUtil.copyDirectry(file, file2, bl);
                    Closer.ioClose(fileInputStream);
                    Closer.ioClose(fileOutputStream);
                    Closer.ioClose(fileChannel2);
                    Closer.ioClose(fileChannel);
                    Closer.ioClose(inputStream);
                    return bl2;
                }
                if (file2.isDirectory()) {
                    file3 = file2 instanceof FileOperation ? FileOperationFactory.resolveFile(file2, file2.getAbsolutePath(), file.getName()) : new File(file2, file.getName());
                }
                if ((file4 = file3.getParentFile()).exists() || file4.mkdirs()) break block11;
                System.err.println(file4 + " \u306e \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                boolean bl3 = false;
                Closer.ioClose(fileInputStream);
                Closer.ioClose(fileOutputStream);
                Closer.ioClose(fileChannel2);
                Closer.ioClose(fileChannel);
                Closer.ioClose(inputStream);
                return bl3;
            }
            try {
                if (file2 instanceof FileOperation) {
                    inputStream = file instanceof FileOperation ? ((FileOperation)file).read() : new FileInputStream(file);
                    ((FileOperation)file3).write(inputStream);
                    break block12;
                }
                if (file instanceof FileOperation) {
                    inputStream = ((FileOperation)file).read();
                    Files.copy(inputStream, file3.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    break block12;
                }
                fileInputStream = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(file3);
                fileChannel2 = fileInputStream.getChannel();
                fileChannel = fileOutputStream.getChannel();
                fileChannel2.transferTo(0L, fileChannel2.size(), fileChannel);
            }
            catch (IOException iOException) {
                boolean bl4;
                try {
                    String string = "\u30d0\u30a4\u30ca\u30ea\u30b3\u30d4\u30fc\u3067\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + "fromFile=[" + file + "]" + HybsConst.CR + "toFile  =[" + file2 + "]" + HybsConst.CR;
                    System.out.println(ThrowUtil.ogThrowMsg(string, iOException));
                    bl4 = false;
                }
                catch (Throwable throwable) {
                    Closer.ioClose(fileInputStream);
                    Closer.ioClose(fileOutputStream);
                    Closer.ioClose(fileChannel2);
                    Closer.ioClose(fileChannel);
                    Closer.ioClose(inputStream);
                    throw throwable;
                }
                Closer.ioClose(fileInputStream);
                Closer.ioClose(fileOutputStream);
                Closer.ioClose(fileChannel2);
                Closer.ioClose(fileChannel);
                Closer.ioClose(inputStream);
                return bl4;
            }
        }
        Closer.ioClose(fileInputStream);
        Closer.ioClose(fileOutputStream);
        Closer.ioClose(fileChannel2);
        Closer.ioClose(fileChannel);
        Closer.ioClose(inputStream);
        if (bl) {
            return file3.setLastModified(file.lastModified());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean changeCrLfcopy(File file, File file2) {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        File file3 = file2;
        try {
            int n;
            if (file2.isDirectory()) {
                file3 = new File(file2, file.getName());
            }
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
            byte[] byArray = new byte[8192];
            boolean bl = true;
            int n2 = 0;
            while ((n = bufferedInputStream.read(byArray, 0, 8192)) != -1) {
                int n3 = 0;
                if (bl && n >= 3 && byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
                    n3 = 3;
                } else if (n2 == 13 && byArray[0] == 10) {
                    n3 = 1;
                }
                bl = false;
                for (int i = n3; i < n; ++i) {
                    n2 = byArray[i];
                    if (n2 == 13 || n2 == 10) {
                        bufferedOutputStream.write(13);
                        bufferedOutputStream.write(10);
                        if (n2 != 13 || i + 1 >= n || byArray[i + 1] != 10) continue;
                        n2 = byArray[++i];
                        continue;
                    }
                    bufferedOutputStream.write(n2);
                }
            }
            if (n2 != 13 && n2 != 10) {
                bufferedOutputStream.write(13);
                bufferedOutputStream.write(10);
            }
        }
        catch (IOException iOException) {
            boolean bl;
            try {
                String string = "\u30d0\u30a4\u30ca\u30ea\u30b3\u30d4\u30fc(CrLf)\u3067\u3001\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + "fromFile=[" + file + "]" + HybsConst.CR + "toFile  =[" + file2 + "]" + HybsConst.CR;
                System.out.println(ThrowUtil.ogThrowMsg(string, iOException));
                bl = false;
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedInputStream);
                Closer.ioClose(bufferedOutputStream);
                throw throwable;
            }
            Closer.ioClose(bufferedInputStream);
            Closer.ioClose(bufferedOutputStream);
            return bl;
        }
        Closer.ioClose(bufferedInputStream);
        Closer.ioClose(bufferedOutputStream);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean copy(InputStream inputStream, File file) {
        boolean bl;
        FileOutputStream fileOutputStream;
        block5: {
            fileOutputStream = null;
            File file2 = file.getParentFile();
            if (file2.exists() || file2.mkdirs()) break block5;
            System.err.println(file2 + " \u306e \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            boolean bl2 = false;
            Closer.ioClose(inputStream);
            Closer.ioClose(fileOutputStream);
            return bl2;
        }
        try {
            fileOutputStream = new FileOutputStream(file, false);
            bl = FileUtil.copy(inputStream, fileOutputStream);
        }
        catch (IOException iOException) {
            try {
                String string = "\u5165\u529b\u30b9\u30c8\u30ea\u30fc\u30e0\u306e\u30b3\u30d4\u30fc\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + "toFile  =[" + file + "]" + HybsConst.CR;
                System.out.println(ThrowUtil.ogThrowMsg(string, iOException));
            }
            catch (Throwable throwable) {
                Closer.ioClose(inputStream);
                Closer.ioClose(fileOutputStream);
                throw throwable;
            }
            Closer.ioClose(inputStream);
            Closer.ioClose(fileOutputStream);
            return false;
        }
        Closer.ioClose(inputStream);
        Closer.ioClose(fileOutputStream);
        return bl;
    }

    public static boolean copy(InputStream inputStream, OutputStream outputStream) {
        if (inputStream == null) {
            System.out.println(ThrowUtil.ogThrowMsg("\u5165\u529b\u30b9\u30c8\u30ea\u30fc\u30e0\u304c \u4f5c\u6210\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return false;
        }
        if (outputStream == null) {
            System.out.println(ThrowUtil.ogThrowMsg("\u51fa\u529b\u30b9\u30c8\u30ea\u30fc\u30e0\u304c \u4f5c\u6210\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return false;
        }
        try {
            int n;
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            System.out.println(ThrowUtil.ogThrowMsg("\u30b9\u30c8\u30ea\u30fc\u30e0\u30c7\u30fc\u30bf\u306e\u5165\u51fa\u529b\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", iOException));
            return false;
        }
        return true;
    }

    public static boolean copyDirectry(String string, String string2) {
        return FileUtil.copyDirectry(new File(string), new File(string2), false);
    }

    public static boolean copyDirectry(File file, File file2) {
        return FileUtil.copyDirectry(file, file2, false);
    }

    public static boolean copyDirectry(File file, File file2, boolean bl) {
        if (!file.exists() || !file.isDirectory()) {
            System.err.println(file + " \u304c \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306a\u3044\u304b\u3001\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            return false;
        }
        if (!file2.exists() && !file2.mkdirs()) {
            System.err.println(file2 + " \u306e \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return false;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            System.err.println(file + " \u306f\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u305b\u3093\u3002");
            return false;
        }
        boolean bl2 = true;
        for (int i = 0; fileArray.length > i; ++i) {
            bl2 = fileArray[i].isDirectory() ? FileUtil.copyDirectry(fileArray[i], new File(file2, fileArray[i].getName()), bl) : FileUtil.copy(fileArray[i], new File(file2, fileArray[i].getName()), bl);
            if (bl2) continue;
            return false;
        }
        return true;
    }

    public static boolean deleteFiles(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray == null) {
                    System.err.println(file + " \u306f\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u305b\u3093\u3002");
                    return false;
                }
                for (int i = 0; i < fileArray.length; ++i) {
                    FileUtil.deleteFiles(fileArray[i]);
                }
            }
            if (!file.delete()) {
                return false;
            }
        }
        return true;
    }

    public static void getFileList(File file, boolean bl, List<String> list) {
        FileUtil.getFileList(file, null, bl, list, true);
    }

    public static void getFileList(File file, boolean bl, List<String> list, boolean bl2) {
        FileUtil.getFileList(file, null, bl, list, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void getFileList(File file, FileFilter fileFilter, boolean bl, List<String> list, boolean bl2) {
        File[] fileArray;
        if (list == null) {
            return;
        }
        if (file.isFile()) {
            if (!bl2 && !file.renameTo(file)) return;
            list.add(file.getAbsolutePath());
        } else if (file.isDirectory() && (fileArray = file.listFiles(fileFilter)) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                FileUtil.getFileList(fileArray[i], bl, list, bl2);
            }
        }
        if (!bl) return;
        Collections.sort(list);
    }

    public static File renameTo(File file, File file2, String string) {
        Object object;
        if (file == null || file2 == null) {
            String string2 = "\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u304c null \u3067\u3059\u3002from=[" + file + "] , to=[" + file2 + "]";
            throw new OgRuntimeException(string2);
        }
        File file3 = file2.getParentFile();
        if (!file3.exists() && !file3.mkdirs()) {
            String string3 = "to\u30d5\u30a1\u30a4\u30eb\u306e\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002from=[" + file + "] , to=[" + file2 + "]";
            throw new OgRuntimeException(string3);
        }
        File file4 = file2;
        if (file2.exists()) {
            object = new FileInfo(file2);
            if ("true".equalsIgnoreCase(string)) {
                FileOperation fileOperation = FileOperationFactory.resolveFile(file2, file3.getPath(), "_backup");
                if (!fileOperation.exists() && !fileOperation.mkdirs()) {
                    String string4 = "\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u51e6\u7406\u3067backup\u30d5\u30a9\u30eb\u30c0\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + fileOperation + "]";
                    throw new OgRuntimeException(string4);
                }
                String string5 = file2.getName();
                FileOperation fileOperation2 = FileOperationFactory.resolveFile(file2, file3.getPath(), string5);
                String string6 = ((FileInfo)object).NAME + "_" + System.currentTimeMillis() + "." + ((FileInfo)object).SUFIX;
                FileOperation fileOperation3 = FileOperationFactory.resolveFile(fileOperation, fileOperation.getParent(), string6);
                if (!fileOperation2.renameTo(fileOperation3)) {
                    String string7 = "\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u51e6\u7406\u3067\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u30d5\u30a1\u30a4\u30eb\u3092\u30ea\u30cd\u30fc\u30e0\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsConst.CR + "  [" + file2 + "] \u21d2 [" + fileOperation3 + "]";
                    throw new OgRuntimeException(string7);
                }
            } else if ("rename".equalsIgnoreCase(string)) {
                for (int i = 1000; i < 2000; ++i) {
                    String string8 = String.valueOf(i).substring(1);
                    FileOperation fileOperation = FileOperationFactory.resolveFile(file2, ((FileInfo)object).DIR, ((FileInfo)object).NAME + "_" + string8 + "." + ((FileInfo)object).SUFIX);
                    if (fileOperation.exists()) continue;
                    file4 = fileOperation;
                    break;
                }
            } else if (!file2.delete()) {
                String string9 = "\u65e2\u5b58\u306e\u30d5\u30a1\u30a4\u30eb[" + file2 + "]\u304c\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
                throw new OgRuntimeException(string9);
            }
        }
        if (!file.renameTo(file4)) {
            object = "\u6240\u5b9a\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u30ea\u30cd\u30fc\u30e0\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsConst.CR + "  [" + file + "] \u21d2 [" + file4 + "]";
            throw new OgRuntimeException((String)object);
        }
        return file4;
    }

    public static String getValue(String string, String string2) {
        if (string == null) {
            throw new OgRuntimeException("\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        String string3 = string2 == null ? "UTF-8" : string2;
        try {
            return new String(Files.readAllBytes(new File(string).toPath()), string3);
        }
        catch (IOException iOException) {
            String string4 = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u30aa\u30fc\u30d7\u30f3\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + string + "]";
            throw new OgRuntimeException(string4, iOException);
        }
    }

    public static List<String> getLineList(String string, String string2) {
        try {
            String string3 = string2 == null ? "UTF-8" : string2;
            return Files.readAllLines(new File(string).toPath(), Charset.forName(string3));
        }
        catch (IOException iOException) {
            String string4 = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u30aa\u30fc\u30d7\u30f3\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + string + "]";
            throw new OgRuntimeException(string4, iOException);
        }
    }

    public static long length(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            long l = 0L;
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    l += FileUtil.length(file2);
                }
            }
            return l;
        }
        return file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File file2, String string, String string2) {
        Object object;
        BufferedReader bufferedReader = FileUtil.getBufferedReader(file, string);
        PrintWriter printWriter = FileUtil.getPrintWriter(file2, string2);
        try {
            while ((object = bufferedReader.readLine()) != null) {
                printWriter.println((String)object);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            Closer.ioClose(bufferedReader);
            Closer.ioClose(printWriter);
        }
        if (!file2.setLastModified(file.lastModified())) {
            object = "FileUtil.copy \u306b\u304a\u3044\u3066\u3001\u30bf\u30a4\u30e0\u30b9\u30bf\u30f3\u30d7\u306e\u66f4\u65b0\u304c\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsConst.CR + " file2= [" + file2 + "]" + HybsConst.CR;
            System.err.println((String)object);
        }
    }

    public static void main(String[] stringArray) throws Throwable {
        if (stringArray.length != 2 && stringArray.length != 4) {
            LogWriter.log("Usage: java org.opengion.fukurou.util.FileUtil <file1> <file2> [<encode1> <encode2>]");
            return;
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        if (stringArray.length < 3) {
            if (file.isDirectory()) {
                FileUtil.copyDirectry(file, file2, true);
            } else {
                File file3 = new File(stringArray[1] + "_backup");
                FileUtil.copy(file2, file3);
                FileUtil.copy(file, file2, true);
            }
        } else {
            String string = stringArray[2];
            String string2 = stringArray[3];
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    for (File file4 : fileArray) {
                        FileUtil.copy(file4, new File(file2, file4.getName()), string, string2);
                    }
                }
            } else {
                FileUtil.copy(file, file2, string, string2);
            }
        }
    }

    private static final class NonClosePrintWriter
    extends PrintWriter {
        public NonClosePrintWriter(OutputStream outputStream) {
            super(outputStream);
        }

        @Override
        public void close() {
        }
    }

    private static final class NonFlushPrintWriter
    extends PrintWriter {
        public NonFlushPrintWriter(Writer writer) {
            super(writer);
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }
    }
}

