<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:equals val1="{@command}" val2="RENEW" >
  <og:text>
	<table border="2" frame="box" rules="all" style="white-space: normal" >
	  <tr><th>ｷｰ</th><th>値</th></tr>
	  <tr><td>CLM</td><td>{@CLM}</td></tr>
	  <tr><td>VAL</td><td>{@VAL}</td></tr>
	  <tr><td>IDX</td><td>{@IDX}</td></tr>
	  <tr><td>SEL</td><td>{@SEL}</td></tr>
	  <tr><td>JOB</td><td>{@JOB}</td></tr>
	</table>
  </og:text>
</og:equals>

<!-- ﾁｬｰﾄ情報の取得 -->
<og:query>
	SELECT	 ENAME as LABELS
			,SAL   as VAL1
			,COMM  as VAL2
			,JOB
	FROM BONUS
	order by 1
</og:query>

<og:value command="SET" key="JSONDATA">
{"command":"RENEW","CLM":"$LBL","VAL":"$VAL","IDX":"$IDX","SEL":"$SEL","debug":"{@debug}"}
</og:value>

<!--
	jsChartのchartTypeに「bar」,
	jsChartDataのoptOptionsに「type:'line'」を設定して下さい。
-->

<og:jsChart
	chartType		= "bar"
	height			= "{@height}"
	width			= "{@width}"
	minLabelWidth	= "{@minLabelWidth}"
	labelColumn		= "LABELS"
	plugins			= "chartLabelPlugin"
	onClick			= "chartLink( event, obj, null,'result_sample3.jsp', {@JSONDATA}, 'JOB', JOB );"
	varColumns		= "JOB"
	debug			= "{@debug}"
>
	<og:jsChartData
		chartColumn		= "VAL1"
		label			= "給料"
		type			= "line"
		borderColor		= "green"
		max				= "{@max}"
		min				= "{@min}"
	/>
	<og:jsChartData
		chartColumn		= "VAL2"
		label			= "裁量手当"
		type			= "bar"
		borderColor		= "blue"
	/>
</og:jsChart>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
