<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- ﾁｬｰﾄ情報の取得 -->
<og:query command="NEW">
	SELECT ENAME LABELS
		,SAL VAL1
		,COMM VAL2
		,CASE ENAME
			WHEN 'ALLEN'  THEN 'gray'
			WHEN 'BLAKE'  THEN 'silver'
			WHEN 'CLARK'  THEN 'blue'
			WHEN 'FORD'   THEN 'navy'
			WHEN 'JAMES'  THEN 'teal'
			WHEN 'JONES'  THEN 'green'
			WHEN 'KING'   THEN 'lime'
			WHEN 'MARTIN' THEN 'aqua'
			WHEN 'MILLER' THEN 'yellow'
			WHEN 'SMITH'  THEN 'red'
			WHEN 'TURNER' THEN 'fuchsia'
			WHEN 'WARD'   THEN 'olive'
			ELSE 'BLACK'
		END as COLOR
	FROM BONUS
	order by 1
</og:query>


<!--
	一番ｼﾝﾌﾟﾙな形式
	<og:jsChart
		chartType	= "{@chartType}"
		labelColumn	= "LABELS"
		debug		= "{@debug}"
	>
		<og:jsChartData
			chartColumn	= "VAL1"
		/>
	</og:jsChart>
-->

<og:jsChart
	chartType		= "bar"
	height			= "{@height}"
	width			= "{@width}"
	minLabelWidth	= "{@minLabelWidth}"
	labelColumn		= "LABELS"
	title			= "{@chartTitle}"
	xscaleCallback	= "function(val, index){return this.getLabelForValue(val) + ' さん';}"
	varColumns		= "COLOR"
	debug			= "{@debug}"
>
	<og:jsChartData
		chartColumn		= "VAL1"
		label			= "給料"
		scaleCallback	= "function(val, index){return val.toLocaleString() + '円';}"
		tension			= "0.4"
		backgroundColor	= "$COLOR"
		stepSize		= "100"
		optTicks		= "autoSkip:false"
	/>
</og:jsChart>

<og:view useScrollBar="false" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
