<?xml version="1.0" encoding="UTF-8" ?>
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:value key="SQL" xssCheck="false">{@SQL_TEXT}</og:value>

<!-- TABLE名 一覧 -->
<og:equals val1="{@TBL_NM}" val2="1" >
	<!-- PostgreSQL 版 -->
	<og:equals val1="{@DBF.NAME @DBID}" val2="POSTGRES">
		<og:value key="SQL" >
			select A.TABLE_NAME	 , A.TABLE_NAME AS NAME_JA,
					B.reltuples AS JKENSU
			from information_schema.tables A
					left outer join pg_class B
					on  A.TABLE_NAME = B.RELNAME
			where A.TABLE_SCHEMA = 'public'
			<og:where startKey="and">
				<og:and value = "A.TABLE_NAME like '{@TABLE}'" />
			</og:where>
			order by A.TABLE_NAME
		</og:value>
	</og:equals>

	<!-- ORACLE 版 -->
	<og:equals val1="{@DBF.NAME @DBID}" val2="ORACLE">
		<og:value key="SQL" >
			select A.OWNER,A.TABLE_NAME,COALESCE(B.COMMENTS,A.TABLE_NAME) AS NAME_JA,
					COALESCE(A.NUM_ROWS,0) AS JKENSU
			from DBA_TABLES A left outer join DBA_TAB_COMMENTS B
					on  A.TABLE_NAME = B.TABLE_NAME
					and A.OWNER      = B.OWNER
			<og:where>
				<og:and value = "A.TABLE_NAME like '{@TABLE}'"	/>
				<og:and value = "INSTR(A.TABLE_NAME,'$') < 1"	/>
				<og:and value = "A.OWNER	= '{@OWNER}'"		/>
			</og:where>
			order by A.OWNER,A.TABLE_NAME
		</og:value>

		<og:viewLink command="{@command}">
			<og:link column="TABLE_NAME" href="viewObject.jsp" target="SUB_WIND"
				keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OWNER],TABLE,[TABLE_NAME],{@DBID}" />
		</og:viewLink>
	</og:equals>

	<!-- FIREBIRD 版 -->
	<og:equals val1="{@DBF.NAME @DBID}" val2="FIREBIRD">
		<og:value key="SQL" >
			select trim(RDB$RELATION_NAME) AS TABLE_NAME,trim(RDB$RELATION_NAME) AS NAME_JA,
					0 AS JKENSU
			from RDB$RELATIONS
			where RDB$SYSTEM_FLAG   = 0
			and   RDB$RELATION_TYPE = 0
			<og:where startKey="and">
				<og:and value = "RDB$RELATION_NAME like '{@TABLE}'" />
			</og:where>
			order by 1
		</og:value>
	</og:equals>

	<!-- MySQL 版 -->
	<og:equals val1="{@DBF.NAME @DBID}" val2="MYSQL">
		<og:value key="SQL" >
			select TABLE_NAME,
					case when length(TABLE_COMMENT) = 0 then TABLE_NAME
						 else TABLE_COMMENT end AS NAME_JA,
					TABLE_ROWS AS JKENSU
			from information_schema.tables
			where table_schema=database()
			and   TABLE_TYPE = 'BASE TABLE'
			<og:where startKey="and">
				<og:and value = "TABLE_NAME like '{@TABLE}'" />
			</og:where>
			order by TABLE_NAME
		</og:value>
	</og:equals>

	<!-- DERBY 版 -->
	<og:equals val1="{@DBF.NAME @DBID}" val2="DERBY">
		<og:value key="SQL" >
			select B.SCHEMANAME as OWNER ,A.TABLENAME , A.TABLENAME AS NAME_JA
			from SYS.SYSTABLES A left outer join SYS.SYSSCHEMAS B
				on A.SCHEMAID = B.SCHEMAID
			where A.TABLETYPE  = 'T'
			<og:where startKey="and">
				<og:and value = "A.TABLENAME  like '{@TABLE}'" />
				<og:and value = "B.SCHEMANAME =    '{@OWNER}'" />
			</og:where>
			order by B.SCHEMANAME,A.TABLENAME
		</og:value>
	</og:equals>
</og:equals>

<!-- TABLE-COLUMN名 or COLUMN名 一覧 -->
<og:equals val1="{@TBL_NM}" val2="1" notEquals="true">
  <og:equals val1="{@TABLE}{@CLM}" val2="{@TABLE}{@CLM}" >
	<!-- PostgreSQL 版 -->
	<og:equals val1="{@DBF.NAME @DBID}" val2="POSTGRES">
		<og:value key="SQL" >
			select A.TABLE_SCHEMA as OWNER,A.TABLE_NAME,A.ORDINAL_POSITION AS SEQNO,
					A.COLUMN_NAME,
					A.COLUMN_NAME AS DBLABEL,
					A.DATA_TYPE ,
					( CASE	WHEN A.DATA_TYPE = 'integer' or A.DATA_TYPE = 'bigint'
								THEN to_char(A.NUMERIC_PRECISION)
							WHEN A.DATA_TYPE = 'numeric'
								THEN to_char(A.NUMERIC_PRECISION_RADIX)
							WHEN A.DATA_TYPE = 'character varying' or A.DATA_TYPE = 'text'
								THEN to_char(A.CHARACTER_OCTET_LENGTH)
						END ) AS USE_LENGTH ,
				    (CASE A.IS_NULLABLE WHEN 'NO' THEN 'NN' ELSE '' END) AS NN,
					A.COLUMN_DEFAULT as DATA_DEFAULT
			from information_schema.columns A
			where A.TABLE_SCHEMA = 'public'
			<og:where startKey="and">
				<og:and value="A.TABLE_NAME  like '{@TABLE}'"	/>
				<og:and value="A.COLUMN_NAME like '{@CLM}'"		/>
			</og:where>
			order by A.TABLE_NAME,A.ORDINAL_POSITION
		</og:value>
	</og:equals>

	<!-- ORACLE 版 -->
	<og:equals val1="{@DBF.NAME @DBID}" val2="ORACLE">
		<og:value key="SQL" >
			select A.OWNER,A.TABLE_NAME,A.COLUMN_ID AS SEQNO,
					A.COLUMN_NAME,
					B.COMMENTS AS DBLABEL,
					A.DATA_TYPE,
			--	    (CASE WHEN A.DATA_PRECISION IS NULL THEN A.DATA_LENGTH ELSE (A.DATA_PRECISION+0.1*A.DATA_SCALE) END) AS DATA_LENGTH,
					( CASE	WHEN A.DATA_TYPE = 'BLOB' or A.DATA_TYPE = 'CLOB'
								THEN NULL
							WHEN A.DATA_TYPE = 'NUMBER' AND A.DATA_PRECISION IS NULL
								THEN NULL
							WHEN A.DATA_TYPE = 'VARCHAR2'
								THEN to_char(A.DATA_LENGTH)
							WHEN A.DATA_PRECISION IS NULL
								THEN to_char(A.DATA_LENGTH)
								ELSE (	CASE WHEN A.DATA_SCALE = 0 or A.DATA_SCALE is null
											THEN to_char(A.DATA_PRECISION)
											ELSE A.DATA_PRECISION || ',' || A.DATA_SCALE
									  	END )
							 END ) AS USE_LENGTH ,
				    (CASE A.NULLABLE WHEN 'N' THEN 'NN' ELSE '' END) AS NN,DATA_DEFAULT
			from DBA_TAB_COLS A left outer join DBA_COL_COMMENTS B
					on  A.OWNER       = B.OWNER
					and A.TABLE_NAME  = B.TABLE_NAME
					and A.COLUMN_NAME = B.COLUMN_NAME
			<og:where>
				<og:and value="A.OWNER		=	 '{@OWNER}'"	/>
				<og:and value="A.TABLE_NAME  like '{@TABLE}'"		/>
				<og:and value="A.COLUMN_NAME like '{@CLM}'"		/>
				<og:and value="INSTR(A.TABLE_NAME,'$') < 1"		/>
				<og:and value="A.HIDDEN_COLUMN	= 'NO'"			/>
			</og:where>
			order by A.OWNER,A.TABLE_NAME,SEQNO
		</og:value>
	</og:equals>

	<!-- FIREBIRD 版 -->
	<og:equals val1="{@DBF.NAME @DBID}" val2="FIREBIRD">
		<og:value key="SQL" >
			select
				trim(r.RDB$RELATION_NAME)	AS TABLE_NAME,
				r.RDB$FIELD_POSITION		AS SEQNO,
				trim(r.RDB$FIELD_NAME)		AS COLUMN_NAME,
				''							AS DBLABEL,
				CASE f.RDB$FIELD_TYPE
					WHEN   7 THEN
						CASE f.RDB$FIELD_SUB_TYPE
							WHEN 1 THEN 'NUMERIC'
							WHEN 2 THEN 'DECIMAL'
							ELSE        'SMALLINT'
						END
					WHEN   8 THEN
						CASE f.RDB$FIELD_SUB_TYPE
							WHEN 1 THEN 'NUMERIC'
							WHEN 2 THEN 'DECIMAL'
							ELSE        'INTEGER'
						END
					WHEN  16 THEN
						CASE f.RDB$FIELD_SUB_TYPE
							WHEN 1 THEN 'NUMERIC'
							WHEN 2 THEN 'DECIMAL'
							ELSE        'INT64'
						END
					WHEN   9 THEN 'QUAD'
					WHEN  10 THEN 'FLOAT'
					WHEN  11 THEN 'D_FLOAT'
					WHEN  12 THEN 'DATE'
					WHEN  13 THEN 'TIME'
					WHEN  14 THEN 'CHAR'
					WHEN  27 THEN 'DOUBLE'
					WHEN  35 THEN 'TIMESTAMP'
					WHEN  37 THEN 'VARCHAR'
					WHEN  40 THEN 'CSTRING'
					WHEN 261 THEN 'BLOB'
					ELSE 'UNKNOWN'
					END AS DATA_TYPE ,
		--		f.RDB$FIELD_LENGTH			AS DATA_LENGTH ,
				f.RDB$CHARACTER_LENGTH 		AS DATA_LENGTH ,
				( CASE WHEN r.RDB$NULL_FLAG = '1' THEN 'NN' ELSE '' END ) AS NN,
				replace(upper(r.RDB$DEFAULT_SOURCE),'DEFAULT ','') AS DATA_DEFAULT
			from RDB$RELATION_FIELDS r LEFT JOIN RDB$FIELDS f
			ON r.RDB$FIELD_SOURCE = f.RDB$FIELD_NAME
			where r.RDB$SYSTEM_FLAG = 0
			<og:where startKey="and">
				<og:and value = "r.RDB$RELATION_NAME like '{@TABLE}'"	/>
				<og:and value = "r.RDB$FIELD_NAME    like '{@CLM}'"	/>
			</og:where>
			order by r.RDB$RELATION_NAME,r.RDB$FIELD_POSITION
		</og:value>
	</og:equals>

	<!-- MySQL 版 -->
	<og:equals val1="{@DBF.NAME @DBID}" val2="MYSQL">
		<og:value key="SQL" >
			select TABLE_NAME,ORDINAL_POSITION AS SEQNO,COLUMN_NAME,
					case when length(COLUMN_COMMENT) = 0 then COLUMN_NAME
						 else COLUMN_COMMENT end AS DBLABEL,
					DATA_TYPE,
					CONVERT( CASE	WHEN CHARACTER_OCTET_LENGTH is not null
								THEN CHARACTER_OCTET_LENGTH
							WHEN NUMERIC_SCALE = 0 or NUMERIC_SCALE is null
								THEN NUMERIC_PRECISION
							WHEN NUMERIC_SCALE > 0
								THEN NUMERIC_PRECISION || ',' || NUMERIC_SCALE
							ELSE
								NUMERIC_PRECISION
						END USING utf8 ) AS DATA_LENGTH ,
					(CASE IS_NULLABLE WHEN 'NO' THEN 'NN' ELSE '' END) AS NN,
					COLUMN_DEFAULT AS DATA_DEFAULT
			from INFORMATION_SCHEMA.COLUMNS
			where table_schema=database()
			<og:where startKey="and">
				<og:and value = "TABLE_NAME  like '{@TABLE}'" />
				<og:and value = "COLUMN_NAME like '{@CLM}'" />
			</og:where>
			order by TABLE_NAME,ORDINAL_POSITION
		</og:value>
	</og:equals>

	<!-- DERBY 版 -->
	<og:equals val1="{@DBF.NAME @DBID}" val2="DERBY">
		<og:value key="SQL" >
			select C.SCHEMANAME as OWNER ,B.TABLENAME , A.COLUMNNAME ,
					A.COLUMNNAME AS NAME_JA,A.COLUMNDATATYPE,
					A.COLUMNDEFAULT AS DATA_DEFAULT
			from SYS.SYSCOLUMNS A left outer join SYS.SYSTABLES B
				on A.REFERENCEID = B.TABLEID
				left outer join SYS.SYSSCHEMAS C
					on B.SCHEMAID = C.SCHEMAID
			<og:where>
				<og:and value = "B.TABLENAME   like '{@TABLE}'" />
				<og:and value = "A.COLUMNNAME  like '{@CLM}'"  />
				<og:and value = "C.SCHEMANAME  =    '{@OWNER}'" />
			</og:where>
			order by C.SCHEMANAME,B.TABLENAME,A.COLUMNNUMBER
		</og:value>
	</og:equals>
  </og:equals>
</og:equals>

<!-- INDEX-COLUMN名 一覧 -->
<og:equals val1="{@INDEX}" val2="{@INDEX}" >
	<!-- PostgreSQL 版 -->
	<og:equals val1="{@DBF.NAME @DBID}" val2="POSTGRES">
		<og:value key="SQL" >
			select A.TABLE_SCHEMA as INDEX_OWNER,A.TABLE_NAME,
					A.CONSTRAINT_NAME as INDEX_NAME,
					strpos(B.INDEXDEF,A.COLUMN_NAME) AS SEQNO,
					A.COLUMN_NAME,
					'' AS DBLABEL, '' AS DESCEND , B.INDEXDEF
			from information_schema.constraint_column_usage A left outer join pg_indexes B
					on  A.TABLE_SCHEMA    = B.SCHEMANAME
					and A.TABLE_NAME      = B.TABLENAME
					and A.CONSTRAINT_NAME = B.INDEXNAME
			where A.TABLE_SCHEMA = 'public'
			<og:where startKey="and">
				<og:and value="A.TABLE_NAME		 like '{@TABLE}'"	/>
				<og:and value="A.CONSTRAINT_NAME like '{@INDEX}'"	/>
				<og:and value="A.COLUMN_NAME	 like '{@CLM}'"		/>
			</og:where>
			order by A.TABLE_NAME,A.CONSTRAINT_NAME,strpos(B.INDEXDEF,A.COLUMN_NAME)
		</og:value>
	</og:equals>

	<!-- ORACLE 版 -->
	<og:equals val1="{@DBF.NAME @DBID}" val2="ORACLE">
		<og:value key="SQL" >
			select A.INDEX_OWNER,A.TABLE_NAME,A.INDEX_NAME,A.COLUMN_POSITION AS SEQNO,
					A.COLUMN_NAME,
					B.COMMENTS AS DBLABEL, A.DESCEND
			from DBA_IND_COLUMNS A left outer join DBA_COL_COMMENTS B
					on  A.INDEX_OWNER = B.OWNER
					and A.TABLE_NAME  = B.TABLE_NAME
					and A.COLUMN_NAME = B.COLUMN_NAME
			<og:where>
				<og:and value="A.INDEX_OWNER	=   '{@OWNER}'"		/>
				<og:and value="A.TABLE_NAME  like '{@TABLE}'"		/>
				<og:and value="A.INDEX_NAME  like '{@INDEX}'"		/>
				<og:and value="A.COLUMN_NAME like '{@CLM}'"		/>
				<og:and value="INSTR(A.TABLE_NAME,'$') < 1"		/>
			</og:where>
			order by A.INDEX_OWNER,A.TABLE_NAME,A.INDEX_NAME,SEQNO
		</og:value>
	</og:equals>

	<!-- FIREBIRD 版 -->
	<og:equals val1="{@DBF.NAME @DBID}" val2="FIREBIRD">
		<og:value key="SQL" >
			select  trim(a.RDB$RELATION_NAME)	AS TABLE_NAME,
					trim(a.RDB$INDEX_NAME)		AS INDEX_NAME,
					b.RDB$FIELD_POSITION+1		AS SEQNO,
					trim(b.RDB$FIELD_NAME)		AS COLUMN_NAME,
					trim(b.RDB$FIELD_NAME)		AS DBLABEL,
					trim(a.RDB$DESCRIPTION)		AS DESCEND
			from RDB$INDICES a inner join RDB$INDEX_SEGMENTS b
			on   a.RDB$INDEX_NAME = b.RDB$INDEX_NAME
			where a.RDB$SYSTEM_FLAG = 0
			<og:where startKey="and">
				<og:and value = "a.RDB$RELATION_NAME like '{@TABLE}'"	/>
				<og:and value = "a.RDB$INDEX_NAME    like '{@INDEX}'"	/>
				<og:and value = "b.RDB$FIELD_NAME    like '{@CLM}'"	/>
			</og:where>
			order by a.RDB$RELATION_NAME,a.RDB$INDEX_NAME,b.RDB$FIELD_POSITION
		</og:value>
	</og:equals>

	<!-- MySQL 版 -->
	<og:equals val1="{@DBF.NAME @DBID}" val2="MYSQL">
		<og:value key="SQL" >
			select	A.TABLE_NAME,
					A.INDEX_NAME,
					A.SEQ_IN_INDEX				AS SEQNO,
					A.COLUMN_NAME,
					A.COLUMN_NAME				AS DBLABEL,
					''							AS DESCEND
			from  information_schema.statistics A left outer join information_schema.table_constraints B
					on  A.table_schema = B.constraint_schema
					and A.TABLE_NAME   = B.TABLE_NAME
					and A.INDEX_NAME   = B.CONSTRAINT_NAME
			where A.table_schema=database()
			<og:where startKey="and">
				<og:and value = "TABLE_NAME  like '{@TABLE}'"  />
				<og:and value = "INDEX_NAME  like '{@INDEX}'"  />
				<og:and value = "COLUMN_NAME like '{@CLM}'"  />
			</og:where>
			order by A.TABLE_NAME,A.INDEX_NAME,A.SEQ_IN_INDEX
		</og:value>
	</og:equals>
</og:equals>

<!-- FIREBIRD 版 はOBJECT_TYPEのみ対応 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="FIREBIRD">
	<og:equals val1="{@OBJECT_TYPE}" val2="{@OBJECT_TYPE}" >
		<og:value key="SQL" >
			<og:equals val1="|TABLE|VIEW|" val2="|{@OBJECT_TYPE}|" contains="true">
				SELECT	case when RDB$RELATION_TYPE = 0 then 'TABLE'
							when RDB$RELATION_TYPE = 1 then 'VIEW'
							else 'UNNONE' end		AS OBJECT_TYPE ,
						trim(RDB$RELATION_NAME)		AS OBJECT_NAME ,
						trim(RDB$RELATION_NAME)		AS OBJ_NAME ,
						trim(RDB$VIEW_SOURCE)	AS BIKO
				from RDB$RELATIONS
				where RDB$SYSTEM_FLAG = 0
				and (  RDB$RELATION_TYPE = 0 and '{@OBJECT_TYPE}'='TABLE'
					or RDB$RELATION_TYPE = 1 and '{@OBJECT_TYPE}'='VIEW' )
				<og:where startKey="and">
					<og:and value="RDB$RELATION_NAME like '{@OBJECT_NAME}'" />
				</og:where>
				union
				select	'INDEX'					AS OBJECT_TYPE,
						trim(RDB$INDEX_NAME)	AS OBJECT_NAME,
						trim(RDB$RELATION_NAME)	AS OBJ_NAME,
						trim(RDB$UNIQUE_FLAG)	AS BIKO
				from RDB$INDICES
				where RDB$SYSTEM_FLAG = 0
				and   '{@OBJECT_TYPE}'='INDEX'
				<og:where startKey="and">
					<og:and value = "RDB$INDEX_NAME like '{@OBJECT_NAME}'"	/>
				</og:where>
				union
				select	'SEQUENCE'					AS OBJECT_TYPE,
						trim(RDB$GENERATOR_NAME)	AS OBJECT_NAME,
						trim(RDB$GENERATOR_NAME)	AS OBJ_NAME,
						trim(RDB$GENERATOR_ID)		AS BIKO
				from RDB$GENERATORS
				where RDB$SYSTEM_FLAG = 0
				and   '{@OBJECT_TYPE}'='SEQUENCE'
				<og:where startKey="and">
					<og:and value = "RDB$GENERATOR_NAME like '{@OBJECT_NAME}'"	/>
				</og:where>
				union
				select	'TRIGGER'					AS OBJECT_TYPE,
						trim(RDB$TRIGGER_NAME)		AS OBJECT_NAME,
						trim(RDB$RELATION_NAME)		AS OBJ_NAME ,
						trim(RDB$TRIGGER_SOURCE)	AS BIKO
				from RDB$TRIGGERS
				where RDB$SYSTEM_FLAG = 0
				and   '{@OBJECT_TYPE}'='TRIGGER'
				<og:where startKey="and">
					<og:and value = "RDB$TRIGGER_NAME like '{@OBJECT_NAME}'"	/>
				</og:where>
				order by 2,1
			</og:equals>
		</og:value>
	</og:equals>
</og:equals>

<!-- POSTGRES 版 はOBJECT_TYPEのみ対応 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="POSTGRES">
	<og:equals val1="{@OBJECT_TYPE}" val2="{@OBJECT_TYPE}" >
		<og:value key="SQL" >
			SELECT case when c.relkind='r' then 'TABLE'
						when c.relkind='v' then 'VIEW'
						when c.relkind='S' then 'SEQUENCE'
						when c.relkind='i' then 'INDEX'
						else 'UNNONE' end	AS OBJECT_TYPE ,
					c.relname				AS OBJECT_NAME ,
					c.relname				AS OBJ_NAME ,
			FROM pg_class c JOIN pg_namespace n ON c.relnamespace = n.oid
			WHERE n.nspname = 'public'
			and   c.relkind IN ('r', 'v', 'S', 'i')
			<og:where startKey="and">
				<og:and value="c.relname like '{@OBJECT_NAME}'"	/>
				<og:and value="c.relkind='r'"	caseKey="{@OBJECT_TYPE}" caseVal="TABLE"	/>
				<og:and value="c.relkind='v'"	caseKey="{@OBJECT_TYPE}" caseVal="VIEW"		/>
				<og:and value="c.relkind='S'"	caseKey="{@OBJECT_TYPE}" caseVal="SEQUENCE"	/>
				<og:and value="c.relkind='i'"	caseKey="{@OBJECT_TYPE}" caseVal="INDEX"	/>
			</og:where>
			<og:equals val1="{@OBJECT_TYPE}" val2="TRIGGER" >
				union
				select 'TRIGGER'			AS OBJECT_TYPE ,
						trigger_name		AS OBJECT_NAME ,
						event_object_table	AS NAME_JA
				from information_schema.triggers
				<og:where>
					<og:and value="tgname like '{@OBJECT_NAME}'"	/>
				</og:where>
			</og:equals>
			order by 1
		</og:value>
	</og:equals>
</og:equals>

<!-- DERBY 版 はOBJECT_TYPEのみ対応 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="DERBY">
	<og:equals val1="{@OBJECT_TYPE}" val2="{@OBJECT_TYPE}" >
		<og:value key="SQL" >
			SELECT CASE WHEN TABLETYPE='T' THEN 'TABLE'
						WHEN TABLETYPE='V' THEN 'VIEW'
						ELSE 'UNNONE' END	AS OBJECT_TYPE ,
					TABLENAME	AS OBJECT_NAME ,
					TABLENAME	AS OBJ_NAME ,
					''			AS BIKO
			from	SYS.SYSTABLES
			where	(  '{@OBJECT_TYPE}' = 'TABLE' and TABLETYPE = 'T'
					or '{@OBJECT_TYPE}' = 'VIEW'  and TABLETYPE = 'V' )
			<og:where startKey="and">
				<og:and value = "TABLENAME like '{@OBJECT_NAME}'" />
			</og:where>
			union
			select	'INDEX'			AS OBJECT_TYPE ,
					CONSTRAINTNAME	AS OBJECT_NAME ,
					CONSTRAINTNAME	AS OBJ_NAME ,
					''				AS BIKO
			from	SYS.SYSCONSTRAINTS
			where	( '{@OBJECT_TYPE}' = 'INDEX' and TYPE = 'U' )
			<og:where startKey="and">
				<og:and value = "CONSTRAINTNAME like '{@OBJECT_NAME}'" />
			</og:where>
			union
			select	'TRIGGER'			AS OBJECT_TYPE ,
					TRIGGERNAME			AS OBJECT_NAME ,
					TRIGGERNAME			AS OBJ_NAME ,
					TRIGGERDEFINITION	AS BIKO
			from	SYS.SYSTRIGGERS
			where	( '{@OBJECT_TYPE}' = 'TRIGGER' )
			<og:where startKey="and">
				<og:and value = "TRIGGERNAME like '{@OBJECT_NAME}'" />
			</og:where>
			union
			select	'SEQUENCE'			AS OBJECT_TYPE ,
					SEQUENCENAME		AS OBJECT_NAME ,
					SEQUENCENAME		AS OBJ_NAME ,
	--				CURRENTVALUE		AS BIKO
					''					AS BIKO
			from	SYS.SYSSEQUENCES
			where	( '{@OBJECT_TYPE}' = 'SEQUENCE' )
			<og:where startKey="and">
				<og:and value = "SEQUENCENAME like '{@OBJECT_NAME}'" />
			</og:where>
		</og:value>
	</og:equals>

	<!-- EXEC_TYPE=COMPRESS は、DERBY 版のみ -->
	<og:equals val1="{@EXEC_TYPE}" val2="COMPRESS" >
		<og:value command="SQL" action="ROW_APPEND" dbid="{@DBID}">
			select A.TABLENAME as TABLES
			from SYS.SYSTABLES A left outer join SYS.SYSSCHEMAS B
				on A.SCHEMAID = B.SCHEMAID
			where A.TABLETYPE  = 'T'
			<og:where startKey="and">
				<og:and value = "A.TABLENAME  like '{@TABLE}'" />
				<og:and value = "B.SCHEMANAME =    '{@OWNER}'" />
			</og:where>
			order by B.SCHEMANAME,A.TABLENAME
		</og:value>

		<table border="2" frame="box" rules="all">
			<c:forTokens items = "${TABLES}" delims="," var="TBL" >
				<tr><td><og:text>{@TBL}</og:text></td>
					<td>
						<og:query command="NEW" dbid="{@DBID}" >{ call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('{@OWNER}','{@TBL}',1) }</og:query>
					</td>
				</tr>
			</c:forTokens>
		</table>

		<og:text useStop="true"> ======= </og:text>
	</og:equals>
</og:equals>

<!-- 以下の処理は、ORACLE 版 のみ対応 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="ORACLE">
	<og:equals val1="{@OBJECT_TYPE}" val2="{@OBJECT_TYPE}" >
		<og:value key="SQL" >
			select A.OWNER,A.OBJECT_TYPE,A.OBJECT_NAME,
				COALESCE(B.COMMENTS,A.OBJECT_NAME) AS OBJ_NAME,
				A.STATUS AS STTS,'' AS DEL,'' AS COMPILE,
				A.CREATED,A.LAST_DDL_TIME,A.TIMESTAMP
			from ALL_OBJECTS A left outer join DBA_TAB_COMMENTS B
					on  A.OWNER       = B.OWNER
					and A.OBJECT_TYPE = 'TABLE'
					and A.OBJECT_NAME = B.TABLE_NAME
			<og:where>
				<og:and value="A.OWNER		=    '{@OWNER}'"		/>
				<og:and value="A.OBJECT_NAME like '{@OBJECT_NAME}'"	/>
				<og:and value="A.OBJECT_NAME not like 'DBA_%'"		/>
				<og:and value="A.OBJECT_TYPE in ( {@OBJECT_TYPE} )" multi="true" />
				<og:and value="A.STATUS		=	 '{@STTS}'"			/>
				<og:and value="INSTR(A.OBJECT_NAME,'$') < 1" />
			</og:where>
			order by A.OWNER,A.OBJECT_NAME,A.OBJECT_TYPE
		</og:value>

		<og:viewLink command="{@command}">
			<og:link column="OBJECT_NAME" href="viewObject.jsp" target="SUB_WIND"
				keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OWNER],[OBJECT_TYPE],[OBJECT_NAME],{@DBID}" />
			<og:link column="STTS" href="viewObject.jsp" target="SUB_WIND" onLink="INVALID" markList="[STTS]"
				keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OWNER],ERRORS,[OBJECT_NAME],{@DBID}" />
			<og:link column="DEL" href="drop.jsp" target="SUB_WIND" onClick="return confirm('DROP [OBJECT_TYPE] [OBJECT_NAME]');"
				lbl="MSG0058"
				keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OWNER],[OBJECT_TYPE],[OBJECT_NAME],{@DBID}" />
			<og:link column="COMPILE" href="compile.jsp" target="SUB_WIND" lbl="SUBMIT"
				keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OWNER],[OBJECT_TYPE],[OBJECT_NAME],{@DBID}" />
		</og:viewLink>
	</og:equals>

	<og:equals val1="{@EXEC_TYPE}" val2="SHOW_ERROR" >
		<og:value key="SQL" >
			select OWNER,NAME,TYPE,LINE,POSITION,TEXT
			from DBA_ERRORS
			<og:where>
				<og:and value="OWNER	=	 '{@OWNER}'"		/>
				<og:and value="NAME	 like '{@OBJECT_NAME}'"	/>
				<og:and value="TEXT not like 'PL/SQL%ignored%'"	/>
			</og:where>
			order by OWNER,NAME,LINE,POSITION
		</og:value>

		<og:viewLink command="{@command}">
			<og:link column="NAME" href="viewObject.jsp" target="SUB_WIND"
				keys="command,OWNER,TYPE,NAME,LINE,DBID" vals="NEW,[OWNER],[TYPE],[NAME],[LINE],{@DBID}" />
		</og:viewLink>
	</og:equals>

	<og:equals val1="{@EXEC_TYPE}" val2="REFERENCED" contains="true">
		<og:equals val1="{@EXEC_TYPE}" val2="REFERENCED">
			<og:value key="SQL" >
				select OWNER,NAME,TYPE
						,REFERENCED_OWNER as REF_OWNER
						,REFERENCED_NAME  as REF_NAME
						,REFERENCED_TYPE  as REF_TYPE
						,'' DEL
				from dba_dependencies
				<og:where>
					<og:and value="OWNER	=	 '{@OWNER}'"		/>
					<og:and value="NAME    like '{@OBJECT_NAME}'"	/>
					<og:and value="REFERENCED_NAME like '{@REF_NAME}'"	/>
					<og:and value="TYPE in ( {@OBJECT_TYPE} )" multi="true" />
					<og:and value="REFERENCED_TYPE = '{@REF_TYPE}'
								 and exists ( select 'X' from DBA_ERRORS B
										where dba_dependencies.OWNER = B.OWNER
										and   dba_dependencies.NAME  = B.NAME
										and   dba_dependencies.TYPE  = B.TYPE )"	/>
					<og:and value="INSTR(NAME,'$') < 1" />
				</og:where>
				order by OWNER,NAME,TYPE,REF_TYPE,REF_NAME
			</og:value>
		</og:equals>

		<og:equals val1="{@EXEC_TYPE}" val2="REFERENCED_RECDOWN">
			<!-- OWNER,OBJECT_NAME は、必須になる -->
			<og:columnCheck nullCheck="OWNER,OBJECT_NAME" />
			<og:value key="SQL">
				select LEVEL,OWNER,NAME,TYPE
						,REFERENCED_OWNER as REF_OWNER
						,REFERENCED_NAME  as REF_NAME
						,REFERENCED_TYPE  as REF_TYPE
						,'' DEL
				from dba_dependencies
				<og:where>
					<og:and value="OWNER	=	 '{@OWNER}'"		/>
					<og:and value="REFERENCED_NAME like '{@REF_NAME}'"	/>
					<og:and value="TYPE in ( {@OBJECT_TYPE} )" multi="true" />
					<og:and value="REFERENCED_TYPE = '{@REF_TYPE}'
								 and exists ( select 'X' from DBA_ERRORS B
										where dba_dependencies.OWNER = B.OWNER
										and   dba_dependencies.NAME  = B.NAME
										and   dba_dependencies.TYPE  = B.TYPE )"	/>
					<og:and value="INSTR(NAME,'$') < 1" />
				</og:where>
				start with OWNER = '{@OWNER}'
				and NAME = '{@OBJECT_NAME}'
				connect by prior REFERENCED_NAME = NAME
				and prior REFERENCED_TYPE = TYPE
				and prior OWNER = OWNER
				and REFERENCED_NAME != NAME
			</og:value>
		</og:equals>

		<og:equals val1="{@EXEC_TYPE}" val2="REFERENCED_RECUP">
			<!-- OWNER,REF_NAME は、必須になる -->
			<og:columnCheck nullCheck="OWNER,REF_NAME" />
			<og:value key="SQL">
				select LEVEL,OWNER,NAME,TYPE
						,REFERENCED_OWNER as REF_OWNER
						,REFERENCED_NAME  as REF_NAME
						,REFERENCED_TYPE  as REF_TYPE
						,'' DEL
				from dba_dependencies
				<og:where>
					<og:and value="OWNER	=	 '{@OWNER}'"		/>
					<og:and value="NAME like '{@OBJECT_NAME}'"	/>
					<og:and value="TYPE in ( {@OBJECT_TYPE} )" multi="true" />
					<og:and value="REFERENCED_TYPE = '{@REF_TYPE}'
								 and exists ( select 'X' from DBA_ERRORS B
										where dba_dependencies.OWNER = B.OWNER
										and   dba_dependencies.NAME  = B.NAME
										and   dba_dependencies.TYPE  = B.TYPE )"	/>
					<og:and value="INSTR(NAME,'$') < 1" />
				</og:where>
				start with OWNER = '{@OWNER}'
				and REFERENCED_NAME = '{@REF_NAME}'
				connect by prior NAME = REFERENCED_NAME
				and prior TYPE = REFERENCED_TYPE
				and prior OWNER = OWNER
				and REFERENCED_NAME != NAME
			</og:value>
		</og:equals>

		<og:viewLink command="{@command}">
			<og:link column="NAME" href="viewObject.jsp" target="SUB_WIND"
				keys="command,OWNER,TYPE,NAME,REF_NAME,DBID" vals="NEW,[OWNER],[TYPE],[NAME],[REF_NAME],{@DBID}" />
			<og:link column="REF_NAME" href="viewObject.jsp" target="SUB_WIND"
				keys="command,OWNER,TYPE,NAME,REF_NAME,DBID" vals="NEW,[REF_OWNER],[REF_TYPE],[REF_NAME],,{@DBID}" />
			<og:link column="DEL" href="drop.jsp" target="SUB_WIND" onClick="return confirm('DROP [TYPE] [NAME]');"
				lbl="MSG0058"
				keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OWNER],[TYPE],[NAME],{@DBID}" />
		</og:viewLink>
	</og:equals>

	<og:equals val1="{@SEL_TYPE}" val2="ERRCODE" >
		<og:value key="SQL" >
			select ERR_CODE( '{@OBJECT_NAME}' ) from DUAL
		</og:value>
	</og:equals>

	<og:equals val1="{@SEL_TYPE}" val2="KILL" >
		<og:value key="SQL" >
			SELECT '' as DEL,SID,SERIAL# AS SERIAL,
			SCHEMANAME as SCHEMA,OSUSER,MACHINE,MODULE,ACTION,CLIENT_INFO,TYPE,PROGRAM,LOGON_TIME,STATUS
			FROM V$SESSION
			<og:where>
				<og:and value="SCHEMANAME	= '{@OWNER}'"	/>
			</og:where>
			order by SID,SERIAL#
		</og:value>

		<og:viewLink command="{@command}">
			<og:link column="DEL" href="sessionKill.jsp" target="SUB_WIND"
				keys="command,SID,SERIAL,DBID" vals="NEW,[SID],[SERIAL],{@DBID}" lbl="MSG0058" />
		</og:viewLink>
	</og:equals>

	<og:equals val1="{@SEL_TYPE}" val2="LOCK" >
		<og:value command="SQL">
			SELECT B.SID, B.ID1, C.OBJECT_NAME
			FROM V$LOCK B, USER_OBJECTS C
			WHERE C.OBJECT_ID = B.ID1
			AND   ROWNUM = 1
		</og:value>

		<og:value key="SQL" >
			SELECT '' as DEL,'{@OBJECT_NAME}' AS OBJECT_NAME,SID,SERIAL# AS SERIAL,
			SCHEMANAME as SCHEMA,OSUSER,MACHINE,MODULE,ACTION,CLIENT_INFO,TYPE,PROGRAM,LOGON_TIME,STATUS
			FROM V$SESSION
			WHERE SID = '{@SID}'
			<og:where startKey="and">
				<og:and value="SCHEMANAME	= '{@OWNER}'"	/>
			</og:where>
		</og:value>

		<og:viewLink command="{@command}">
			<og:link column="DEL" href="sessionKill.jsp" target="SUB_WIND"
				keys="command,SID,SERIAL,DBID" vals="NEW,[SID],[SERIAL],{@DBID}" lbl="MSG0058" />
		</og:viewLink>
	</og:equals>

	<og:equals val1="{@SEL_TYPE}" val2="CONSTRAINT" >
		<og:value key="SQL" >
			SELECT '' as DEL,OWNER,CONSTRAINT_NAME,CONSTRAINT_TYPE,
					TABLE_NAME,INDEX_NAME,INDEX_OWNER,STATUS,LAST_CHANGE
			FROM USER_CONSTRAINTS
			WHERE CONSTRAINT_NAME not like 'SYS_%'
			AND   CONSTRAINT_NAME not like 'BIN$%'
			<og:where startKey="and">
				<og:and value="OWNER			=	 '{@OWNER}'"		/>
				<og:and value="CONSTRAINT_NAME	like '{@OBJECT_NAME}'"	/>
			</og:where>
			order by OWNER,CONSTRAINT_NAME,CONSTRAINT_TYPE,TABLE_NAME
		</og:value>

		<og:viewLink command="{@command}">
			<og:link column="DEL" href="constraintDrop.jsp" target="SUB_WIND"
				keys="command,CONSTRAINT_NAME,TABLE_NAME,DBID" vals="NEW,[CONSTRAINT_NAME],[TABLE_NAME],{@DBID}" lbl="MSG0058" />
		</og:viewLink>
	</og:equals>

	<og:equals val1="{@EXEC_TYPE}" val2="EXEC_PLAN" >
		<og:forward page="explainPlan.jsp" keys="command" vals="NEW" />
	</og:equals>

	<og:equals val1="{@EXEC_TYPE}" val2="ALL_COMPILE" >
		<og:forward page="allCompile.jsp" keys="command" vals="NEW" />
	</og:equals>

	<og:equals val1="{@EXEC_TYPE}" val2="CHK_ANALYZE" >
		<og:forward page="checkAnalyze.jsp" keys="command" vals="NEW" />
	</og:equals>

	<og:equals val1="{@EXEC_TYPE}" val2="SQL_PLAN" >
		<og:value key="SQL" >
			select
					SORTS			as "SORT回数"				,
					FETCHES			as "FETCHの回数"			,
					EXECUTIONS		as "実行回数"				,
					PARSE_CALLS		as "解析コールの回数"		,
					DISK_READS		as "ディスク読み込み数"		,
					BUFFER_GETS		as "バッファ読み込み数"		,
					ROWS_PROCESSED	as "SQLが戻す行数"			,
					LOADS			,
					CPU_TIME		as "CPU時間(μs)"			,
					ELAPSED_TIME	as "経過時間(μs)"			,
					SQL_ID			,
					SQL_FULLTEXT	,
					FIRST_LOAD_TIME	,
					LAST_LOAD_TIME	,
					LAST_ACTIVE_TIME	,
					OPTIMIZER_MODE	,
					OPTIMIZER_COST	,
					PARSING_SCHEMA_NAME	,
					MODULE
			from V$SQL
			<og:where>
				<og:and value="PARSING_SCHEMA_NAME	= '{@OWNER}'"	/>
			</og:where>
			order by CPU_TIME DESC
		</og:value>

		<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
		<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
		<og:viewLink command="{@command}">
			<og:link column="SQL_ID" href="sqlplan.jsp" target="SUB_WIND"
				keys="command,SQL_ID,DBID"
				vals="NEW,[SQL_ID],{@DBID}" />
		</og:viewLink>
	</og:equals>

	<og:equals val1="{@EXEC_TYPE}" val2="TABLESPACE" >
		<og:forward page="tableSpace.jsp" keys="command" vals="NEW" />
	</og:equals>

	<og:equals val1="{@EXEC_TYPE}" val2="SEQUENCE" >
		<og:value key="SQL">
			select SEQUENCE_OWNER AS OWNER,
					SEQUENCE_NAME AS NAME,
					'CREATE SEQUENCE ' || SEQUENCE_NAME ||
					' INCREMENT BY ' || INCREMENT_BY ||
					' START WITH ' || LAST_NUMBER ||
					' MAXVALUE ' || MAX_VALUE ||
					' CYCLE NOCACHE;' as QUERY
			from DBA_SEQUENCES
			<og:where>
				<og:and value="SEQUENCE_OWNER = '{@OWNER}'" />
				<og:and value="SEQUENCE_NAME like '{@OBJECT_NAME}'"	/>
			</og:where>
			order by SEQUENCE_OWNER,SEQUENCE_NAME
		</og:value>
	</og:equals>

	<og:equals val1="{@EXEC_TYPE}" val2="GREP_SRC" >
		<og:value key="SQL">
			select TYPE,NAME,LINE,TEXT,OWNER
			from DBA_SOURCE
			where   OWNER = '{@OWNER}'
			<og:where startKey="AND">
				<og:and value="NAME like '{@NAME}'"		/>
				<og:and value="TYPE in ( {@OBJECT_TYPE} )" multi="true" />
				<og:and value="TEXT like '{@REF_NAME}'"	/>
			</og:where>
			order by TYPE,NAME,LINE
		</og:value>

		<og:viewLink command="{@command}">
			<og:link column="NAME" href="viewObject.jsp" target="SUB_WIND"
				keys="command,OWNER,TYPE,NAME,LINE,DBID" vals="NEW,{@OWNER},[TYPE],[NAME],[LINE],{@DBID}" />
		</og:viewLink>
	</og:equals>
</og:equals>

<og:equals val1="{@EXEC_TYPE}" val2="FILE_SAVE" >
	<og:forward page="fileSave.jsp" keys="command" vals="NEW" />
</og:equals>

<og:equals val1="{@EXEC_TYPE}" val2="XML_SAVE" >
	<og:forward page="xmlSave.jsp" keys="command" vals="NEW" />
</og:equals>
