<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useAjaxSubmit="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC21"
	title	= "ﾘｿｰｽ未使用検索"
	date	= "2015/06/24"
	author	= "k.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- データが選ばれていなければエラー -->
<og:columnCheck minRowCount="{@minRow}" command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- forward.jsp から command がセットされて遷移してきます。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}" tableId="{@tableId}" useConsistency="false">
	<og:columnSet command="{@command}" columnId="FGLOAD" action="SET" value="{@FGLOAD}" />
</og:entry>

<og:message command="{@command}" /><br />
<form method="POST" action="forward.jsp" target="RESULT">
	<!-- 登録、取消、リセットボタンと、EXCEL(CSV)変更リンクを作成します。 -->
	<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
	<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:writeCheck>
		<og:submit  action="ENTRY" />
		<og:submit  action="RESET" />
		<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
	<br />
	</og:writeCheck>

	<!-- 入力画面を表示します。 -->
	<!-- columnWritable、または noWritable属性でカラムへの入力可／不可を指定します。 -->
	<og:view
		viewFormType	= "HTMLTable"
		command			= "{@command}"
		tableId			= "{@tableId}"
		columnWritable	= "{@columnWritable}"
		columnBulkSet	= "*"
		checked			= "{@checked}"
		startNo			= "{@startNo}"
		pageSize		= "{@pageSize}" />

	<og:hidden name="sqlType" defaultVal="{@command}" value="{@sqlType}" />
	<og:hidden name="tableId" value="{@tableId}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
