<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useAjaxSubmit="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC30"
	title	= "対訳取込"
	date	= "2015/05/09"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- 変更はここから -->

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="NEW" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="NEW" />

<!-- 7:原訳同一の場合のセット(元々が同一の場合) -->
<og:query command="NEW" notfoundMsg="">
	update GF28 set KBHORYU='7'
	where  SYSTEM_ID = '{@MEM.SYSTEM_ID}'
	and    GENBUN    = YAKU
	and    KBHORYU   = '1'					<!-- 対象は、1:翻訳済 のみ -->
</og:query>

<!-- 7:原訳同一の場合のセット(原文が半角の場合、そのままセットする) -->
<og:query command="NEW" notfoundMsg="">
	update GF28 set KBHORYU='7' , YAKU=GENBUN
	where  SYSTEM_ID = '{@MEM.SYSTEM_ID}'
	and    length(GENBUN) = lengthb(GENBUN)
	and    KBHORYU   = '0'					<!-- 対象は、0:初期 のみ -->
</og:query>

<!-- 7:原訳同一の場合のセット(原文が全角記号１文字の場合、そのままセットする) -->
<og:query command="NEW" notfoundMsg="">
	update GF28 set KBHORYU='7' , YAKU=GENBUN
	where  SYSTEM_ID = '{@MEM.SYSTEM_ID}'
	and    length(GENBUN) = 1
	and	(	ASCII( GENBUN ) &lt; 14858880 or
			ASCII( GENBUN ) BETWEEN 14860208 AND 14909824
		)
	and    KBHORYU   = '0'					<!-- 対象は、0:初期 のみ -->
</og:query>

<!-- 8:重複の場合のセット(0:初期 を対象に、原文が同じ 1:翻訳済 のデータをセットする。) -->
<og:query command="NEW" notfoundMsg="">
	update GF28 A set ( A.KBHORYU , A.YAKU ) =
		( select '8', B.YAKU from GF28 B
				where A.SYSTEM_ID = B.SYSTEM_ID
				and   A.GENBUN    = B.GENBUN
				and   A.LANG_YAKU = B.LANG_YAKU
				and   A.UNIQ     != B.UNIQ
				and   B.KBHORYU  = '1'				<!-- 1:翻訳済 のみ -->
		)
	where exists ( select 1 from GF28 C
				where A.SYSTEM_ID = C.SYSTEM_ID
				and   A.GENBUN    = C.GENBUN
				and   A.LANG_YAKU = C.LANG_YAKU
				and   A.UNIQ     != C.UNIQ
				and   C.KBHORYU  = '1'				<!-- 1:翻訳済 のみ -->
		)
	and   A.SYSTEM_ID  = '{@MEM.SYSTEM_ID}'
	and   A.KBHORYU    = '0'						<!-- 対象は、0:初期 のみ -->
</og:query>

<!-- 8:重複の場合のセット (1:翻訳済 を対象に、原文、訳文が同じ場合、8:重複をセット) -->
<og:query command="NEW" notfoundMsg="">
	update GF28 A set A.KBHORYU='8'
	where A.SYSTEM_ID  = '{@MEM.SYSTEM_ID}'
	and   A.KBHORYU    = '1'				<!-- 対象は、1:翻訳済 のみ -->
	and exists (select 'X' from GF28 B
					where A.SYSTEM_ID = B.SYSTEM_ID
					and   A.GENBUN    = B.GENBUN
					and   A.YAKU      = B.YAKU
					and   A.LANG_YAKU = B.LANG_YAKU
					and   A.UNIQ     &lt; B.UNIQ
					and   B.KBHORYU  = '1'				<!-- 1:翻訳済 のみ -->
		)
</og:query>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<!-- 6:ｷｰﾀﾞﾌﾞﾘのピックアップ -->
<og:query command="NEW" debug="{@debug}" maxRowCount="{@MEM.maxRowCount}">
	select A.SYSTEM_ID,A.KEYWORD,A.GENBUN,A.YAKU,A.LANG_YAKU,A.KBYAKU,A.KBHORYU,A.ID,A.COMMENTS,A.UNIQ,A.FGJ
	from   GF28 A
	where exists (select 'X' from GF28 B
					where A.SYSTEM_ID = B.SYSTEM_ID
					and   A.GENBUN    = B.GENBUN
					and   A.YAKU     != B.YAKU			<!-- 訳が異なる -->
					and   A.LANG_YAKU = B.LANG_YAKU
					and   B.KBHORYU   = '1'				<!-- 1:翻訳済 のみ -->
		)
	and   A.SYSTEM_ID = '{@MEM.SYSTEM_ID}'
	and   A.KBHORYU   = '1'				<!-- 1:翻訳済 のみ -->
	<og:where startKey="and">
		<og:and value = "A.LANG_YAKU = '{@MEM.LANG_YAKU}'"	/>
		<og:and value = "A.KBYAKU	 = '{@MEM.KBYAKU}'"		/>
	</og:where>
	order by A.SYSTEM_ID,A.LANG_YAKU,A.GENBUN,A.UNIQ
</og:query>

<form method="POST" action="forward.jsp" target="RESULT">
	<!-- 登録、取消、リセットボタンを作成します。 -->
	<og:writeCheck>
		<og:submit  action="MODIFY"  columnWritable="KBHORYU,YAKU"  />
		<og:submit  action="DELETE"  columnWritable="null" />
	</og:writeCheck>

		<!-- DB検索結果を表示させます。 -->
		<og:view
			viewFormType = "HTMLFormatTable"
			command 	 = "{@command}"
			noDisplay    = "UNIQ,FGJ"
			checked      = "{@checked}"
			startNo      = "{@startNo}"
			pageSize     = "{@pageSize}"
			rowspan      = "2"
		>
		<tr><td>[KBHORYU]  </td><td>[GENBUN]</td><td>[SYSTEM_ID]</td><td>[ID]     </td><td rowspan="2">[COMMENTS]</td></tr>
		<tr><td>[LANG_YAKU]</td><td>[YAKU]  </td><td>[KBYAKU]   </td><td>[KEYWORD]</td></tr>
		</og:view>
</form>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
