<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useAjaxSubmit="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2180"
	title	= "テーブル"
	date	= "2014/05/01"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<og:columnCheck />

<og:entry command="{@command}" />

<!-- To側の件数を設定します -->
<og:equals val1="{@SYSTEM_ID}" notNull="true" >
	<og:query command="NEW" debug="{@debug}" maxRowCount="0" scope="request">
		select TABLE_NAME , NAME_JA , JKENSU as SUIKOU
		from GF02
		where SYSTEM_ID		=    '{@SYSTEM_ID}'
		and   TBLSYU		=    '{@TBLSYU}'
		and   FGJ			in   ('0','1')
		order by SYSTEM_ID,TBLSYU,TABLE_NAME
	</og:query>

	<!-- 取り出したテーブル名を、マージする。 -->
	<og:tableMerge
		action     = "UNION_CLM"
		masterKeys = "TABLE_NAME"
		slaveScope = "request"
		unionClms  = "NAME_JA,SUIKOU"
	/>

	<og:value command="SET" key="T_CLM" value="NAME_JA,SUIKOU" />

</og:equals>

<!-- From側の件数を設定します -->
<og:equals val1="{@F_SYSTEM_ID}" notNull="true" >
	<og:query command="NEW" debug="{@debug}" maxRowCount="0" scope="request">
		select TABLE_NAME as F_TABLE_NAME , NAME_JA as F_NAME_JA , JKENSU as F_SUIKOU
		from GF02
		where SYSTEM_ID		=	'{@F_SYSTEM_ID}'
		and   TBLSYU		=	'{@TBLSYU}'
		and   FGJ			in   ('0','1')
		order by SYSTEM_ID,TBLSYU,TABLE_NAME
	</og:query>

	<!-- 取り出したテーブル名を、マージする。 -->
	<og:tableMerge
		action     = "UNION_CLM"
		masterKeys = "F_TABLE_NAME"
		slaveScope = "request"
		unionClms  = "F_NAME_JA,F_SUIKOU"
	/>

	<og:value command="SET" key="F_CLM" value="F_NAME_JA,F_SUIKOU" />
</og:equals>

<form method="POST" action="forward.jsp" target="RESULT" >
	<og:writeCheck>
		<og:submit  action="ENTRY" />
		<og:submit  action="RESET" />
		<og:input type="reset" name="command" lbl="MSG0011" td="false" />
	<br />
	</og:writeCheck>

	<og:view
		viewFormType	= "HTMLTable"
		command			= "{@command}"
		checked			= "true"
		columnWritable	= "{@T_CLM},{@F_CLM}"
		startNo			= "{@startNo}"
		pageSize		= "10000"
	/>

	<og:hidden name="sqlType" defaultVal="{@command}" value="{@sqlType}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
