<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="init" />

<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6170"
	title	= "Ajaxツリーメニュー"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:columnCheck command="{@command}" />
<og:entry command="{@command}"  />

<!-- 改廃Cのついた行を全て表示します -->
<!-- (チェックされていない行でも、一度編集した行は全てHTMLを返し、初期状態に戻すためです) -->
<!-- tableUpdateタグより先に記述する必要があります -->
<og:view
	viewFormType	= "HTMLAjaxTreeTable"
	command			= "{@command}"
	skip			= "true"
	useParam		= "true">
	<og:ajaxTreeParam
		childSearchKeys	= "EMPNO"
		childSearchJsp	= "result2.jsp"
		levelClm		= "LVL"
		imgCollapsed	= "collapsed.gif"
		imgExpanded		= "expanded.gif"
		imgNoSub		= "nosub.gif"
	/>
</og:view>

<!-- トランザクション 登録処理 -->
<og:transaction>
	<og:tableUpdate
		command		= "{@command}"
		queryType	= "JDBCTableUpdate"
		sqlType		= "INSERT"
		followCdkh	= "true">
		<og:tableUpdateParam
			constObjKey=""
			sqlType	= "INSERT"
			table	= "EMP"
			names	= "EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO"
		/>
	</og:tableUpdate>

	<og:tableUpdate
		command		= "{@command}"
		queryType	= "JDBCTableUpdate"
		sqlType		= "UPDATE"
		followCdkh	= "true">
		<og:tableUpdateParam
			constObjKey=""
			sqlType	= "UPDATE"
			table	= "EMP"
			names	= "EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO"
			where	= "EMPNO=[EMPNO]"
		/>
	</og:tableUpdate>

	<!-- deleteはtableModelの行が削除されるため最後に記述する必要があります -->
	<og:tableUpdate
		command		= "{@command}"
		queryType	= "JDBCTableUpdate"
		sqlType		= "DELETE"
		followCdkh	= "true">
		<og:tableUpdateParam
			constObjKey=""
			sqlType	= "DELETE"
			table	= "EMP"
			names	= "EMPNO"
			where	= "EMPNO=[EMPNO]"
		/>
	</og:tableUpdate>
</og:transaction >

<!-- forwardタグを記述しない場合は、登録行のみをDBTableModelの内容で置きかえします -->
<!--
<og:forward page="result.jsp" keys="command" vals="RENEW" />
-->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
