<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7020"
	title	= "WebService"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:equals val1="{@XSLT}" val2="true" >
	<b>[WikiPediaAPI] URL:http://wikipedia.simpleapi.net/api</b>
	<br />※StringValueの検索キーワードからWikiPediaの情報を取得 → XSLTで変換
	<br />
	<og:urlConnect
		url			= "http://wikipedia.simpleapi.net/api"
		proxyHost	= "{@proxyHost}"
		proxyPort	= "{@proxyPort}"
		keys		= "keyword"
		vals		= "{@StringValue}"
		display 	= "true"
		xslFile		= "{@SYS.REAL_PATH}jsp/{@GAMENID}/wikipediaapi.xsl"
	/>
	<br />
	<hr />
</og:equals>

<og:equals val1="{@TableModel}" val2="true" >
	<b>[WikiPediaAPI] URL:http://wikipedia.simpleapi.net/api</b>
	<br />※StringValueの検索キーワードからWikiPediaの情報を取得 → DBTableModelに変換
	<br />-<br />
	<og:urlConnect
		url			= "http://wikipedia.simpleapi.net/api"
		proxyHost	= "{@proxyHost}"
		proxyPort	= "{@proxyPort}"
		keys		= "keyword"
		vals		= "{@StringValue}"
		rowKey		= "RESULT"
		colKeys		= "LANGUAGE,URL,TITLE,BODY,LENGTH,REDIRECT,STRICT,DATETIME,DUMMY"
	/>
	<og:view height="300px" />
	<hr />
</og:equals>

<og:equals val1="{@GF02}" val2="true" >
	<b>[GE02.xml Get] URL:GF02xml.jsp</b>
	<br />-<br />
	<og:urlConnect
		url			= "http://localhost:8828/gf/jsp/GF7020/GF02xml.jsp"
		keys		= "SYSTEM_ID,TBLSYU,TABLE_NAME"
		vals		= "{@SYSTEM_ID},{@TBLSYU},{@TABLE_NAME}"
		useSystemUser="false"
		authUserPass= "admin:admin"
		rowKey		= "ROW"
		colKeys		= "SYSTEM_ID,TBLSYU,TABLE_NAME,NAME_JA,SKENSU,JKENSU,TABLESPACE_NAME,COMMENTS,INITIAL_EXTENT,FGJ"
		encode		= "UTF-8"
	/>
	<og:view command="NEW" />
	<hr />
</og:equals>

<og:equals val1="{@req}" val2="true" >
	<og:urlConnect
		url			= "http://localhost:8828/gf/jsp/GF7020/req.jsp"
		keys		= "GAMENID"
		vals		= "GF7020"
		useSystemUser="false"
		authUserPass= "admin:admin"
		method		= "PUT"
		display		= "true"
	/>
</og:equals>

<hr />
<og:equals val1="{@smaas}" val2="true" >
	<b>[SMaaS接続] URL:</b>
<og:value key="jsonReturn">
	<og:urlConnect
		url			= "https://smaas.fasysdev.net/smaas-dev/achievement/getreportinfo2"
		proxyHost	= "{@proxyHost}"
		proxyPort	= "{@proxyPort}"
		authJson	= '{"userInfo":{"companyId":"{@companyId}","userId":"{@userId}","password":"{@password}"}}'
		authURL		= 'https://smaas.fasysdev.net/smaas-dev/user/userverification'
		reqJson		= '{"company_id":"{@companyId}","user_id":"{@userId}","session_id":"$session_id$","report_name":"{@report_name}","method":"{@method}","offset":"0","key_ymd":"20210901000000"}'
		display		= "true"
	/>
</og:value>

<div style="white-space: pre;" id="view"><!-- --></div>

<!-- 8.4.1.1 (2023/02/24) headタグ内に移動できないので、title="no_header"追加 -->
<script title="no_header">
//	const val0 = <og:text>{@jsonReturn}</og:text>;
//	const val1 = JSON.stringify(val0);
//	const val2 = JSON.parse(val1);
//	const jsonV = JSON.stringify(val2,null,2);

	const jsonV = JSON.stringify(<og:text>{@jsonReturn}</og:text>,null,2);

	var view = document.getElementById("view");
	view.innerHTML = jsonV ;
</script>
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
