<jsp:directive.page pageEncoding="UTF-8" />

<og:query command="NEW" stopZero="{@stopZero}">
	SELECT 	 ENAME
			,ROUND( SAL / 2   * DBMS_RANDOM.VALUE ) as SAL1
			,ROUND( SAL / 2.5 * DBMS_RANDOM.VALUE ) as SAL2
			FROM EMP
			<og:where>
				<og:and value=" DEPTNO = {@SOOUID}" />
				<og:and value=" EMPNO like {@EMPNO}" />
			</og:where>
</og:query>

<fieldset style="display:inline-block;" >
	<legend>JavaScript</legend>
	<canvas id="mycanvas" style="width:400px; height:400px;"><!-- --></canvas>
</fieldset>

<!-- 8.4.1.1 (2023/02/24) headタグ内に移動できないので、title="no_header"追加 -->
<script title="no_header">
	// jsonで取得
	var querydata =
	<og:view
		viewFormType	= "JSON"
		command			= "NEW"
		useHilightRow	= "false"
		useAfterHtmlTag	= "false"
		useConsistency	= "false"
		pageSize		= "0" />
	;

	var datadata1   = [];
	var datadata2   = [];
	var datalabels = [];
	for(var i=0; i < querydata.DATA.length; i++){
		datadata1[i]  = querydata.DATA[i].SAL1;
		datadata2[i]  = querydata.DATA[i].SAL2;
		datalabels[i] = querydata.DATA[i].ENAME;
	}

	var chartdata = {
		labels: datalabels,
		datasets: [{
			label: 'SAL1',		//凡例
			fill: false,		//面の表示
			lineTension: 0.5,	//線のカーブ
			data: datadata1,
			backgroundColor: 	'rgba(255, 99, 132, 0.2)',
			borderColor:		'rgba(255,99,132,1)',
			borderWidth: 1
		},{
			label: 'SAL2',		//凡例
			fill: false,		//面の表示
	//		lineTension: 0.5,	//線のカーブ
			data: datadata2,
			backgroundColor: [ "#FF6384", "#36A2EB", "#FFCE56","#FF6384", "#36A2EB", "#FFCE56","#FF6384", "#36A2EB", "#FFCE56","#FF6384", "#36A2EB", "#FFCE56" ],
			borderColor:		'rgba(75,192,192,1)',
			borderWidth: 1
		}],
	};

	<og:text>
	var myChart = new Chart( mycanvas,{
					type: '{@chartType}',
					data: chartdata,
					plugins: [chartLabelPlugin],
					options: {
					    responsive: false ,
						animation : false ,			// false にしないと、Chart.plugins.register で、２回呼ばれる。
					}
				});
	</og:text>
</script>

<fieldset style="display:inline-block;">
	<legend>jsChart</legend>
	<og:jsChart
		chartType	= "{@chartType}"
		labelColumn	= "ENAME"
		title		= "{@chartTitle}"
		optOptions	= "animation:false"
		optTicks	= "color:'black'"
		plugins		= "chartLabelPlugin"
		optLegend	= "onClick:function(event, legendItem, legend){return;}"
	>
		<og:jsChartData
			chartColumn		= "SAL1"
			label			= "{@LBL.SAL}"
			backgroundColor	= "rgba(255, 99, 132, 0.2)"
			borderColor		= "rgba(255,99,132,1)"
			fontColor		= "black"
			tension			= "0.5"
			borderWidth		= "1"
		/>
		<og:jsChartData
			chartColumn		= "SAL2"
			label			= "{@LBL.COMM}"
			backgroundColor	= "#FF6384,#36A2EB,#FFCE56,#FF6384,#36A2EB,#FFCE56,#FF6384,#36A2EB,#FFCE56,#FF6384,#36A2EB,#FFCE56"
			borderColor		= "rgba(75,192,192,1)"
			borderWidth		= "1"
		/>
	</og:jsChart>
</fieldset>
