<jsp:directive.page pageEncoding="UTF-8" />

<!-- カテゴリがどれだけあるかをピックアップしておきます。 -->
<og:value command="SQL" action="ROW_APPEND">
	select GUIKEY from GE15
	where GUIKEY is not null
--	and   DYLOGIN >= '20210609080000'
--	and   DYLOGIN <= TO_CHAR( TO_DATE( '20210609080000', 'YYYYMMDDHH24MISS' ) + 24/24 , 'YYYYMMDDHH24MISS' )
	group by GUIKEY
	order by GUIKEY
</og:value>

<og:query command="NEW" stopZero="{@stopZero}">
	select DYLOGIN ,
		case when SYSTEM_ID = 'GE' then GUIKEY else null end as GE ,
		case when SYSTEM_ID = 'GG' then GUIKEY else null end as GG
	from GE15
	where GUIKEY is not null
--	and   DYLOGIN >= '20210609080000'
--	and   DYLOGIN <= TO_CHAR( TO_DATE( '20210609080000', 'YYYYMMDDHH24MISS' ) + 24/24 , 'YYYYMMDDHH24MISS' )
	order by 1,2
</og:query>

<fieldset style="display:inline-block;">
	<legend>jsChart</legend>
	<og:jsChart
		chartType		= "line"
		height			= "{@height}"
		width			= "1000px"
		xscaleType		= "time"
		labelColumn		= "DYLOGIN"
		timeParser		= "yyyyMMddHHmmss"
		timeLblFormat	= "MM/dd HH:mm"
		title			= "{@chartTitle}"
		valueQuot		= "true"
		debug			= "{@debug}"
	>
		<og:jsChartData
			chartColumn		= "GE"
			label			= "GE"
			scaleType		= "category"
			categoryList	= ",{@GUIKEY},"
			spanGaps		= "false"
		/>
		<og:jsChartData
			chartColumn		= "GG"
			label			= "GG"
			scaleType		= "category"
			categoryList	= ",{@GUIKEY},"
			spanGaps		= "false"
		/>
	</og:jsChart>
</fieldset>

<og:view />
