<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- ﾁｬｰﾄ情報の取得 -->
<og:query command="NEW">
	SELECT	 A.ENAME as LABELS
			,A.SAL as VAL1
			,B.SAL as VAL2
	FROM BONUS A
	left outer join EMP B
	on A.ENAME = B.ENAME
	order by B.EMPNO
</og:query>

<!--
	jsChartのchartTypeに「line」,
	jsChartDataのoptDatasetに「segment」属性を設定して下さい

	type: 'segment'
	p0: first point element
	p1: second point element
	p0DataIndex: index of first point in the data array
	p1DataIndex: index of second point in the data array
	datasetIndex: dataset index
-->

<og:jsChart
	chartType		= "line"
	height			= "{@height}"
	width			= "{@width}"
	minLabelWidth	= "{@minLabelWidth}"
	labelColumn		= "LABELS"
	plugins			= "chartLabelPlugin"
	debug			= "{@debug}"
>
	<!-- 点線の描画方法変更 -->
	<og:jsChartData
		chartColumn	= "VAL1"
		label		= "{@LBL.SAL}"
		borderColor	= "VIVID"
		fontColor	= "black"
		grace		= "{@grace}"
		optDataset	= "segment: {borderDash: ctx =&gt; down(ctx, [6, 6])}"
		spanGaps	= "true"
	/>
	<!-- 現在の要素 が 次の要素 より大きいのが対象 -->
	const down = (ctx, value) =&gt; CLM0[ctx.p0DataIndex] &gt; CLM0[ctx.p1DataIndex] ? value : undefined;

	<!-- 線の色変更 -->
	<og:jsChartData
		chartColumn	= "VAL2"
		label		= "{@LBL.COMM}"
		borderColor	= "PASTEL"
		optDataset	= "segment: borderCol"
		spanGaps	= "true"
	/>
	<!-- ｱﾄﾞﾚｽが5以上 が対象 -->
	const seg = (ctx, value) =&gt; ctx.p0DataIndex &gt;= 5 ? value : undefined;
	const borderCol = {borderColor: ctx =&gt; seg(ctx, 'rgb(192,75,75)')};
</og:jsChart>

<og:view useScrollBar="false" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
