<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- ﾃﾞｰﾀは使いませんが、tableModelは必須 -->
<og:query command="NEW" >
	SELECT	 '' as VAL1
			,'' as VAL2
			,'' as VAL3
	FROM DUAL
	where 1 = 2
</og:query>

<!--
	useVertStrm = "true" を指定すると、chartjs-plugin-streaming の Vertical Scroll(垂直ｽｸﾛｰﾙ)となります。
	indexAxis = "y" を指定しないと、Y軸の表示が行われません。
-->

<og:jsChart
	chartType		= "line"
	labelColumn		= "VAL1"
	indexAxis		= "y"
	xscaleType		= "realtime"
	height			= "{@height}"
	width			= "{@width}"
	minLabelWidth	= "{@minLabelWidth}"
	title			= "{@chartTitle}"
	useVertStrm		= "true"
	optAxis			= "realtime:RT"
	optOptions		= "tooltips:{mode:'nearest',intersect: false},hover:{mode:'nearest',intersect: false},options:{scales:{x:y0Ax,y:x0Ax}}"
	debug			= "{@debug}"
>
var RT = {
	frameRate:	30,
	duration:	30000,
	refresh:	5000,
	delay:		5000,
	onRefresh: function(chart) {
		updatechart( chart );
	}
};
	<og:jsChartData
			chartColumn		= "VAL2"
			label			= "VAL2"
			backgroundColor	= "blue"
	/>
	<og:jsChartData
			chartColumn		= "VAL3"
			label			= "VAL3"
			backgroundColor	= "green"
	/>
</og:jsChart>

<!-- 8.4.1.1 (2023/02/24) headタグ内に移動できないので、title="no_header"追加 -->
<script title="no_header">
	var updatechart = function(_chart){
		if( _chart ) {
			$.ajax({
				url:'sample14B_ajax.jsp',
				async:true, // 非同期通信
				type: 'GET',
				data: {'ENAME': 'SMITH'},
				dataType: 'json',
				success: function(jsn){
					for(var i=0; i&lt; jsn.DATA.length; i++){
//						_chart.CLM0.push( parseInt( jsn.DATA[i].SALES ) );
//						_chart.CLM1.push( parseInt( jsn.DATA[i].AMOUNT) );
						_chart.data.datasets[0].data.push({
							y: Date.now(),
							x: jsn.DATA[i].SALES
						});

						_chart.data.datasets[1].data.push({
							y: Date.now(),
							x: jsn.DATA[i].AMOUNT
						});
					}
//					_chart.VAL1.push( Date.now() );
					_chart.update();
				},
				error: function(err){
					$('#err').html(err.responseText);
				}
			});
		}
	}
</script>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
