<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- ﾁｬｰﾄ情報の取得 -->
<og:query command="NEW">
	SELECT A.ENAME		as LABELS
			, A.SAL		as VAL1
			, B.SAL		as VAL2
			, B.DEPTNO	as RAD
	FROM BONUS A left outer join EMP B
		on A.ENAME = B.ENAME
	order by B.EMPNO
</og:query>

<!--
	bubble の場合は、x:をchartColumnをつかい、y:,r: を varColumns で指定します。
-->

<og:jsChart
	chartType		= "bubble"
	labelColumn		= "LABELS"
	varColumns		= "VAL2,RAD"
	optOptions		= "animation:false"
	debug			= "{@debug}"
	plugins			= "chartLabelPlugin"
>
	<og:jsChartData
		chartColumn		= "VAL1"
		label			= "{@LBL.COMM}"
		borderColor		= "PASTEL"
	/>
</og:jsChart>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
