<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9160"
	title	= "3ペインサンプル"
	date	= "2015/06/19"
	author	= "LEE.M"
	text	= "ｺﾋﾟｰ元:品目(BAS3021)"
	version	= "001">
</og:comment>

<!-- history.back() で戻るﾎﾞﾀﾝを表示します｡ -->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- ｶﾗﾑﾁｪｯｸ -->
<og:columnCheck command="{@command}" />
<og:columnCheck command="{@command}" tableId="3PAIN1" />
<og:columnCheck command="{@command}" tableId="3PAIN2" />

<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<!-- 複数の tableId のﾘｸｴｽﾄ変数が混ざるので、strictCheck="false" が必要 -->
<og:entry command="{@command}" strictCheck="false" />
<og:entry command="{@command}" strictCheck="false" tableId="3PAIN1" />
<og:entry command="{@command}" strictCheck="false" tableId="3PAIN2" />

<og:value command="SET" key="FMT" value="'YYMMDDHH24MISS'" />	<!-- 日付データと、funcVals が、カンマで分割されてしまう対策 -->

<!-- JDBCTableUpdateで実行します｡ -->
<og:transaction>
	<!-- 追加／複写／変更 --><!-- 2017/05/17 MOD -->
	<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate" debug="{@debug}">
		<og:tableUpdateParam
			sqlType		= "{@sqlType}"
			names		= "EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO"
			table		= "EMP"
			where		= "EMPNO=[EMPNO]"
			funcKeys	= "HIREDATE"
			funcVals	= '"TO_DATE( [HIREDATE] , {@FMT} )"'
			constObjKey = " "
		/>
	</og:tableUpdate>

	<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate" debug="{@debug}" tableId="3PAIN1">
		<og:tableUpdateParam
			sqlType		= "{@sqlType}"
			names		= "DNAME,LOC"
			table		= "DEPT"
			where		= "DEPTNO=[DEPTNO]"
			constObjKey = " "
		/>
	</og:tableUpdate>

	<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate" debug="{@debug}" tableId="3PAIN2">
		<og:tableUpdateParam
			sqlType		= "{@sqlType}"
			orgNames	= "JOB,SAL,COMM"
			asNames		= "B_JOB,B_SAL,B_COMM"
			table		= "BONUS"
			where		= "ENAME=[ENAME]"
			constObjKey = " "
		/>
	</og:tableUpdate>
</og:transaction>

<!-- 2016/04/20 MOD -->
<og:equals val1="{@MEM.RETURN_TO_INPUT}" val2="TRUE" notEquals="true">
	<og:forward page="result.jsp" keys="command,SEL_ROW" vals="RENEW,{@RNUM}" target="CONTENTS.RESULT" />
</og:equals>
<og:equals val1="{@MEM.RETURN_TO_INPUT}" val2="TRUE">
	<og:forward page="result1.jsp" keys="command,SEL_ROW" vals="RENEW,{@RNUM}" />
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
