<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9310"
	title	= "標準(タグ)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- エラー時の戻るボタン。書き換えないで下さい。-->
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheck のみ有効です。カラムに付いては、全カラムをチェックしています。-->
<og:columnCheck
	command   = "{@command}"
	nullCheck = "SYSTEM_ID,LANG,CLM"
/>

<!-- エントリー形式の、entry.jsp では、entryタグは不要です。 -->
<!-- <og:entry command="{@command}"  /> -->

<!-- マスタチェックです。エントリー系では、TableExistTag は使えません。-->
<!-- また、検索後、キーの書き換え等が発生しますので、登録直前にチェックします。-->
<og:value command="SQL">
		select count(*) AS CNT
		from GF41
		where FGJ         in  ('0','1')
		and   SYSTEM_ID   = '{@SYSTEM_ID}'
		and   LANG        = '{@LANG}'
		and   CLM         = '{@CLM}'
</og:value>

<!-- トランザクション 登録処理 -->
<og:transaction>
	<!-- CNT値が0の場合、INSERTします。 -->
	<og:equals val1="{@CNT}" val2="0" >
		<og:query	command="NEW" >
				INSERT INTO GF41
					(CLM,NAME_JA,LABEL_NAME,KBSAKU,SYSTEM_ID,LANG,
					 FGJ,DYSET,DYUPD,USRSET,USRUPD,PGSET,PGUPD)
				VALUES
					('{@CLM}','{@NAME_JA}','{@LABEL_NAME}','{@KBSAKU}','{@SYSTEM_ID}','{@LANG}',
					 '1','{@USER.YMDH}','{@USER.YMDH}','{@USER.ID}','{@USER.ID}','{@GUI.KEY}','{@GUI.KEY}')
		</og:query>
	</og:equals>
	<!-- notEquals="true" 属性で、equalsの結果を反転できます。-->
	<og:equals val1="{@CNT}" val2="0" notEquals="true" >
		<og:query	command="NEW" >
				UPDATE GF41 SET
						NAME_JA		= '{@NAME_JA}',
						LABEL_NAME	= '{@LABEL_NAME}',
						KBSAKU		= '{@KBSAKU}',
						DYUPD		= '{@USER.YMDH}',
						USRUPD		= '{@USER.ID}',
						PGUPD		= '{@GUI.KEY}'
				WHERE SYSTEM_ID = '{@SYSTEM_ID}'
				AND   LANG		= '{@LANG}'
				AND   CLM		= '{@CLM}'
		</og:query>
	</og:equals>
	<og:equals val1="{@command}" val2="DELETE" >
		<og:query	command="NEW" >
				DELETE FROM GF41
				WHERE SYSTEM_ID = '{@SYSTEM_ID}'
				AND   LANG		= '{@LANG}'
				AND   CLM		= '{@CLM}'
		</og:query>
	</og:equals>
</og:transaction >

<!-- 今回登録したデータを表示させる為の引数を、vals 属性に設定します。-->
<og:forward page="result.jsp" keys="command,SYSTEM_ID,LANG,CLM" vals="RENEW,{@SYSTEM_ID},{@LANG},{@CLM}" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>

