/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.util;

import org.opengion.fukurou.system.OgRuntimeException;				// 6.4.2.0 (2016/01/29)
import java.awt.Component;
//import java.awt.Graphics;											// 8.4.1.0 (2023/02/10) Delete
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
//import java.nio.charset.Charset;									// 7.2.3.0 (2020/04/10) 8.4.1.0 (2023/02/10) Delete
//import java.nio.charset.StandardCharsets;							// 7.2.3.0 (2020/04/10) 8.4.1.0 (2023/02/10) Delete

import java.util.HashMap;											// 8.4.1.0 (2023/02/10) Add
import java.util.Map;												// 8.4.1.0 (2023/02/10) Add

//import com.swetake.util.Qrcode;									// 8.4.1.0 (2023/02/10) Delete
import com.google.zxing.BarcodeFormat;								// 8.4.1.0 (2023/02/10) Add
import com.google.zxing.EncodeHintType;								// 8.4.1.0 (2023/02/10) Add
import com.google.zxing.WriterException;							// 8.4.1.0 (2023/02/10) Add
import com.google.zxing.client.j2se.MatrixToImageWriter;			// 8.4.1.0 (2023/02/10) Add
import com.google.zxing.common.BitMatrix;							// 8.4.1.0 (2023/02/10) Add
import com.google.zxing.qrcode.QRCodeWriter;						// 8.4.1.0 (2023/02/10) Add

import org.opengion.fukurou.system.HybsConst;						// fukurou.util.StringUtil → fukurou.system.HybsConst に変更
//import org.opengion.fukurou.system.LogWriter;						// 6.4.2.0 (2016/01/29) package変更 fukurou.util → fukurou.system 8.4.1.0 (2023/02/10) Delete

/**
 * QrcodeImage は、2次元ﾊﾞｰｺｰﾄﾞの QRｺｰﾄﾞｲﾒｰｼﾞを生成する
 * 独立したｺﾝﾎﾟｰﾈﾝﾄです。
 *
 * 8.4.1.0 (2023/02/10) swetake から ZXing への置換
 * <del>ここでの使い方は、初期化時に、ｴﾝｺｰﾄﾞする文字列(120Byte以内)と、
 * 出力ﾌｧｲﾙ名を指定して、Graphics に描画したQRｺｰﾄﾞｲﾒｰｼﾞを
 * JPEG 変換し、指定のﾌｧｲﾙに上書き保存しています。
 * QRｺｰﾄﾞ作成に、http://www.swetake.com/ の Qrcode ｸﾗｽを使用しています。
 * これが、2004/11/7  ver.0.50beta9 とのことなので、動作ﾁｪｯｸ、および、
 * 製品としての保証という意味では、まだ使えるﾚﾍﾞﾙではありませんが、
 * ｺｰﾄﾞ計算さえﾊﾞｸﾞっていなければ使えうる為、試験的導入致します。</del>
 *
 * ZXing (com.google.zxing) の Qrcode ｸﾗｽを使用しています。
 * ｴﾝｺｰﾄﾞﾓｰﾄﾞ ('N':数字ﾓｰﾄﾞ 'A':英数字ﾓｰﾄﾞ 'B':8bit byteﾓｰﾄﾞ) は
 * 自動判定になる為、廃止されました。
 *
 * @og.rev 8.4.1.0 (2023/02/10) QRｺｰﾄﾞを swetake から ZXing への置換(encodeMode廃止)
 *
 * @version	4.0
 * @author	Kazuhiko Hasegawa
 * @since	JDK5.0,
 */
public class QrcodeImage extends Component {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "8.4.1.0 (2023/02/10)" ;
	private static final long serialVersionUID = 841020230210L ;

	// version  0 ～ 39 => 1 ～ 40
//	// errCo    H,M    0:H 1:M
	// errCo    L,M,Q,H						// 7.2.1.0 (2020/03/13)
//	// encMd    N,A,B  0:N 1:A 2:B			// 8.4.1.0 (2023/02/10) Delete

	// 8.4.1.0 (2023/02/10) Delete
//	private static final int[][][] QC_DATA = new int[][][] {
//		{{   17 ,   10 ,   4 } , {   34 ,   20 ,    8 }} ,
//		{{   34 ,   20 ,   8 } , {   63 ,   38 ,   16 }} ,
//		{{   58 ,   35 ,  15 } , {  101 ,   61 ,   26 }} ,
//		{{   82 ,   50 ,  21 } , {  149 ,   90 ,   38 }} ,
//		{{  106 ,   64 ,  27 } , {  202 ,  122 ,   52 }} ,
//		{{  139 ,   84 ,  36 } , {  255 ,  154 ,   65 }} ,
//		{{  154 ,   93 ,  39 } , {  293 ,  178 ,   75 }} ,
//		{{  202 ,  122 ,  52 } , {  365 ,  221 ,   93 }} ,
//		{{  235 ,  143 ,  60 } , {  432 ,  262 ,  111 }} ,
//		{{  288 ,  174 ,  74 } , {  513 ,  311 ,  131 }} ,
//		{{  331 ,  200 ,  85 } , {  604 ,  366 ,  155 }} ,
//		{{  374 ,  227 ,  96 } , {  691 ,  419 ,  177 }} ,
//		{{  427 ,  259 , 109 } , {  796 ,  483 ,  204 }} ,
//		{{  468 ,  283 , 120 } , {  871 ,  528 ,  223 }} ,
//		{{  530 ,  321 , 136 } , {  991 ,  600 ,  254 }} ,
//		{{  602 ,  365 , 154 } , { 1082 ,  656 ,  277 }} ,
//		{{  674 ,  408 , 173 } , { 1212 ,  734 ,  310 }} ,
//		{{  746 ,  452 , 191 } , { 1346 ,  816 ,  345 }} ,
//		{{  813 ,  493 , 208 } , { 1500 ,  909 ,  384 }} ,
//		{{  919 ,  557 , 235 } , { 1600 ,  970 ,  410 }} ,
//		{{  969 ,  587 , 248 } , { 1708 , 1035 ,  438 }} ,
//		{{ 1056 ,  640 , 270 } , { 1872 , 1134 ,  480 }} ,
//		{{ 1108 ,  672 , 284 } , { 2059 , 1248 ,  528 }} ,
//		{{ 1228 ,  744 , 315 } , { 2188 , 1326 ,  561 }} ,
//		{{ 1286 ,  779 , 330 } , { 2395 , 1451 ,  614 }} ,
//		{{ 1425 ,  864 , 365 } , { 2544 , 1542 ,  652 }} ,
//		{{ 1501 ,  910 , 385 } , { 2701 , 1637 ,  692 }} ,
//		{{ 1581 ,  958 , 405 } , { 2857 , 1732 ,  732 }} ,
//		{{ 1677 , 1016 , 430 } , { 3035 , 1839 ,  778 }} ,
//		{{ 1782 , 1080 , 457 } , { 3289 , 1994 ,  843 }} ,
//		{{ 1897 , 1150 , 486 } , { 3486 , 2113 ,  894 }} ,
//		{{ 2022 , 1226 , 518 } , { 3693 , 2238 ,  947 }} ,
//		{{ 2157 , 1307 , 553 } , { 3909 , 2369 , 1002 }} ,
//		{{ 2301 , 1394 , 590 } , { 4134 , 2506 , 1060 }} ,
//		{{ 2361 , 1431 , 605 } , { 4343 , 2632 , 1113 }} ,
//		{{ 2524 , 1530 , 647 } , { 4588 , 2780 , 1176 }} ,
//		{{ 2625 , 1591 , 673 } , { 4775 , 2894 , 1224 }} ,
//		{{ 2735 , 1658 , 701 } , { 5039 , 3054 , 1292 }} ,
//		{{ 2927 , 1774 , 750 } , { 5313 , 3220 , 1362 }} ,
//		{{ 3057 , 1852 , 784 } , { 5596 , 3391 , 1435 }} } ;

	/** ｴﾗｰ訂正ﾚﾍﾞﾙ ('L','M','Q','H')	*/
	public enum ErrCrct {
//	public static enum ErrCrct {
//					H(0),M(1);
					/** ｴﾗｰ訂正ﾚﾍﾞﾙ */ L(1),
					/** ｴﾗｰ訂正ﾚﾍﾞﾙ */ M(0),
					/** ｴﾗｰ訂正ﾚﾍﾞﾙ */ Q(3),
					/** ｴﾗｰ訂正ﾚﾍﾞﾙ */ H(2);						// 7.2.1.0 (2020/03/13)
					private int no;
					/** 初期ｴﾗｰ訂正ﾚﾍﾞﾙ */
					public static final ErrCrct DEF = M;
					/**
					 * enum	ｺﾝｽﾄﾗｸﾀｰ
					 *
					 * @param	no	番号
					 */
					ErrCrct( final int no ) { this.no = no; }
					/**
					 * 番号を取得します。
					 *
					 * @return	番号
					 */
					public int getNo() { return no; }
					/**
					 * ﾁｬﾈﾙを取得します。
					 *
					 * @og.rev 7.2.1.0 (2020/03/13) QrcodeImage 見直し。
					 *
					 * @return	ﾁｬﾈﾙｷｬﾗｸﾀ
					 */
					public char getCh() {
						final char ch ;
						switch(this) {
							case L:  ch = 'L'; break;			// 7.2.1.0 (2020/03/13)
							case Q:  ch = 'Q'; break;			// 7.2.1.0 (2020/03/13)
							case H:  ch = 'H'; break;
							case M:
							default: ch = 'M'; break;
						}
						return ch ;
					}
					/**
					 * ﾁｬﾈﾙに応じたｴﾗｰ訂正を取得します。
					 *
					 * @og.rev 7.2.1.0 (2020/03/13) QrcodeImage 見直し。
					 *
					 * @param	ch	ﾁｬﾈﾙｷｬﾗｸﾀ
					 * @return	ｴﾗｰ訂正
					 */
					public static ErrCrct get( final char ch ) {
						final ErrCrct rtn ;
						switch(ch) {
							case 'L': rtn = L; break;			// 7.2.1.0 (2020/03/13)
							case 'Q': rtn = Q; break;			// 7.2.1.0 (2020/03/13)
							case 'H': rtn = H; break;
							case 'M':
							default:  rtn = M; break;
						}
						return rtn ;
					}
	};

	// 8.4.1.0 (2023/02/10) Delete
//	/** ｴﾝｺｰﾄﾞﾓｰﾄﾞ ('N':数字ﾓｰﾄﾞ 'A':英数字ﾓｰﾄﾞ 'B':8bit byteﾓｰﾄﾞ) */
//	public enum EncMode {
////	public static enum EncMode {
//					/** ｴﾝｺｰﾄﾞﾓｰﾄﾞ */ N(0),
//					/** ｴﾝｺｰﾄﾞﾓｰﾄﾞ */ A(1),
//					/** ｴﾝｺｰﾄﾞﾓｰﾄﾞ */ B(1);
//					private int no;
//					/** 初期ｴﾝｺｰﾄﾞﾓｰﾄﾞ */
//					public static final EncMode DEF = B;
//
//					/**
//					 * ｴﾝｺｰﾄﾞﾓｰﾄﾞ enum を構築するｺﾝｽﾄﾗｸﾀ
//					 *
//					 * @param	ｴﾝｺｰﾄﾞﾓｰﾄﾞの番号
//					 */
//					EncMode( final int no ) { this.no = no; }
//
//					/**
//					 * ｴﾝｺｰﾄﾞﾓｰﾄﾞの番号を返します。
//					 * 'N'=0:数字ﾓｰﾄﾞ
//					 * 'A'=1:英数字ﾓｰﾄﾞ
//					 * 'B'=1:8bit byteﾓｰﾄﾞ
//					 *
//					 * @return	ｴﾝｺｰﾄﾞﾓｰﾄﾞの番号
//					 */
//					public int getNo() { return no; }
//
//					/**
//					 * ｴﾝｺｰﾄﾞﾓｰﾄﾞを表す文字
//					 * 'N':数字ﾓｰﾄﾞ
//					 * 'A':英数字ﾓｰﾄﾞ
//					 * 'B':8bit byteﾓｰﾄﾞ
//					 *
//					 * @return	ｴﾝｺｰﾄﾞﾓｰﾄﾞを指定する文字('N':数字ﾓｰﾄﾞ 'A':英数字ﾓｰﾄﾞ 'B':8bit byteﾓｰﾄﾞ)
//					 */
//					public char getCh() {
//						final char ch ;
//						switch(this) {
//							case N:  ch = 'N'; break;
//							case A:  ch = 'A'; break;
//							case B:
//							default: ch = 'B'; break;
//						}
//						return ch ;
//					}
//
//					/**
//					 * ｴﾝｺｰﾄﾞﾓｰﾄﾞを指定する文字から、ｴﾝｺｰﾄﾞﾓｰﾄﾞ enum を作成します。
//					 * 'N':数字ﾓｰﾄﾞ
//					 * 'A':英数字ﾓｰﾄﾞ
//					 * 'B':8bit byteﾓｰﾄﾞ
//					 *
//					 * @param	ch	ｴﾝｺｰﾄﾞﾓｰﾄﾞを指定する文字
//					 * @return	ｴﾝｺｰﾄﾞﾓｰﾄﾞ
//					 */
//					public static EncMode get( final char ch ) {
//						final EncMode rtn ;
//						switch(ch) {
//							case 'N': rtn = N; break;
//							case 'A': rtn = A; break;
//							case 'B':
//							default:  rtn = B; break;
//						}
//						return rtn ;
//					}
//	};

	/** ﾊﾞｰｼﾞｮﾝ (1から40の整数。0を設定すると自動設定になります。) 初期値:{@value} */
	public static final int DEF_VERSION = 5;		// 5.7.1.1 (2013/12/13) VERSION ﾁｪｯｸのために、IDを変更します。
	/** ｾﾙのﾏｰｼﾞﾝ 初期値:{@value} */
	public static final int MARGIN = 4;
	/** 1ｾﾙ辺りの塗りつぶしﾋﾟｸｾﾙ 初期値:{@value} */
	public static final int PIXEL = 3;
	/** 出力ｲﾒｰｼﾞのﾀｲﾌﾟ(PNG/JPEG) 初期値:{@value} */
	public static final String IMAGE_TYPE = "PNG";

	/** ｴﾝｺｰﾄﾞする文字列 */
	private String	qrData;
	/** 出力ﾌｧｲﾙ名 */
	private String	saveFile;
	/** ｲﾒｰｼﾞﾌｧｲﾙ形式(PNG/JPEG) 初期値:PNG */
	private String	imgType	= IMAGE_TYPE;
	/** ｴﾗｰ訂正ﾚﾍﾞﾙ ('L','M','Q','H') 初期値:M */
	private ErrCrct	errCo	= ErrCrct.DEF;
//	private EncMode	encMd	= EncMode.DEF;			// 8.4.1.0 (2023/02/10) Delete
	/** ﾊﾞｰｼﾞｮﾝ (2から40の整数) 初期値:5 */
	private int		version	= DEF_VERSION;			// 5.7.1.1 (2013/12/13) VERSION ﾁｪｯｸのために、IDを変更します。
//	private int		pixel	= PIXEL;				// 8.4.1.0 (2023/02/10) Delete
	/** ﾃｷｽﾄ文字ｴﾝｺｰﾄﾞ */
	private String	txtEnc;							// 7.2.3.0 (2020/04/10) 

	/** ｻｲｽﾞ */
	private int		imageSize;

	/**
	 * 初期化ﾒｿｯﾄﾞ
	 *
	 * ｴﾗｰ訂正ﾚﾍﾞﾙ:M , ﾏｰｼﾞﾝ:4(ｾﾙ分) , 塗りつぶしﾋﾟｸｾﾙ:3
	 * <del>ｴﾝｺｰﾄﾞﾓｰﾄﾞ:B(ﾊﾞｲﾅﾘ)</del> ﾊﾞｰｼﾞｮﾝ:5 , ｲﾒｰｼﾞのﾀｲﾌﾟ:PNG
	 * に初期化されます。
	 *
	 * @og.rev 5.7.1.1 (2013/12/13) VERSION ﾁｪｯｸのために、VERSION ⇒ DEF_VERSION に変更します。
	 * @og.rev 7.2.3.0 (2020/04/10) byteﾓｰﾄﾞ時のﾃｷｽﾄ文字ｴﾝｺｰﾄﾞ。
	 * @og.rev 8.4.1.0 (2023/02/10) QRｺｰﾄﾞを swetake から ZXing への置換(encodeMode廃止)
	 *
	 * @param	qrData		ｴﾝｺｰﾄﾞする文字列(120Byte 以内)
	 * @param	saveFile	出力ﾌｧｲﾙ名
	 */
	public void init( final String qrData,final String saveFile ) {
//		init( qrData,saveFile,DEF_VERSION,EncMode.DEF,ErrCrct.DEF,IMAGE_TYPE,PIXEL );			// 5.7.1.1 (2013/12/13)
//		init( qrData,saveFile,DEF_VERSION,EncMode.DEF,ErrCrct.DEF,IMAGE_TYPE,PIXEL,txtEnc );	// 7.2.3.0 (2020/04/10)
		init( qrData,saveFile,DEF_VERSION,ErrCrct.DEF,IMAGE_TYPE,PIXEL,txtEnc );				// 8.4.1.0 (2023/02/10)
	}

	/**
	 * 初期化ﾒｿｯﾄﾞ
	 *
	 * ｴﾗｰ訂正ﾚﾍﾞﾙ:M , ﾏｰｼﾞﾝ:4(ｾﾙ分) , 塗りつぶしﾋﾟｸｾﾙ:3
	 * ｲﾒｰｼﾞのﾀｲﾌﾟ:PNG に初期化されます。
	 *
	 * @og.rev 7.2.3.0 (2020/04/10) byteﾓｰﾄﾞ時のﾃｷｽﾄ文字ｴﾝｺｰﾄﾞ。
	 * @og.rev 8.4.1.0 (2023/02/10) QRｺｰﾄﾞを swetake から ZXing への置換(encodeMode廃止)
	 *
	 * @param	qrData		ｴﾝｺｰﾄﾞする文字列(120Byte 以内)
	 * @param	saveFile	出力ﾌｧｲﾙ名
	 * @param	version		ﾊﾞｰｼﾞｮﾝ (1から40の整数。0を設定すると自動設定になります。)
	 * <del>@param	encMd		ｴﾝｺｰﾄﾞﾓｰﾄﾞ ('N':数字ﾓｰﾄﾞ 'A':英数字ﾓｰﾄﾞ 'B':8bit byteﾓｰﾄﾞ)</del>
	 */
//	public void init( final String qrData,final String saveFile,final int version,final EncMode encMd ) {
////		init( qrData,saveFile,version,encMd,ErrCrct.DEF,IMAGE_TYPE,PIXEL );
//		init( qrData,saveFile,version,encMd,ErrCrct.DEF,IMAGE_TYPE,PIXEL,txtEnc );		// 7.2.3.0 (2020/04/10)
//	}
	// 8.4.1.0 (2023/02/10) Modify
	public void init( final String qrData,final String saveFile,final int version ) {
		init( qrData,saveFile,version,ErrCrct.DEF,IMAGE_TYPE,PIXEL,txtEnc );
	}

	/**
	 * 初期化ﾒｿｯﾄﾞ。
	 *
	 * @og.rev 7.2.3.0 (2020/04/10) textEncode byteﾓｰﾄﾞ時のﾃｷｽﾄ文字ｴﾝｺｰﾄﾞ追加
	 * @og.rev 8.4.1.0 (2023/02/10) QRｺｰﾄﾞを swetake から ZXing への置換(encodeMode廃止)
	 *
	 * @param	qrData		ｴﾝｺｰﾄﾞする文字列(120Byte 以内)
	 * @param	saveFile	出力ﾌｧｲﾙ名
	 * @param	version		ﾊﾞｰｼﾞｮﾝ (1から40の整数。0を設定すると自動設定になります。)
	 * <del>@param	encMd		ｴﾝｺｰﾄﾞﾓｰﾄﾞ('N':数字ﾓｰﾄﾞ 'A':英数字ﾓｰﾄﾞ 'B':8bit byteﾓｰﾄﾞ)</del>
	 * @param	errCo		ｴﾗｰ訂正ﾚﾍﾞﾙ ('L','M','Q','H')
	 * @param	imgType		ｲﾒｰｼﾞﾌｧｲﾙ形式(PNG/JPEG)
	 * @param	pixel		1ｾﾙ辺りの塗りつぶしﾋﾟｸｾﾙ
	 * @param	txtEnc		ﾃｷｽﾄ文字ｴﾝｺｰﾄﾞ
	 */
//	public void init( final String qrData,final String saveFile,final int version,final EncMode encMd,
//						final ErrCrct errCo ,final String imgType,final int pixel ) {
	public void init( final String qrData,final String saveFile,final int version,							// 8.4.1.0 (2023/02/10)
						final ErrCrct errCo ,final String imgType,final int pixel,final String txtEnc ) {	// 7.2.3.0 (2020/04/10)

		this.qrData		= qrData;
		this.saveFile	= saveFile;
		this.imgType	= imgType;
		this.errCo		= errCo;
//		this.encMd		= encMd;					// 8.4.1.0 (2023/02/10) Delete
		this.version	= version;
//		this.pixel		= pixel;					// 8.4.1.0 (2023/02/10) Delete
		this.txtEnc		= txtEnc;					// 7.2.3.0 (2020/04/10)

		imageSize = ( MARGIN*2 + 17 + version*4 ) * pixel;
	}

	// 8.4.1.0 (2023/02/10) Delete
//	/**
//	 * 描画処理を行います。
//	 *
//	 * @og.rev 6.4.2.0 (2016/01/29) fukurou.util.StringUtil → fukurou.system.HybsConst に変更
//	 * @og.rev 7.2.3.0 (2020/04/10) textEncode byteﾓｰﾄﾞ時のﾃｷｽﾄ文字ｴﾝｺｰﾄﾞ追加
//	 * @og.rev 8.4.1.0 (2023/02/10) QRｺｰﾄﾞを swetake から ZXing への置換(encodeMode廃止)
//	 *
//	 * @param	gpx	Graphicsｵﾌﾞｼﾞｪｸﾄ
//	 */
//	@Override
//	public void paint( final Graphics gpx ) {
//		final Qrcode qrc =new Qrcode();
//		qrc.setQrcodeErrorCorrect(errCo.getCh());
//		qrc.setQrcodeEncodeMode(encMd.getCh());
//		qrc.setQrcodeVersion(version);
//
//		final Charset txtEncode = txtEnc == null || txtEnc.isEmpty()			// 7.2.3.0 (2020/04/10)
//									? HybsConst.DEFAULT_CHARSET					// 6.4.2.0 (2016/01/29)
//									: "UTF-8".equals( txtEnc )
//										? StandardCharsets.UTF_8
//										: Charset.forName( txtEnc ) ;
//
//	//	final byte[] dt =qrData.getBytes( HybsConst.DEFAULT_CHARSET );			// 6.4.2.0 (2016/01/29)
//		final byte[] dt =qrData.getBytes( txtEncode );							// 7.2.3.0 (2020/04/10)
//		final boolean[][] sfg = qrc.calQrcode( dt );
//
//		final int size = sfg.length;
//		final int mgn  = MARGIN*pixel ;
//		for( int i=0; i<size; i++ ) {
//			for( int j=0; j<size; j++ ) {
//				if( sfg[j][i] ) {
//					gpx.fillRect( mgn+j*pixel,mgn+i*pixel,pixel,pixel );
//				}
//			}
//		}
//	}

	/**
	 * 描画処理を行います。
	 *
	 * @og.rev 8.4.1.0 (2023/02/10) QRｺｰﾄﾞを swetake から ZXing への置換(encodeMode廃止)
	 */
	public void saveImage() {
//		// 出力用ｲﾒｰｼﾞの生成
//		final BufferedImage image = new BufferedImage(imageSize, imageSize, BufferedImage.TYPE_INT_BGR );
//
//		// ｲﾒｰｼﾞからｸﾞﾗﾌｨｯｸｺﾝﾃｷｽﾄを取得
//		final Graphics grph = image.getGraphics();
//		grph.setColor( java.awt.Color.WHITE );
//		grph.fillRect( 0,0,imageSize, imageSize );
//		grph.setColor( java.awt.Color.BLACK );
//
//		// JEditorPane をｲﾒｰｼﾞに書き込む
//		// paintComponent は proteced なので使用できない
//		paint( grph );
//
//		// 使い終わったｸﾞﾗﾌｨｯｸｺﾝﾃｷｽﾄを開放
//		grph.dispose();

		// 8.4.1.0 (2023/02/10) Modify
		try {
			BufferedImage image;
			if( qrData == null || qrData.isEmpty() ){
				image = new BufferedImage(imageSize, imageSize, BufferedImage.TYPE_INT_BGR );
			}
			else {
				final String txtEncode = txtEnc == null || txtEnc.isEmpty()
										? HybsConst.DEFAULT_CHARSET.displayName()
										: txtEnc;

				final Map<EncodeHintType, Object> hints = new HashMap<>();
				hints.put(EncodeHintType.QR_VERSION, version);					// ﾊﾞｰｼﾞｮﾝ
				hints.put(EncodeHintType.ERROR_CORRECTION, errCo.getCh());		// ｴﾗｰ訂正ﾚﾍﾞﾙ(L, M, Q, H)
				hints.put(EncodeHintType.CHARACTER_SET, txtEncode);				// 文字ｴﾝｺｰﾄﾞ

				final QRCodeWriter writer = new QRCodeWriter();
				final BitMatrix bitMatrix = writer.encode( qrData, BarcodeFormat.QR_CODE, imageSize, imageSize, hints );
				image = MatrixToImageWriter.toBufferedImage(bitMatrix);
			}

			// ｲﾒｰｼﾞの出力 Image I/O を使用
			ImageIO.write( image, imgType, new File( saveFile ) );
		} catch ( final WriterException ex) {
			final String errMsg = "QRコードの生成に失敗しました。"
					+ "Data=[" + qrData + "]" ;
			throw new OgRuntimeException( errMsg,ex );
		} catch( final IOException ex ) {
			final String errMsg = "イメージファイルの出力に失敗しました。"
					+ "File=[" + saveFile + "]" ;
			throw new OgRuntimeException( errMsg,ex );
		}
	}

	// 8.4.1.0 (2023/02/10) Delete
//	/**
//	 * ﾒｲﾝ処理です。
//	 * Usage: java org.opengion.fukurou.util.QrcodeImage Encode [SaevFile]
//	 *
//	 * @og.rev 8.4.1.0 (2023/02/10) QRｺｰﾄﾞを swetake から ZXing への置換(encodeMode廃止)
//	 *
//	 * @param	args	引数文字列配列
//	 */
//	public static void main( final String[] args ) {
//		if( args.length == 0 ) {
//			LogWriter.log( "Usage: java org.opengion.fukurou.util.QrcodeImage Encode [SaevFile]" );
//			return ;
//		}
//
//		final String qrcode = args[0];
//		final String file   = args.length > 1 ? args[1] : "img.png";
//
//		final QrcodeImage qrImage = new QrcodeImage();
//		qrImage.init( qrcode,file );
//		qrImage.saveImage();
//	}

	// 8.4.1.0 (2023/02/10) Delete
//	/**
//	 * 内部ﾃﾞｰﾀを標準出力へ出力します。
//	 *
//	 * @og.rev 7.2.1.0 (2020/03/13) QrcodeImage 見直し。
//	 * @og.rev 8.4.1.0 (2023/02/10) QRｺｰﾄﾞを swetake から ZXing への置換(encodeMode廃止)
//	 */
//	public static void printQcData() {
////		final char[] strJ = new char[] { 'H','M' };
//		final char[] strJ = new char[] { 'L','M','Q','H' };							// 7.2.1.0 (2020/03/13)
//		final char[] strK = new char[] { 'N','A','B' };
//
//		for( int i=0; i<QC_DATA.length; i++ ) {
//			System.out.print( "version=[" + (i+1) + "] " );
//			for( int j=0; j<QC_DATA[i].length; j++ ) {
//				final char errCo = strJ[j];
//				for( int k=0; k<QC_DATA[i][j].length; k++ ) {
//					System.out.print( errCo + strK[k] + "=[" + QC_DATA[i][j][k] + "] " );
//				}
//			}
//			System.out.println();
//		}
	}

	// 8.4.1.0 (2023/02/10) Delete
//	/**
//	 * ﾊﾞｰｼﾞｮﾝ情報を取得します。
//	 *
//	 * @og.rev 8.4.1.0 (2023/02/10) QRｺｰﾄﾞを swetake から ZXing への置換(encodeMode廃止)
//	 *
//	 * @param	errCo	ｴﾗｰ訂正ﾚﾍﾞﾙ ('L','M','Q','H')
//	 * @param	encMd	ｴﾝｺｰﾄﾞﾓｰﾄﾞ ('N':数字ﾓｰﾄﾞ 'A':英数字ﾓｰﾄﾞ 'B':8bit byteﾓｰﾄﾞ)
//	 * @param	len		対象範囲
//	 * @return	ﾊﾞｰｼﾞｮﾝ情報
//	 */
//	public static int getVersion( final ErrCrct errCo, final EncMode encMd, final int len ) {
//		final int errCoInt = errCo.getNo() ;
//		final int encMdInt = encMd.getNo() ;
//
//		int rtn = -1;
//		for( int i=0; i<QC_DATA.length; i++ ) {
//			if( QC_DATA[i][errCoInt][encMdInt] >= len ) {
//				rtn = i;
//				break;
//			}
//		}
//
//		if( rtn < 0 ) {
//			final String errMsg = "データ量が対象範囲を超えています。エラーレベルや、モードを調整してください。"
//						+ "ErrCo:" + errCo + " EncMd:" + encMd + " len=[" + len + "]"
//						+ " MaxLen=[" + QC_DATA[QC_DATA.length-1][errCoInt][encMdInt] + "]" ;
//			throw new OgRuntimeException( errMsg );
//		}
//
//		return rtn + 1 ;
//	}

	// 8.4.1.0 (2023/02/10) Delete
//	/**
//	 * 最大ｻｲｽﾞを取得します。
//	 *
//	 * @og.rev 8.4.1.0 (2023/02/10) QRｺｰﾄﾞを swetake から ZXing への置換(encodeMode廃止)
//	 *
//	 * @param	version	ﾊﾞｰｼﾞｮﾝ情報
//	 * @param	errCo	ｴﾗｰ訂正ﾚﾍﾞﾙ ('L','M','Q','H')
//	 * @param	encMd	ｴﾝｺｰﾄﾞﾓｰﾄﾞ ('N':数字ﾓｰﾄﾞ 'A':英数字ﾓｰﾄﾞ 'B':8bit byteﾓｰﾄﾞ)
//	 * @return	最大ｻｲｽﾞ
//	 */
//	public static int getMaxSize( final int version, final ErrCrct errCo, final EncMode encMd ) {
//		final int errCoInt = errCo.getNo() ;
//		final int encMdInt = encMd.getNo() ;
//
//		return QC_DATA[version][errCoInt][encMdInt] ;
//	}
//}
