/**
 * <pre>
 * はやぶさ共通のXML関連ｸﾗｽを提供します。
 *
 * このﾊﾟｯｹｰｼﾞは、単独ｸﾗｽとして、他のopenGionﾊﾟｯｹｰｼﾞと切り離されています。
 *
 * ここで扱う XMLﾌｧｲﾙは、拡張ｵﾗｸﾙ XDK形式のXMLﾌｧｲﾙを処理するｸﾗｽ群です。
 * ｵﾗｸﾙXDK形式のXMLとは、下記のような ROWSET をﾄｯﾌﾟとする ROW の
 * 集まりで1ﾚｺｰﾄﾞを表し、各ROWには、ｶﾗﾑ名をｷｰとするXMLになっています。
 *
 *   &lt;ROWSET&gt;
 *       &lt;ROW num="1"&gt;
 *           &lt;ｶﾗﾑ1&gt;値1&lt;/ｶﾗﾑ1&gt;
 *             ･･･
 *           &lt;ｶﾗﾑn&gt;値n&lt;/ｶﾗﾑn&gt;
 *       &lt;/ROW&gt;
 *        ･･･
 *       &lt;ROW num="n"&gt;
 *          ･･･
 *       &lt;/ROW&gt;
 *   &lt;ROWSET&gt;
 *
 * この形式であれば、XDK(Oracle XML Developer's Kit)を利用すれば、非常に簡単に
 * ﾃﾞｰﾀﾍﾞｰｽとXMLﾌｧｲﾙとの交換が可能です。
 * <a href="https://docs.oracle.com/cd/F19136_01/adxdk/introduction-to-XDK.html" target="_blank" >
 * XDK(Oracle XML Developer's Kit)</a>
 * 
 * 拡張XDK形式とは、ROW 以外に、SQL処理用ﾀｸﾞ(EXEC_SQL)を持つ XML ﾌｧｲﾙです。
 * これは、ｵﾗｸﾙXDKで処理する場合、無視されますので、同様に扱うことが出来ます。
 * この、EXEC_SQL は、それそれの XMLﾃﾞｰﾀをﾃﾞｰﾀﾍﾞｰｽに登録する際に、
 * SQL処理を自動的に実行する為の、SQL文を記載できます。
 * このSQL文は、EXEC_SQLﾀｸﾞを処理する都度にｲﾍﾞﾝﾄ処理される為、その配置順は重要です。
 * このﾀｸﾞそのものは、複数記述することが出来ますが、BODY部には、1つのSQL文のみ記述します。
 *
 *   &lt;ROWSET&gt;
 *       &lt;EXEC_SQL&gt;                    最初に記載して、初期処理(ﾃﾞｰﾀｸﾘｱ等)を実行させる。
 *           delete from GEXX where YYYYY
 *       &lt;/EXEC_SQL&gt;
 *       &lt;ROW num="1"&gt;
 *           &lt;ｶﾗﾑ1&gt;値1&lt;/ｶﾗﾑ1&gt;
 *             ･･･
 *           &lt;ｶﾗﾑn&gt;値n&lt;/ｶﾗﾑn&gt;
 *       &lt;/ROW&gt;
 *        ･･･
 *       &lt;ROW num="n"&gt;
 *          ･･･
 *       &lt;/ROW&gt;
 *       &lt;EXEC_SQL&gt;                    最後に記載して、項目の設定(整合性登録)を行う。
 *           update GEXX set AA='XX' , BB='XX' where YYYYY
 *       &lt;/EXEC_SQL&gt;
 *   &lt;ROWSET&gt;
 *
 * この、SQL文を登録前に実行すれば、既存ﾃﾞｰﾀを削除してから、新しいﾃﾞｰﾀを
 * 登録するような使い方が出来ます。
 * このﾌｧｲﾙの処理を、ﾀｲﾑｽﾀﾝﾌﾟ等で監視すれば、変更時のみ実行する
 * ﾃﾞｰﾀ登録のﾌｧｲﾙを作成することが可能です。
 * また、最後に記載することで、登録後のﾃﾞｰﾀ整合性を処理するSQL文を登録する
 * 事も可能です。
 *
 *    org.opengion.fukurou.xml (classes)
 *       → org.opengion.fukurou.system                        classes
 *       → org.opengion.fukurou.util                          classes
 * </pre>
 */
package org.opengion.fukurou.xml;
