/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.resource;

import java.util.Calendar;

/**
 * 事業所(CDJGS) 毎の休日カレンダデータオブジェクトです。
 *
 * カレンダデータは、指定の事業所に関して、すべての休日情報を持っています。
 * 元のカレンダテーブル(GE13)の １日(DY1)～３１日(DY31)までの日付け欄に対して、
 * 休日日付けの 年月日 に対する、休日かどうかを判断できるだけの情報を保持します。
 * 具体的には、年月日に対する Set を持つことになります。
 * このクラスでは、全ての日を休日以外として扱います。
 *
 * @og.rev 3.6.0.0 (2004/09/17) 新規作成
 * @og.group リソース管理
 *
 * @version  4.0
 * @author   Hiroki Nakamura
 * @since    JDK5.0,
 */
public final class CalendarPGData_NONHOLIDAY extends AbstractCalendarPGData {

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	public CalendarPGData_NONHOLIDAY() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 * 指定の日付けが、休日かどうかを返します。
	 * ここでは、すべて休日以外として返します。
	 *
	 * @param	day	指定の日付け
	 *
	 * @return	休日：true それ以外：false
	 *
	 */
	@Override	// CalendarData
	public boolean isHoliday( final Calendar day ) {
		return false;
	}
}
