<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2010"
	title	= "テーブル"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "TABLE_NAME,SYSTEM_ID,TBLSYU,NAME_JA"
/>

<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select TBLSYU,TABLE_NAME,NAME_JA,JKENSU,SKENSU,TABLESPACE_NAME,COMMENTS,
				INITIAL_EXTENT,SYSTEM_ID,FGJ,UNIQ
		from GF02
	<og:where>
		<og:and value = "FGJ				in   ('0','1')"			/>
		<og:and value = "SYSTEM_ID			=  '{@SYSTEM_ID}'"		/>
		<og:and value = "TBLSYU				=    '{@TBLSYU}'"		/>
		<og:and value = "TABLE_NAME			like '{@TABLE_NAME}'"	/>
		<og:and value = "TABLESPACE_NAME	like '{@TABLESPACE_NAME}'" />
		<og:and value = "NAME_JA			like '{@NAME_JA}'"		/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,TABLE_NAME,TBLSYU" />
</og:query>

<og:viewLink command="{@command}">
	<og:link column="TABLESPACE_NAME" gamenId="GF2000" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,TBLSYU,TABLESPACE_NAME" vals="NEW,[SYSTEM_ID],[TBLSYU],[TABLESPACE_NAME]" />
	<og:link column="TABLE_NAME" gamenId="GF2020" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,TABLE_NAME,TBLSYU" vals="NEW,[SYSTEM_ID],[TABLE_NAME],[TBLSYU]" />
	<og:link column="JKENSU" gamenId="GF2020" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,TABLE_NAME,TBLSYU" vals="NEW,[SYSTEM_ID],[TABLE_NAME],[TBLSYU]"
	/>
</og:viewLink>

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->
<og:columnEditor column="TABLESPACE_NAME" editor="DBMENU" >
	select TABLESPACE_NAME,TABLESPACE_NAME
	from GF01
	where FGJ in ('0','1')
	and SYSTEM_ID = '{@SYSTEM_ID}'
	group by TABLESPACE_NAME
	order by 1
</og:columnEditor>

<form method="POST" action="forward.jsp" target="RESULT">
	<og:writeCheck>
		<og:submit  action="COPY"    noWritable="null" />
		<og:submit  action="MODIFY"  noWritable="TBLSYU,TABLE_NAME"/>
		<og:submit  action="DELETE"  columnWritable="null" />
		　　　<og:submit  action="DELETE" lbl="DeleteAll" columnWritable="null" keys="ALL_DEL" vals="true" />

		<og:fieldset lbl="INSERT_GF02">
			<og:column  name="DBID"        codeKeyVal="{@DBID_INFO}" td="no" />
			<og:column  name="TABLE_NAME"  size="5" td="no" />
			<og:column  name="SYSTEM_ID"   size="5" td="no" />
			<og:column  name="TBLSYU"    defaultVal="T" addNoValue="false" td="no" />
			<og:column  name="USE_RESOURCE" addNoValue="false" defaultVal="true" td="no" />
			<og:submit  value="insertGF02" lbl="INSERT" command="INSERT" />
			<og:submit  value="modifyGF02" lbl="JKENSU" command="MODIFY" />
		</og:fieldset>
		<br />
	</og:writeCheck>
	<og:view
		viewFormType  = "HTMLTable"
		command       = "{@command}"
		noDisplay     = "UNIQ,FGJ"
		checked       = "{@checked}"
		startNo       = "{@startNo}"
		pageSize      = "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
