/********************************************************************************************/
/* VIEWのカラムマニュアル表示 5.5.4.0 (2012/07/02) 											*/
/*																							*/
/* VIEWテーブルの情報より、カラムのマニュアルを表示します。									*/
/* 利用変数はクロージャーで隠蔽します。														*/
/* img#viewHelpIconがヘルプのアイコンとなります												*/
/*																							*/
/* Modified: 2012/07/18 Field登録／表示の場合も項目説明が作成されるように対応				*/
/*				Scroll対応																	*/
/* Modified: 6.2.5.0 (2015/06/05) resultScript.js から分離。(query.jspでも使う)				*/
/* Modified: 6.2.6.0 (2015/06/19) 画面の概要説明も表示できるように修正						*/
/* Modified: 8.4.2.2 (2023/03/17) 概要説明を折り替えし表示できるようにする					*/
/* @og.rev 8.4.3.0 (2023/03/31) .bind() , .unbind() は、.on()と.off()に書き換えます。		*/
/* 2023/04/05 POP化対応																		*/
/* Revision: $Id$																			*/
/********************************************************************************************/
/*! @og.rev 8.4.3.0 2023/04/05 POP化対応(autoManual.html) */
var showViewManual = (function(){
	// 画面上の座標の取得
	// Modified: 2012/07/18 スクロール対応
	function getElementScreenPosition( inObj )
	{
		var html = document.documentElement;
		var rect = inObj.getBoundingClientRect();
		var scrollLeft = document.documentElement.scrollLeft || document.body.scrollLeft;
		var left =  scrollLeft > 0 ? rect.left - html.clientLeft + scrollLeft : rect.left - html.clientLeft ;
		var top  = rect.top  - html.clientTop;

		left = left < 0 ? 0 : left;
		top = top < 0 ? 0 :top;

		return { left:left, top:top };
	}
	// ヘッダーかどうかの判定
	function isHeader( inObj ){
		if( inObj.parentNode.tagName == "TH" ){
			return true;
		}
		else if( inObj.parentNode.tagName == "BODY" ){
			return false;
		}
		else{
			return isHeader( inObj.parentNode );
		}
	}
	// ラベル（<td class="label">）の判定 2012/07/18 mod
	function isLabel( inObj ){
		if( inObj.parentNode.tagName == "TD" && inObj.parentNode.className == "label" ){
			return true;
		}
		else if( inObj.parentNode.tagName == "BODY" ){
			return false;
		}
		else{
			return isLabel( inObj.parentNode );
		}
	}
	// 6.2.6.0 (2015/06/19) 画面の概要説明の判定。id="design-header-title" があれば画面概要と判定
	function isGuiDesc( inObj ){
		if( inObj != null && inObj.parentNode != null ) {
			if( inObj.parentNode.id == "design-header-title" ){
				return true;
			}
			else{
				return isGuiDesc( inObj.parentNode );
			}
		}
		else {
			return false;
		}
	}
	// マニュアルの表示
	// クロージャーとして利用
	// _mode:1なら単純にヘッダがある(1)かない(0)かだけ返す。それ以外は通常実行
	return function(_mode ){
		// 概要説明の各タグを取得
		var objSpan   = $("span");
		// 項目数
		var countSpan = objSpan.length;
		var spanTitle = "";
		var spanKey   = "";
		// 概要説明を格納する配列 2023/04/05 ADD
		var arrDesc = [];
		// アイコン表示する／しないの判定フラグ
		var fgShow  = 0;
		// 項目の概要説明がない時、または概要説明と項目名称が同内容となっている時は非表示する
		for( i = 0 ;i < countSpan ;i++ ){
			// Field型の表示にも、作成するように対応 2012/07/18 mod
			// 6.2.6.0 (2015/06/19) 画面の概要説明も表示できるように修正。
			if( !isHeader( objSpan[i] ) && !isLabel( objSpan[i] ) && !isGuiDesc( objSpan[i] )) continue;
			spanTitle = objSpan[i].title;
			spanKey   = $(objSpan[i]).text();
			if( spanTitle.length > 0 && spanTitle != spanKey ){
				// 判定モードの場合
				if( _mode == '1'){
					fgShow = 1;
					break;
				}
				// 通常モードのみデータ作成
				else{
					// 2023/04/05 ADD
					var objBuf = {
						 key   : spanKey
						,title : spanTitle
					};
					// 配列に追加
					arrDesc.push( objBuf );
				}
			}
		}
		// 判定モードの場合
		if( _mode == '1'){
			return fgShow;
		}
		// WEBストレージに保存
		localStorage.setItem( 'manualInfo', JSON.stringify( arrDesc ) );
		localStorage.setItem( 'pageTitle' , document.title );
		// 概要説明の表示ページを呼び出す(resizable=yes,location=no はChromeやEdgeでは効かない)
		ogOpen('../common/autoManual.html?v=8430',null ,null,'width=800px,height=400px,top=200,left=200');
	};
})();

// helpで表示する内容がなければviewHelpIconを消す。
$(function(){
	if(showViewManual('1') == '0'){
		$('img#viewHelpIcon').css('display','none');
	}
});
