/*!
 * common/jquery/jquery.blockUI.js を使用した検索中表示
 *
 * submitボタンがクリックされtから、0.5秒 に検索中表示を行います。
 * query.jsp に include して使います。
 * result.jsp では、$(document).ready を使用して、検索中レイヤーの破棄を行います。
 *
 * openGion 5.7.7.1 (2014/06/13)
 * openGion 7.3.2.0 (2021/03/19) frameの名前を親画面に設定しておく。
 */

jQuery(function ($) {
	// 7.3.2.0 (2021/03/19) frameの名前を親画面に設定しておく。
	if(parent.document.body){
		parent.document.body.unblockname = window.name;
	}

	// 検索中レイヤーの表示
	$.fnblockUI = function fnblockUI(msg) {
		$.blockUI(
			{
				message: msg ,
//				message: '検索中です・・・',
//				message: '<img src="../image/dogrun.gif">',
				css: {
					border : 'none',
					padding: '10px',
					backgroundColor: '#333',
					opacity: 0.7,
					color  : '#fff'
				},
				overlayCSS: {
					backgroundColor: '#000',
					opacity: 0.0
				},
				onOverlayClick: $.unblockUI,
//				fadeIn : 3000
				fadeIn : 0
			}
		);
	};

	// 検索中レイヤーの破棄
	// タイマーのOFF と、blockUI の表示終了
	$.fnUnblockUI = function fnUnblockUI() {
		// 6.2.4.0 (2015/05/15) TimeoutID の未定義エラー対策
		if( typeof TimeoutID != "undefined" ) {
			clearTimeout(TimeoutID);
			$.unblockUI();
		}
	};

	// ボタンをクリックした場合
//	$(":submit").click(
	// 8.4.3.0 (2023/03/31) jQuery.fn.click() event shorthand is deprecated
//	$("#queryButtonSubmit").click(
	$("#queryButtonSubmit").on("click",
		function() {
			// 6.4.8.0 (2016/06/24) メッセージをリソースから取得するための対応。alt属性に書き込みます。
			var msg = $("#queryButtonSubmit").attr('alt') ;
			// ボタンが押されてから、0.5秒待ちます。
//			TimeoutID=setTimeout("$.fnblockUI('検索中です・・・')",500);
			TimeoutID=setTimeout(function(){$.fnblockUI( msg )},500);
		}
	);
});
