(function ($) {

/*
 * ajaxHybsForm.js 0.01
 * openGion HYBS utilities
 * Date: 2009-06-29 rev 1
 *
 * 8.4.3.0 (2023/03/31) .bind() , .unbind() は、.on()と.off()に書き換えます。
 */

$.fn.ajaxHybsForm = function(options) {
	return this.ajaxForm(options)
			// 8.4.3.0 (2023/03/31) .bind() , .unbind() は、.on()と.off()に書き換えます。
//			.unbind('submit.form-plugin-hybs')
//			.bind('submit.form-plugin-hybs',function() {
			.off('submit.form-plugin-hybs')
			.on('submit.form-plugin-hybs',function() {
					var oClk , sCmd , oCmd ;

					oClk = this.clk;
					sCmd = "";
					if( oClk && oClk.tagName && 'INPUT' == oClk.tagName && 'command' == oClk.name) {
						oCmd = this.elements['hX_' + oClk.value + 'CMD'];
						if(oCmd) sCmd = (oCmd.length) ? oCmd[0].value : oCmd.value;
					}
					// 指定のコマンドの場合は、ajaxSubmitで処理
					if(sCmd && $.inArray(sCmd, options.cmds) >= 0) {
						// 2009/02/09 sHybsCmdVal廃止、sHybsCmd中身に連想配列をセット
						// 処理中の場合、簡単な警告を出す
						if($(this).data($.hybs.defaults.sHybsCmd)) { alert( "Don't push twice." ); }
						else {
							//$(this).data($.hybs.defaults.sHybsCmd, sCmd)
							//	.data($.hybs.defaults.sHybsCmdVal, oClk.value).ajaxSubmit(options);
							$(this).data($.hybs.defaults.sHybsCmd, {cmd:sCmd, obj:oClk})
								.ajaxSubmit(options);
						}
						return false;
					}
					// 指定のコマンド以外は、trueで返して通常の処理を継続
					else {
						$(this).removeData($.hybs.defaults.sHybsCmd);
						return true;
					}
				})
//				.unbind('submit.form-plugin');
				.off('submit.form-plugin');				// 8.4.3.0 (2023/03/31)
};

})(jQuery);