/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.ShortByReference;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.ng.AbstractFbBlob;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.jna.JnaDatabase;
import org.firebirdsql.gds.ng.jna.JnaTransaction;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.jna.fbclient.ISC_STATUS;

public class JnaBlob
extends AbstractFbBlob
implements FbBlob,
DatabaseListener {
    private final LongByReference blobId;
    private final boolean outputBlob;
    private final IntByReference jnaHandle = new IntByReference(0);
    private final ISC_STATUS[] statusVector = new ISC_STATUS[20];
    private final FbClientLibrary clientLibrary;
    private ByteBuffer byteBuffer;

    public JnaBlob(JnaDatabase database, JnaTransaction transaction, BlobParameterBuffer blobParameterBuffer) {
        this(database, transaction, blobParameterBuffer, 0L);
    }

    public JnaBlob(JnaDatabase database, JnaTransaction transaction, BlobParameterBuffer blobParameterBuffer, long blobId) {
        super(database, transaction, blobParameterBuffer);
        this.blobId = new LongByReference(blobId);
        this.outputBlob = blobId == 0L;
        this.clientLibrary = database.getClientLibrary();
    }

    @Override
    public JnaDatabase getDatabase() {
        return (JnaDatabase)super.getDatabase();
    }

    @Override
    public JnaTransaction getTransaction() {
        return (JnaTransaction)super.getTransaction();
    }

    @Override
    public int getHandle() {
        return this.jnaHandle.getValue();
    }

    public final IntByReference getJnaHandle() {
        return this.jnaHandle;
    }

    @Override
    public final long getBlobId() {
        return this.blobId.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws SQLException {
        try {
            if (this.isOutput() && this.getBlobId() != 0L) {
                throw new FbExceptionBuilder().nonTransientException(335544368).toSQLException();
            }
            BlobParameterBuffer blobParameterBuffer = this.getBlobParameterBuffer();
            byte[] bpb = blobParameterBuffer != null ? blobParameterBuffer.toBytesWithType() : new byte[]{};
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.checkDatabaseAttached();
                this.checkTransactionActive();
                this.checkBlobClosed();
                JnaDatabase db = this.getDatabase();
                if (this.isOutput()) {
                    this.clientLibrary.isc_create_blob2(this.statusVector, db.getJnaHandle(), this.getTransaction().getJnaHandle(), this.getJnaHandle(), this.blobId, (short)bpb.length, bpb);
                } else {
                    this.clientLibrary.isc_open_blob2(this.statusVector, db.getJnaHandle(), this.getTransaction().getJnaHandle(), this.getJnaHandle(), this.blobId, (short)bpb.length, bpb);
                }
                this.processStatusVector();
                this.setOpen(true);
                this.resetEof();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public final boolean isOutput() {
        return this.outputBlob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getSegment(int sizeRequested) throws SQLException {
        try {
            ByteBuffer responseBuffer;
            if (sizeRequested <= 0) {
                throw new FbExceptionBuilder().exception(337248257).messageParameter(sizeRequested).toSQLException();
            }
            sizeRequested = Math.min(sizeRequested, this.getMaximumSegmentSize());
            ShortByReference actualLength = new ShortByReference();
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.checkDatabaseAttached();
                this.checkTransactionActive();
                this.checkBlobOpen();
                responseBuffer = this.getByteBuffer(sizeRequested);
                this.clientLibrary.isc_get_segment(this.statusVector, this.getJnaHandle(), actualLength, (short)sizeRequested, responseBuffer);
                int status = this.statusVector[1].intValue();
                if (status != 0 && status != 335544366) {
                    if (status == 335544367) {
                        this.setEof();
                    } else {
                        this.processStatusVector();
                    }
                }
            }
            int actualLengthInt = actualLength.getValue() & 0xFFFF;
            byte[] segment = new byte[actualLengthInt];
            responseBuffer.get(segment);
            return segment;
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putSegment(byte[] segment) throws SQLException {
        try {
            if (segment.length == 0) {
                throw new FbExceptionBuilder().exception(337248258).toSQLException();
            }
            if (segment.length > this.getMaximumSegmentSize()) {
                throw new FbExceptionBuilder().exception(337248259).toSQLException();
            }
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.checkDatabaseAttached();
                this.checkTransactionActive();
                this.checkBlobOpen();
                this.clientLibrary.isc_put_segment(this.statusVector, this.getJnaHandle(), (short)segment.length, segment);
                this.processStatusVector();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(int offset, FbBlob.SeekMode seekMode) throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.checkDatabaseAttached();
                this.checkTransactionActive();
                IntByReference result = new IntByReference();
                this.clientLibrary.isc_seek_blob(this.statusVector, this.getJnaHandle(), (short)seekMode.getSeekModeId(), offset, result);
                this.processStatusVector();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBlobInfo(byte[] requestItems, int bufferLength) throws SQLException {
        try {
            ByteBuffer responseBuffer;
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                responseBuffer = this.getByteBuffer(bufferLength);
                this.checkDatabaseAttached();
                this.clientLibrary.isc_blob_info(this.statusVector, this.getJnaHandle(), (short)requestItems.length, requestItems, (short)bufferLength, responseBuffer);
                this.processStatusVector();
            }
            byte[] responseArr = new byte[bufferLength];
            responseBuffer.get(responseArr);
            return responseArr;
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    protected void closeImpl() throws SQLException {
        try {
            this.clientLibrary.isc_close_blob(this.statusVector, this.getJnaHandle());
            this.processStatusVector();
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    protected void cancelImpl() throws SQLException {
        try {
            this.clientLibrary.isc_cancel_blob(this.statusVector, this.getJnaHandle());
            this.processStatusVector();
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    protected void releaseResources() {
        this.byteBuffer = null;
    }

    private void processStatusVector() throws SQLException {
        this.getDatabase().processStatusVector(this.statusVector, null);
    }

    private ByteBuffer getByteBuffer(int requiredSize) {
        if (this.byteBuffer == null || this.byteBuffer.capacity() < requiredSize) {
            this.byteBuffer = ByteBuffer.allocateDirect(requiredSize);
        } else {
            this.byteBuffer.clear();
        }
        return this.byteBuffer;
    }
}

