/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.BitsPerComponentBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ChannelDefinitionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ColorSpecificationBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ComponentMappingBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.DataEntryURLBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.FileTypeBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.HeaderBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.PaletteBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ResolutionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.SignatureBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.UUIDBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.UUIDListBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.XMLBox;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.imageio.IIOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Box {
    private static Hashtable names = new Hashtable();
    private static Hashtable boxClasses;
    protected int length;
    protected long extraLength;
    protected int type;
    protected byte[] data;

    public static String getName(int n) {
        String string = (String)names.get(new Integer(n));
        return string == null ? "unknown" : string;
    }

    public static Class getBoxClass(int n) {
        if (n == 1785737832 || n == 1919251232) {
            return null;
        }
        return (Class)boxClasses.get(new Integer(n));
    }

    public static String getTypeByName(String string) {
        Enumeration enumeration = names.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            if (!string.equals(names.get(n))) continue;
            return Box.getTypeString(n);
        }
        return null;
    }

    public static Box createBox(int n, Node node) throws IIOInvalidTreeException {
        Class clazz = (Class)boxClasses.get(new Integer(n));
        try {
            Constructor constructor = clazz.getConstructor(Node.class);
            if (constructor != null) {
                return (Box)constructor.newInstance(node);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            return new Box(node);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            return new Box(node);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return new Box(node);
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            return new Box(node);
        }
        return null;
    }

    public static Object getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        return (node = namedNodeMap.getNamedItem(string)) != null ? node.getNodeValue() : null;
    }

    public static byte[] parseByteArray(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreElements()) {
            byArray[n2++] = new Byte(stringTokenizer.nextToken());
        }
        return byArray;
    }

    protected static int[] parseIntArray(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        int[] nArray = new int[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreElements()) {
            nArray[n2++] = new Integer(stringTokenizer.nextToken());
        }
        return nArray;
    }

    protected static String getStringElementValue(Node node) {
        Object object;
        if (node instanceof IIOMetadataNode && (object = ((IIOMetadataNode)node).getUserObject()) instanceof String) {
            return (String)object;
        }
        return node.getNodeValue();
    }

    protected static byte getByteElementValue(Node node) {
        Object object;
        if (node instanceof IIOMetadataNode && (object = ((IIOMetadataNode)node).getUserObject()) instanceof Byte) {
            return (Byte)object;
        }
        object = node.getNodeValue();
        if (object != null) {
            return new Byte((String)object);
        }
        return 0;
    }

    protected static int getIntElementValue(Node node) {
        Object object;
        if (node instanceof IIOMetadataNode && (object = ((IIOMetadataNode)node).getUserObject()) instanceof Integer) {
            return (Integer)object;
        }
        object = node.getNodeValue();
        if (object != null) {
            return new Integer((String)object);
        }
        return 0;
    }

    protected static short getShortElementValue(Node node) {
        Object object;
        if (node instanceof IIOMetadataNode && (object = ((IIOMetadataNode)node).getUserObject()) instanceof Short) {
            return (Short)object;
        }
        object = node.getNodeValue();
        if (object != null) {
            return new Short((String)object);
        }
        return 0;
    }

    protected static byte[] getByteArrayElementValue(Node node) {
        Object object;
        if (node instanceof IIOMetadataNode && (object = ((IIOMetadataNode)node).getUserObject()) instanceof byte[]) {
            return (byte[])object;
        }
        return Box.parseByteArray(node.getNodeValue());
    }

    protected static int[] getIntArrayElementValue(Node node) {
        Object object;
        if (node instanceof IIOMetadataNode && (object = ((IIOMetadataNode)node).getUserObject()) instanceof int[]) {
            return (int[])object;
        }
        return Box.parseIntArray(node.getNodeValue());
    }

    public static void copyInt(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >> 24);
        byArray[n++] = (byte)(n2 >> 16);
        byArray[n++] = (byte)(n2 >> 8);
        byArray[n++] = (byte)(n2 & 0xFF);
    }

    public static String getTypeString(int n) {
        byte[] byArray = new byte[4];
        for (int i = 3; i >= 0; --i) {
            byArray[i] = (byte)(n & 0xFF);
            n >>>= 8;
        }
        return new String(byArray);
    }

    public static int getTypeInt(String string) {
        byte[] byArray = string.getBytes();
        int n = byArray[0];
        for (int i = 1; i < 4; ++i) {
            n = n << 8 | byArray[i];
        }
        return n;
    }

    public Box(int n, int n2, byte[] byArray) {
        this.type = n2;
        this.setLength(n);
        this.setContent(byArray);
    }

    public Box(int n, int n2, long l, byte[] byArray) {
        this.type = n2;
        this.setLength(n);
        if (n == 1) {
            this.setExtraLength(l);
        }
        this.setContent(byArray);
    }

    public Box(ImageInputStream imageInputStream, int n) throws IOException {
        this.read(imageInputStream, n);
    }

    public Box(Node node) throws IIOInvalidTreeException {
        NodeList nodeList = node.getChildNodes();
        String string = (String)Box.getAttribute(node, "Type");
        this.type = Box.getTypeInt(string);
        if (string == null || names.get(new Integer(this.type)) == null) {
            throw new IIOInvalidTreeException("Type is not defined", node);
        }
        string = (String)Box.getAttribute(node, "Length");
        if (string != null) {
            this.length = new Integer(string);
        }
        if ((string = (String)Box.getAttribute(node, "ExtraLength")) != null) {
            this.extraLength = new Long(string);
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!"Content".equals(node2.getNodeName())) continue;
            if (node2 instanceof IIOMetadataNode) {
                IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)node2;
                try {
                    this.data = (byte[])iIOMetadataNode.getUserObject();
                }
                catch (Exception exception) {}
            } else {
                this.data = Box.getByteArrayElementValue(node2);
            }
            if (this.data != null || (string = node.getNodeValue()) == null) continue;
            this.data = string.getBytes();
        }
    }

    public IIOMetadataNode getNativeNode() {
        String string = Box.getName(this.getType());
        if (string == null) {
            string = "unknown";
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(string);
        this.setDefaultAttributes(iIOMetadataNode);
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Content");
        iIOMetadataNode2.setUserObject(this.data);
        iIOMetadataNode2.setNodeValue(ImageUtil.convertObjectToString(this.data));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getNativeNodeForSimpleBox() {
        try {
            Method method = this.getClass().getMethod("getElementNames", null);
            String[] stringArray = (String[])method.invoke(null, (Object[])null);
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(Box.getName(this.getType()));
            this.setDefaultAttributes(iIOMetadataNode);
            for (int i = 0; i < stringArray.length; ++i) {
                IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode(stringArray[i]);
                method = this.getClass().getMethod("get" + stringArray[i], null);
                Object object = method.invoke((Object)this, (Object[])null);
                iIOMetadataNode2.setUserObject(object);
                iIOMetadataNode2.setNodeValue(ImageUtil.convertObjectToString(object));
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
            return iIOMetadataNode;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(I18N.getString("Box0"));
        }
    }

    protected void setDefaultAttributes(IIOMetadataNode iIOMetadataNode) {
        iIOMetadataNode.setAttribute("Length", Integer.toString(this.length));
        iIOMetadataNode.setAttribute("Type", Box.getTypeString(this.type));
        if (this.length == 1) {
            iIOMetadataNode.setAttribute("ExtraLength", Long.toString(this.extraLength));
        }
    }

    public int getLength() {
        return this.length;
    }

    public int getType() {
        return this.type;
    }

    public long getExtraLength() {
        return this.extraLength;
    }

    public byte[] getContent() {
        if (this.data == null) {
            this.compose();
        }
        return this.data;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public void setExtraLength(long l) {
        if (this.length != 1) {
            throw new IllegalArgumentException(I18N.getString("Box1"));
        }
        this.extraLength = l;
    }

    public void setContent(byte[] byArray) {
        if (byArray != null && (this.length == 1 && this.extraLength - 16L != (long)byArray.length || this.length != 1 && this.length - 8 != byArray.length)) {
            throw new IllegalArgumentException(I18N.getString("Box2"));
        }
        this.data = byArray;
        if (byArray != null) {
            this.parse(byArray);
        }
    }

    public void write(ImageOutputStream imageOutputStream) throws IOException {
        imageOutputStream.writeInt(this.length);
        imageOutputStream.writeInt(this.type);
        if (this.length == 1) {
            imageOutputStream.writeLong(this.extraLength);
            imageOutputStream.write(this.data, 0, (int)this.extraLength);
        } else if (this.data != null) {
            imageOutputStream.write(this.data, 0, this.length);
        }
    }

    public void read(ImageInputStream imageInputStream, int n) throws IOException {
        imageInputStream.mark();
        imageInputStream.seek(n);
        this.length = imageInputStream.readInt();
        this.type = imageInputStream.readInt();
        int n2 = 0;
        if (this.length == 0) {
            long l = imageInputStream.length();
            if (l != -1L) {
                n2 = (int)(l - imageInputStream.getStreamPosition());
            } else {
                long l2 = imageInputStream.getStreamPosition();
                int n3 = 1024;
                byte[] byArray = new byte[n3];
                long l3 = l2;
                try {
                    imageInputStream.readFully(byArray);
                    n2 += n3;
                    l3 = imageInputStream.getStreamPosition();
                }
                catch (EOFException eOFException) {
                    imageInputStream.seek(l3);
                    while (imageInputStream.read() != -1) {
                        ++n2;
                    }
                }
                imageInputStream.seek(l2);
            }
        } else if (this.length == 1) {
            this.extraLength = imageInputStream.readLong();
            n2 = (int)(this.extraLength - 16L);
        } else if (this.length >= 8 && this.length < 1) {
            n2 = this.length - 8;
        } else {
            throw new IIOException("Illegal value " + this.length + " for box length parameter.");
        }
        this.data = new byte[n2];
        imageInputStream.readFully(this.data);
        imageInputStream.reset();
    }

    protected void parse(byte[] byArray) {
    }

    protected void compose() {
    }

    static {
        names.put(new Integer(1783636000), "JPEG2000SignatureBox");
        names.put(new Integer(1718909296), "JPEG2000FileTypeBox");
        names.put(new Integer(1785737833), "JPEG2000IntellectualPropertyRightsBox");
        names.put(new Integer(2020437024), "JPEG2000XMLBox");
        names.put(new Integer(1970628964), "JPEG2000UUIDBox");
        names.put(new Integer(1969843814), "JPEG2000UUIDInfoBox");
        names.put(new Integer(1785737832), "JPEG2000HeaderSuperBox");
        names.put(new Integer(1785737827), "JPEG2000CodeStreamBox");
        names.put(new Integer(1768449138), "JPEG2000HeaderBox");
        names.put(new Integer(1651532643), "JPEG2000BitsPerComponentBox");
        names.put(new Integer(1668246642), "JPEG2000ColorSpecificationBox");
        names.put(new Integer(1885564018), "JPEG2000PaletteBox");
        names.put(new Integer(1668112752), "JPEG2000ComponentMappingBox");
        names.put(new Integer(1667523942), "JPEG2000ChannelDefinitionBox");
        names.put(new Integer(1919251232), "JPEG2000ResolutionBox");
        names.put(new Integer(1919251299), "JPEG2000CaptureResolutionBox");
        names.put(new Integer(1919251300), "JPEG2000DefaultDisplayResolutionBox");
        names.put(new Integer(1970041716), "JPEG2000UUIDListBox");
        names.put(new Integer(1970433056), "JPEG2000DataEntryURLBox");
        boxClasses = new Hashtable();
        boxClasses.put(new Integer(1783636000), SignatureBox.class);
        boxClasses.put(new Integer(1718909296), FileTypeBox.class);
        boxClasses.put(new Integer(1785737833), Box.class);
        boxClasses.put(new Integer(2020437024), XMLBox.class);
        boxClasses.put(new Integer(1970628964), UUIDBox.class);
        boxClasses.put(new Integer(1768449138), HeaderBox.class);
        boxClasses.put(new Integer(1651532643), BitsPerComponentBox.class);
        boxClasses.put(new Integer(1668246642), ColorSpecificationBox.class);
        boxClasses.put(new Integer(1885564018), PaletteBox.class);
        boxClasses.put(new Integer(1668112752), ComponentMappingBox.class);
        boxClasses.put(new Integer(1667523942), ChannelDefinitionBox.class);
        boxClasses.put(new Integer(1919251232), ResolutionBox.class);
        boxClasses.put(new Integer(1919251299), ResolutionBox.class);
        boxClasses.put(new Integer(1919251300), ResolutionBox.class);
        boxClasses.put(new Integer(1970041716), UUIDListBox.class);
        boxClasses.put(new Integer(1970433056), DataEntryURLBox.class);
    }
}

