/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.mail;

import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opengion.fukurou.mail.MailMessage;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.OgRuntimeException;

public class MailAttachFiles {
    private final List<Part> files = new ArrayList<Part>();
    private final String[] names;

    public MailAttachFiles(Part part) {
        this.names = this.makeNames(part);
    }

    public String[] getNames() {
        String[] stringArray = null;
        if (this.names != null) {
            stringArray = (String[])this.names.clone();
        }
        return stringArray;
    }

    private String[] makeNames(Part part) {
        String[] stringArray;
        try {
            HashSet<String> hashSet = new HashSet<String>();
            this.fileSearch(part);
            stringArray = new String[this.files.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                String string = this.files.get(i).getFileName();
                stringArray[i] = string == null ? "noNameFile" + i + ".tmp" : MailMessage.mimeDecode(string);
                if (hashSet.add(stringArray[i])) continue;
                stringArray[i] = i + "_" + stringArray[i];
            }
        }
        catch (MessagingException messagingException) {
            String string = "\u30e1\u30c3\u30bb\u30fc\u30b8\u60c5\u5831\u306e\u30cf\u30f3\u30c9\u30ea\u30f3\u30b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + messagingException.getMessage();
            throw new OgRuntimeException(string, messagingException);
        }
        catch (IOException iOException) {
            String string = "\u30c6\u30ad\u30b9\u30c8\u60c5\u5831\u306e\u53d6\u308a\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + iOException.getMessage();
            throw new OgRuntimeException(string, iOException);
        }
        return stringArray;
    }

    private boolean fileSearch(Part part) throws MessagingException, IOException {
        if (part.isMimeType("multipart/*")) {
            Multipart multipart = (Multipart)part.getContent();
            int n = multipart.getCount();
            for (int i = 0; i < n; ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                this.fileSearch((Part)bodyPart);
            }
        } else if (part.isMimeType("message/*") || part.getFileName() != null || "inline".equalsIgnoreCase(part.getDisposition())) {
            this.files.add(part);
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveFileName(String string, String string2, int n) {
        boolean bl;
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.exists() && !(bl = file.mkdirs())) {
            String string3 = "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + string + "]";
            throw new OgRuntimeException(string3);
        }
        String string4 = string2 == null ? this.names[n] : string2;
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n2;
            Part part = this.files.get(n);
            inputStream = part.getInputStream();
            fileOutputStream = new FileOutputStream(new File(file, string4));
            byte[] byArray = new byte[1024];
            while ((n2 = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n2);
            }
        }
        catch (MessagingException messagingException) {
            try {
                String string5 = "\u30e1\u30c3\u30bb\u30fc\u30b8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u64cd\u4f5c\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002dir=[" + string + "], file=[" + string4 + "], No=[" + n + "]" + messagingException.getMessage();
                throw new OgRuntimeException(string5, messagingException);
                catch (IOException iOException) {
                    String string6 = "\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u306e\u53d6\u308a\u6271\u3044\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002dir=[" + string + "], file=[" + string4 + "], No=[" + n + "]" + iOException.getMessage();
                    throw new OgRuntimeException(string6, iOException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(fileOutputStream);
                Closer.ioClose(inputStream);
                throw throwable;
            }
        }
        Closer.ioClose(fileOutputStream);
        Closer.ioClose(inputStream);
    }
}

