<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0003"
	title    = "カラム"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:columnCheck command="{@command}" />
<og:entry command="{@command}" />

<!-- 7.2.9.5 (2020/11/28) sqlType はﾏｰｼﾞ対応。ﾒﾓﾘ内での重複ﾁｪｯｸも同時実行 -->
<og:dataCheck
	dbid		= "{@MEM.TO_DBID}"
	command 	= "{@command}"
	sqlType		= "{@sqlType}"
	from		= "GEA03"
	where		= "SYSTEM_ID=[SYSTEM_ID] AND CLM=[CLM] AND KBSAKU=[KBSAKU]"
	uniqCheckClms	= "SYSTEM_ID,CLM,KBSAKU"
	errRemove	= "{@errRemove}"
/>

<og:transaction>
	<og:tableUpdate
		dbid			= "{@MEM.TO_DBID}"
		command			= "{@command}"
		queryType		= "JDBCTableUpdate"
		resourceType	= "GEA03"
		commitTableModel= "false">
		<og:tableUpdateParam
			sqlType			= "{@sqlType}"
			table			= "GEA03"
			omitNames		= "UNIQ,LNAME,SNAME,KBLBL,DESCRIPTION"
			where			= "SYSTEM_ID=[SYSTEM_ID] AND CLM=[CLM] and KBSAKU=[KBSAKU]"
			logicalDelete	= "{@logicalDelete}"
		/>
	</og:tableUpdate>

	<!-- ﾗﾍﾞﾙは、削除以外はキーでマージします。 -->
	<og:equals val1="COPY|MODIFY|INSERT|MERGE" val2="{@sqlType}" contains="true">
		<og:tableUpdate
			dbid			= "{@MEM.TO_DBID}"
			command			= "{@command}"
			queryType		= "JDBCTableUpdate"
			commitTableModel= "false">
			<og:tableUpdateParam
				sqlType		= "MERGE"
				table		= "GEA08"
				names		= "SYSTEM_ID,CLM,NAME_JA,LNAME,SNAME,KBSAKU,SUBSYS,FGLOAD,KBLBL,DESCRIPTION,COMMENTS,RELEASE_NOTES,RDC_CODE,CDKH"
				where		= "SYSTEM_ID=[SYSTEM_ID] and CLM=[CLM] and LANG='ja' and KBSAKU=[KBSAKU]"
				constKeys	= "LANG"
				constVals	= "ja"
			/>
		</og:tableUpdate>
	</og:equals>

	<og:equals val1="DELETE" val2="{@sqlType}">
		<!-- 削除は、すべての LANG に対して実施する -->
		<og:tableUpdate
			dbid			= "{@MEM.TO_DBID}"
			command			= "{@command}"
			queryType		= "JDBCTableUpdate"
			commitTableModel= "false">
			<og:tableUpdateParam
				sqlType			= "{@sqlType}"
				table			= "GEA08"
				where			= "SYSTEM_ID=[SYSTEM_ID] AND CLM=[CLM] AND KBSAKU=[KBSAKU]"
				names			= "CDKH"
				logicalDelete	= "{@logicalDelete}"
			/>
		</og:tableUpdate>
	</og:equals>

</og:transaction>

<!--他システムIDのリソース更新ここから-->
<og:value command="SETTBL" key="CLM" action="APPEND"/><!-- remoteResource.jsp -->
<og:value command="SET" key="remocommand" value="COLUMN"/>
<jsp:directive.include file="/jsp/common/remoteResource.jsp" />
<og:value command="REMOVE" key="CLM" />
<!--他システムリソース更新ここまで-->

<og:forward page="result.jsp" keys="command" vals="RENEW" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
