/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.poi.extractor.POITextExtractor;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.ooxml.extractor.POIXMLExtractorFactory;
import org.apache.poi.sl.usermodel.Shape;
import org.apache.poi.sl.usermodel.ShapeContainer;
import org.apache.poi.sl.usermodel.TableCell;
import org.apache.poi.sl.usermodel.TableShape;
import org.apache.poi.sl.usermodel.TextRun;
import org.apache.poi.sl.usermodel.TextShape;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.SheetUtil;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xssf.usermodel.XSSFSimpleShape;
import org.apache.poi.xwpf.model.XWPFCommentsDecorator;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.opengion.fukurou.model.ExcelModel;
import org.opengion.fukurou.model.ExcelStyleFormat;
import org.opengion.fukurou.model.TextConverter;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.FileInfo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTHyperlink;

public final class POIUtil {
    private static final String VERSION = "8.5.0.0 (2023/05/12)";
    public static final String POI_SUFIX = "ppt,pptx,doc,docx,xls,xlsx,xlsm";
    public static final String TXT_SUFIX = "txt,csv,jsp,java,html,xml,css,js,json,py";

    private POIUtil() {
    }

    public static boolean isPOI(File file) {
        return POI_SUFIX.contains(FileInfo.getSUFIX(file));
    }

    public static boolean isText(File file) {
        return TXT_SUFIX.contains(FileInfo.getSUFIX(file));
    }

    public static boolean isReadText(File file) {
        String string = FileInfo.getSUFIX(file);
        return POI_SUFIX.contains(string) || TXT_SUFIX.contains(string) || "pdf".equals(string);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String extractor(File file) {
        String string;
        POITextExtractor pOITextExtractor = null;
        try {
            pOITextExtractor = new POIXMLExtractorFactory().create(file, null);
            string = pOITextExtractor.getText();
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                String string2 = "\uff8c\uff67\uff72\uff99\u304c\u5b58\u5728\u3057\u307e\u305b\u3093[" + file + "]" + HybsConst.CR + fileNotFoundException.getMessage();
                throw new OgRuntimeException(string2, fileNotFoundException);
                catch (IOException iOException) {
                    String string3 = "\uff8c\uff67\uff72\uff99\u51e6\u7406\uff74\uff97\uff70[" + file + "]" + HybsConst.CR + iOException.getMessage();
                    throw new OgRuntimeException(string3, iOException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(pOITextExtractor);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)pOITextExtractor);
        return string;
    }

    public static String extractor(File file, String string) {
        try {
            byte[] byArray = Files.readAllBytes(file.toPath());
            return new String(byArray, string);
        }
        catch (IOException iOException) {
            String string2 = "\uff8c\uff67\uff72\uff99\u8aad\u8fbc\u307f\uff74\uff97\uff70[" + file + "] , ENCODE=[" + string + "]";
            throw new OgRuntimeException(string2, iOException);
        }
    }

    public static void textReader(File file, TextConverter<String, String> textConverter, String string) {
        BufferedReader bufferedReader = null;
        int n = 0;
        try {
            String string2;
            bufferedReader = Files.newBufferedReader(file.toPath(), Charset.forName(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                textConverter.change(string2, String.valueOf(n++));
            }
        }
        catch (IOException iOException) {
            try {
                String string3 = "\uff8c\uff67\uff72\uff99\u8aad\u8fbc\u307f\uff74\uff97\uff70[" + file + "] , ENCODE=[" + string + "] , ROW=[" + n + "]";
                throw new OgRuntimeException(string3, iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedReader);
                throw throwable;
            }
        }
        Closer.ioClose(bufferedReader);
    }

    public static void textReader(File file, TextConverter<String, String> textConverter) {
        String string = FileInfo.getSUFIX(file);
        if ("doc".equalsIgnoreCase(string)) {
            POIUtil.wordReader1(file, textConverter);
        } else if ("docx".equalsIgnoreCase(string)) {
            POIUtil.wordReader2(file, textConverter);
        } else if ("ppt".equalsIgnoreCase(string)) {
            POIUtil.pptReader1(file, textConverter);
        } else if ("pptx".equalsIgnoreCase(string)) {
            POIUtil.pptReader2(file, textConverter);
        } else if ("xls".equalsIgnoreCase(string)) {
            POIUtil.excelReader1(file, textConverter);
        } else if ("xlsx".equalsIgnoreCase(string) || "xlsm".equalsIgnoreCase(string)) {
            POIUtil.excelReader2(file, textConverter);
        } else if ("pdf".equalsIgnoreCase(string)) {
            POIUtil.pdfReader1(file, textConverter);
        } else if (TXT_SUFIX.contains(string)) {
            try {
                POIUtil.textReader(file, textConverter, "UTF-8");
            }
            catch (OgRuntimeException ogRuntimeException) {
                textConverter.change(ogRuntimeException.getMessage(), file.getAbsolutePath());
                POIUtil.textReader(file, textConverter, "Windows-31J");
            }
        } else {
            try {
                String string2 = file.getCanonicalPath();
                textConverter.change("\uff83\uff77\uff7d\uff84\u5316\u5bfe\u8c61\u5916\u3067\u3059", string2);
            }
            catch (IOException iOException) {
                String string3 = "\u6b63\u898f\u306e\u30d1\u30b9\u540d\u53d6\u5f97\uff74\uff97\uff70[" + file + "]";
                throw new OgRuntimeException(string3, iOException);
            }
        }
    }

    private static void wordReader1(File file, TextConverter<String, String> textConverter) {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            HWPFDocument hWPFDocument = new HWPFDocument((InputStream)bufferedInputStream);
            Range range = hWPFDocument.getRange();
            for (int i = 0; i < range.numParagraphs(); ++i) {
                Paragraph paragraph = range.getParagraph(i);
                String string = Range.stripFields((String)paragraph.text()).replaceAll("\\x13[^\\x01]+\\x01\\x14", "").replaceAll("\\x0b", "\n").trim();
                if (string.length() <= 0) continue;
                textConverter.change(string, String.valueOf(i));
            }
        }
        catch (IOException iOException) {
            try {
                String string = "\uff8c\uff67\uff72\uff99\u8aad\u8fbc\u307f\uff74\uff97\uff70[" + file + "]" + HybsConst.CR + iOException.getMessage();
                throw new OgRuntimeException(string, iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedInputStream);
                throw throwable;
            }
        }
        Closer.ioClose(bufferedInputStream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void wordReader2(File file, TextConverter<String, String> textConverter) {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            XWPFDocument xWPFDocument = new XWPFDocument((InputStream)bufferedInputStream);
            int n = 0;
            for (IBodyElement iBodyElement : xWPFDocument.getBodyElements()) {
                String string;
                if (iBodyElement instanceof XWPFParagraph) {
                    POIUtil.appendParagraphText(textConverter, n, (XWPFParagraph)iBodyElement);
                } else if (iBodyElement instanceof XWPFTable) {
                    POIUtil.appendTableText(textConverter, n, (XWPFTable)iBodyElement);
                } else if (iBodyElement instanceof XWPFSDT && (string = ((XWPFSDT)iBodyElement).getContent().getText().trim()).length() > 0) {
                    textConverter.change(string, "XWPFSDT " + n);
                }
                ++n;
            }
        }
        catch (ZipException zipException) {
            try {
                String string = "\uff8c\uff67\uff72\uff99\u304c\u3059\u3067\u306b\uff75\uff70\uff8c\uff9f\uff9d\u3055\u308c\u3066\u3044\u307e\u3059[" + file + "]" + HybsConst.CR + zipException.getMessage();
                throw new OgRuntimeException(string, zipException);
                catch (IOException iOException) {
                    String string2 = "\uff8c\uff67\uff72\uff99\u8aad\u8fbc\u307f\uff74\uff97\uff70[" + file + "]" + HybsConst.CR + iOException.getMessage();
                    throw new OgRuntimeException(string2, iOException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedInputStream);
                throw throwable;
            }
        }
        Closer.ioClose(bufferedInputStream);
    }

    private static void appendParagraphText(TextConverter<String, String> textConverter, int n, XWPFParagraph xWPFParagraph) {
        XWPFCommentsDecorator xWPFCommentsDecorator;
        String string;
        String string2;
        String string3 = xWPFParagraph.getText().trim();
        if (string3.length() > 0) {
            textConverter.change(string3, "Paragraph " + n);
        }
        if ((string2 = xWPFParagraph.getFootnoteText().trim()).length() > 0) {
            textConverter.change(string2, "Footnote " + n);
        }
        if ((string = (xWPFCommentsDecorator = new XWPFCommentsDecorator(xWPFParagraph, null)).getCommentText().trim()).length() > 0) {
            textConverter.change(string, "Comment " + n);
        }
    }

    private static void appendTableText(TextConverter<String, String> textConverter, int n, XWPFTable xWPFTable) {
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder(200);
        for (XWPFTableRow xWPFTableRow : xWPFTable.getRows()) {
            for (XWPFTableCell xWPFTableCell : xWPFTableRow.getTableCells()) {
                stringBuilder.append(xWPFTableCell.getText().trim()).append('\t');
            }
            String string = stringBuilder.toString().trim();
            if (string.length() > 0) {
                textConverter.change(string, "TableRow " + n + ":" + n2);
            }
            stringBuilder.setLength(0);
            ++n2;
        }
    }

    private static void pptReader1(File file, TextConverter<String, String> textConverter) {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            HSLFSlideShow hSLFSlideShow = new HSLFSlideShow((InputStream)bufferedInputStream);
            List list = hSLFSlideShow.getSlides();
            int n = 0;
            for (HSLFSlide hSLFSlide : list) {
                int n2 = 0;
                for (List list2 : hSLFSlide.getTextParagraphs()) {
                    String string = HSLFTextParagraph.getText((List)list2).trim();
                    if (string.length() > 0) {
                        textConverter.change(string, "Slide " + n + ":" + n2);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            try {
                String string = "\uff8c\uff67\uff72\uff99\u8aad\u8fbc\u307f\uff74\uff97\uff70[" + file + "]" + HybsConst.CR + iOException.getMessage();
                throw new OgRuntimeException(string, iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedInputStream);
                throw throwable;
            }
        }
        Closer.ioClose(bufferedInputStream);
    }

    private static void pptReader2(File file, TextConverter<String, String> textConverter) {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            XMLSlideShow xMLSlideShow = new XMLSlideShow((InputStream)bufferedInputStream);
            int n = 0;
            for (XSLFSlide xSLFSlide : xMLSlideShow.getSlides()) {
                textConverter.change(xSLFSlide.getSlideName(), "Slide " + n);
                POIUtil.printShapeText((ShapeContainer<XSLFShape, XSLFTextParagraph>)xSLFSlide, textConverter, n);
                ++n;
            }
        }
        catch (IOException iOException) {
            try {
                String string = "\uff8c\uff67\uff72\uff99\u8aad\u8fbc\u307f\uff74\uff97\uff70[" + file + "]" + HybsConst.CR + iOException.getMessage();
                throw new OgRuntimeException(string, iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedInputStream);
                throw throwable;
            }
        }
        Closer.ioClose(bufferedInputStream);
    }

    private static void printShapeText(ShapeContainer<XSLFShape, XSLFTextParagraph> shapeContainer, TextConverter<String, String> textConverter, int n) {
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder(200);
        for (Shape shape : shapeContainer) {
            if (shape instanceof TextShape) {
                stringBuilder.setLength(0);
                POIUtil.printTextParagraphs(((TextShape)shape).getTextParagraphs(), stringBuilder);
                String string = stringBuilder.toString().trim();
                if (string.length() > 0) {
                    textConverter.change(string, "Shape " + n + ":" + n2);
                }
                ++n2;
                continue;
            }
            if (shape instanceof TableShape) {
                POIUtil.printTableShape((TableShape<XSLFShape, XSLFTextParagraph>)((TableShape)shape), textConverter, n);
                continue;
            }
            if (!(shape instanceof ShapeContainer)) continue;
            POIUtil.printShapeText((ShapeContainer<XSLFShape, XSLFTextParagraph>)((ShapeContainer)shape), textConverter, n);
        }
    }

    private static void printTableShape(TableShape<XSLFShape, XSLFTextParagraph> tableShape, TextConverter<String, String> textConverter, int n) {
        StringBuilder stringBuilder = new StringBuilder(200);
        int n2 = tableShape.getNumberOfRows();
        int n3 = tableShape.getNumberOfColumns();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                TableCell tableCell = tableShape.getCell(i, j);
                if (tableCell == null) continue;
                POIUtil.printTextParagraphs(tableCell.getTextParagraphs(), stringBuilder);
                stringBuilder.append('\t');
            }
            String string = stringBuilder.toString().trim();
            if (string.length() > 0) {
                textConverter.change(string, "TableRow " + n + ":" + i);
            }
            stringBuilder.setLength(0);
        }
    }

    private static void printTextParagraphs(List<XSLFTextParagraph> list, StringBuilder stringBuilder) {
        for (XSLFTextParagraph xSLFTextParagraph : list) {
            for (TextRun textRun : xSLFTextParagraph) {
                stringBuilder.append(textRun.getRawText().trim());
            }
        }
    }

    public static void excelReader1(File file, TextConverter<String, String> textConverter) {
        POIUtil.excelReader2(file, textConverter);
    }

    public static void excelReader2(File file, TextConverter<String, String> textConverter) {
        ExcelModel excelModel = new ExcelModel(file, true);
        excelModel.textConverter((string, string2) -> {
            textConverter.change((String)string, (String)string2);
            return null;
        });
    }

    public static void pdfReader1(File file, TextConverter<String, String> textConverter) {
        Logger.getLogger("org.apache.fontbox").setLevel(Level.OFF);
        try (PDDocument pDDocument = PDDocument.load((File)file);){
            int n = pDDocument.getNumberOfPages();
            PDFTextStripper pDFTextStripper = new PDFTextStripper();
            String string = pDFTextStripper.getLineSeparator();
            for (int i = 1; i <= n; ++i) {
                pDFTextStripper.setStartPage(i);
                pDFTextStripper.setEndPage(i);
                int n2 = 0;
                String string2 = pDFTextStripper.getText(pDDocument);
                for (String string3 : string2.split(string)) {
                    String string4 = "Page" + i + " : " + n2;
                    textConverter.change(string3, string4);
                    ++n2;
                }
            }
        }
        catch (IOException iOException) {
            String string = "\uff8c\uff67\uff72\uff99\u8aad\u8fbc\u307f\uff74\uff97\uff70[" + file + "]" + HybsConst.CR + iOException.getMessage();
            throw new OgRuntimeException(string, iOException);
        }
    }

    public static int[] kigo2rowCol(String string) {
        int n = 0;
        int n2 = -1;
        if ("SHEET".equalsIgnoreCase(string)) {
            n = -1;
        } else {
            int n3 = string.indexOf(45);
            if (n3 > 0) {
                n = Integer.parseInt(string.substring(0, n3));
                n2 = Integer.parseInt(string.substring(n3 + 1));
            } else {
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if ('A' > c || c > 'Z') {
                        n = Integer.parseInt(string.substring(i)) - 1;
                        break;
                    }
                    n2 = (n2 + 1) * 26 + c - 65;
                }
            }
        }
        return new int[]{n, n2};
    }

    public static String getValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        String string = "";
        block1 : switch (cell.getCellType()) {
            case NUMERIC: {
                string = POIUtil.getNumericTypeString(cell);
                break;
            }
            case STRING: {
                RichTextString richTextString = cell.getRichStringCellValue();
                if (richTextString == null) break;
                string = richTextString.getString();
                break;
            }
            case FORMULA: {
                try {
                    Workbook workbook = cell.getSheet().getWorkbook();
                    CreationHelper creationHelper = workbook.getCreationHelper();
                    FormulaEvaluator formulaEvaluator = creationHelper.createFormulaEvaluator();
                    CellValue cellValue = formulaEvaluator.evaluate(cell);
                    switch (cellValue.getCellType()) {
                        case STRING: {
                            string = cellValue.getStringValue();
                            break block1;
                        }
                        case NUMERIC: {
                            string = Double.toString(cellValue.getNumberValue());
                            break block1;
                        }
                        case BOOLEAN: {
                            string = Boolean.toString(cellValue.getBooleanValue());
                            break block1;
                        }
                    }
                    string = cell.getCellFormula();
                }
                catch (Throwable throwable) {
                    String string2 = "\uff7e\uff99\uff8c\uff6b\uff70\uff8f\uff6f\uff84\u304c\u89e3\u6790\u3067\u304d\u307e\u305b\u3093\u3002" + HybsConst.CR + "  Formula=[" + cell.getCellFormula() + "]" + HybsConst.CR + POIUtil.getCellMsg(cell);
                    System.err.println(string2);
                    string = cell.toString();
                }
                break;
            }
            case BOOLEAN: {
                string = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case BLANK: {
                break;
            }
            case ERROR: {
                break;
            }
            default: {
                String string3 = "\uff7e\uff99\uff80\uff72\uff8c\uff9f\u304c\u4e0d\u660e\u3067\u3059\u3002CellType=" + cell.getCellType() + HybsConst.CR + POIUtil.getCellMsg(cell);
                System.err.println(string3);
                string = cell.toString();
            }
        }
        return string;
    }

    public static void setValue(Cell cell, String string) {
        if (cell == null) {
            return;
        }
        if (string == null || string.isEmpty()) {
            cell.setBlank();
        }
        switch (cell.getCellType()) {
            case NUMERIC: {
                cell.setCellValue(Double.parseDouble(string));
                break;
            }
            case BOOLEAN: {
                cell.setCellValue("true".equalsIgnoreCase(string));
                break;
            }
            default: {
                cell.setCellValue(string);
            }
        }
    }

    public static String getNumericTypeString(Cell cell) {
        String string;
        double d = cell.getNumericCellValue();
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            string = ExcelStyleFormat.dateFormat(d);
        } else {
            String string2 = cell.getCellStyle().getDataFormatString();
            string = ExcelStyleFormat.getNumberValue(string2, d);
        }
        return string;
    }

    public static void autoCellSize(Workbook workbook, int n, int n2) {
        int n3 = workbook.getNumberOfSheets();
        for (int i = 0; i < n3; ++i) {
            int n4;
            Sheet sheet = workbook.getSheetAt(i);
            int n5 = sheet.getDefaultColumnWidth();
            int n6 = n5 * 256 * n;
            int n7 = sheet.getFirstRowNum();
            int n8 = sheet.getLastRowNum();
            Row row = sheet.getRow(n7);
            int n9 = row == null ? 0 : row.getFirstCellNum();
            int n10 = n4 = row == null ? 256 : (int)row.getLastCellNum();
            if (n7 < n2) {
                n7 = n2;
            }
            for (int j = n9; j < n4; ++j) {
                double d = SheetUtil.getColumnWidth((Sheet)sheet, (int)j, (boolean)true, (int)n7, (int)n8);
                if (!(d >= 0.0)) continue;
                int n11 = (int)Math.ceil(d * 256.0);
                if (n6 >= 0 && n11 > n6) {
                    n11 = n6;
                }
                sheet.setColumnWidth(j, n11);
            }
        }
    }

    public static void activeWorkbook(Workbook workbook, boolean bl) {
        int n = workbook.getNumberOfSheets();
        block0: for (int i = 0; i < n; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            int n2 = sheet.getFirstRowNum();
            int n3 = sheet.getLastRowNum();
            boolean bl2 = true;
            for (int j = n3; j >= n2 && j >= 0; --j) {
                Row row = sheet.getRow(j);
                if (row == null) continue;
                short s = row.getFirstCellNum();
                int n4 = row.getLastCellNum();
                if (s >= 0 && n4 >= 0) {
                    CellStyle cellStyle = row.getCell((int)s).getCellStyle();
                    for (int k = n4; k >= s && k >= 0; --k) {
                        Cell cell = row.getCell(k);
                        if (cell == null) continue;
                        String string = POIUtil.getValue(cell);
                        if (cell.getCellType() != CellType.BLANK && string != null && string.length() > 0) {
                            bl2 = false;
                            break;
                        }
                        if (!cellStyle.equals(cell.getCellStyle())) {
                            bl2 = false;
                            break;
                        }
                        if (!bl) continue;
                        row.removeCell(cell);
                    }
                }
                if (bl2) {
                    sheet.removeRow(row);
                    continue;
                }
                if (!bl) continue block0;
            }
        }
    }

    public static void activeWorkbook(Workbook workbook, List<Integer> list) {
        int n = workbook.getNumberOfSheets();
        for (int i = 0; i < n; ++i) {
            int n2;
            Sheet sheet = workbook.getSheetAt(i);
            int n3 = list.get(i);
            for (int j = n2 = sheet.getLastRowNum(); j >= n3 && j >= 0; --j) {
                Row row = sheet.getRow(j);
                if (row == null) continue;
                sheet.removeRow(row);
            }
        }
    }

    public static Workbook createWorkbook(File file) {
        Workbook workbook;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            workbook = WorkbookFactory.create((InputStream)bufferedInputStream);
        }
        catch (IOException iOException) {
            try {
                String string = "\uff8c\uff67\uff72\uff99\u8aad\u8fbc\u307f\uff74\uff97\uff70[" + file + "]" + HybsConst.CR + iOException.getMessage();
                throw new OgRuntimeException(string, iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedInputStream);
                throw throwable;
            }
        }
        Closer.ioClose(bufferedInputStream);
        return workbook;
    }

    public static String[] getSheetNames(Workbook workbook) {
        int n = workbook.getNumberOfSheets();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            stringArray[i] = sheet.getSheetName();
        }
        return stringArray;
    }

    public static String[] getNames(Workbook workbook) {
        TreeSet<CallSite> treeSet = new TreeSet<CallSite>();
        for (Name name : workbook.getAllNames()) {
            String string = null;
            String string2 = null;
            try {
                string = name.getNameName();
                string2 = name.getRefersToFormula();
            }
            catch (RuntimeException runtimeException) {
                String string3 = "POIUtil:RefersToFormula Error! name=[" + string + "]" + runtimeException.getMessage();
                System.out.println(string3);
            }
            treeSet.add((CallSite)((Object)(string + "\t" + string2)));
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public static String[] getStyleNames(Workbook workbook) {
        int n = workbook.getNumCellStyles();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < n; ++i) {
            CellStyle cellStyle = workbook.getCellStyleAt((int)((short)i));
            if (!(cellStyle instanceof HSSFCellStyle)) continue;
            HSSFCellStyle hSSFCellStyle = (HSSFCellStyle)cellStyle;
            String string = hSSFCellStyle.getUserStyleName();
            if (string == null) {
                String string2;
                HSSFCellStyle hSSFCellStyle2 = hSSFCellStyle.getParentStyle();
                if (hSSFCellStyle2 == null || (string2 = hSSFCellStyle2.getUserStyleName()) == null) continue;
                treeSet.add(string2);
                continue;
            }
            treeSet.add(string);
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public static String getCellMsg(Cell cell) {
        String string = null;
        if (cell != null) {
            String string2 = cell.getSheet().getSheetName();
            int n = cell.getRowIndex();
            int n2 = cell.getColumnIndex();
            string = "  Sheet=" + string2 + ", Row=" + n + ", Cel=" + n2 + "(" + POIUtil.getCelKigo(n, n2) + "), Val=" + cell.toString();
        }
        return string;
    }

    public static String getCelKigo(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(200);
        int n3 = n2;
        while (n3 >= 26) {
            stringBuilder.append((char)(65 + n3 % 26));
            n3 = n3 / 26 - 1;
        }
        stringBuilder.append((char)(65 + n3 % 26)).reverse().append(n + 1);
        return stringBuilder.toString();
    }

    public static void makeShapeLink(XSSFSimpleShape xSSFSimpleShape, String string) {
        if (string == null) {
            return;
        }
        String string2 = xSSFSimpleShape.getDrawing().getPackagePart().addExternalRelationship(string, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink").getId();
        CTHyperlink cTHyperlink = (CTHyperlink)CTHyperlink.Factory.newInstance();
        cTHyperlink.setId(string2);
        xSSFSimpleShape.getCTShape().getNvSpPr().getCNvPr().setHlinkClick(cTHyperlink);
    }

    public static void makeShapeColor(XSSFSimpleShape xSSFSimpleShape, int[] nArray) {
        if (nArray != null) {
            xSSFSimpleShape.setFillColor(nArray[0], nArray[1], nArray[2]);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java org.opengion.fukurou.model.POIUtil \u5165\u529b\uff8c\uff67\uff72\uff99\u540d [\u51e6\u7406\u65b9\u5f0f] [\uff74\uff9d\uff7a\uff70\uff84\uff9e]\n\t -A(LL)        \uff65\uff65\uff65 ALL \u4e00\u62ec\u51e6\u7406(\u521d\u671f\u5024)      \n\t -L(INE)       \uff65\uff65\uff65 LINE \u884c\u5358\u4f4d\u51e6\u7406           \n\t -S(heet)      \uff65\uff65\uff65 Sheet\u540d\u4e00\u89a7               \n\t -N(AME)       \uff65\uff65\uff65 NAME:\u540d\u524d\u5b9a\u7fa9             \n\t -C(ellStyle)  \uff65\uff65\uff65 CellStyle:\u66f8\u5f0f\u306e\uff7d\uff80\uff72\uff99  \n");
            return;
        }
        File file = new File(stringArray[0]);
        int n = stringArray.length >= 2 ? (int)stringArray[1].charAt(1) : 65;
        String string3 = stringArray.length >= 3 ? stringArray[2] : null;
        switch (n) {
            case 65: {
                if (string3 == null) {
                    System.out.println(POIUtil.extractor(file));
                    break;
                }
                System.out.println(POIUtil.extractor(file, string3));
                break;
            }
            case 76: {
                TextConverter<String, String> textConverter = (string, string2) -> {
                    System.out.println("val=" + string + " , cmnt=" + string2);
                    return null;
                };
                if (string3 == null) {
                    POIUtil.textReader(file, textConverter);
                    break;
                }
                POIUtil.textReader(file, textConverter, string3);
                break;
            }
            case 83: {
                String[] stringArray2 = POIUtil.getSheetNames(POIUtil.createWorkbook(file));
                System.out.println("No:\tSheetName");
                for (int i = 0; i < stringArray2.length; ++i) {
                    System.out.println(i + "\t" + stringArray2[i]);
                }
                break;
            }
            case 78: {
                String[] stringArray3 = POIUtil.getNames(POIUtil.createWorkbook(file));
                System.out.println("No:\tName\tFormula");
                for (int i = 0; i < stringArray3.length; ++i) {
                    System.out.println(i + "\t" + stringArray3[i]);
                }
                break;
            }
            case 67: {
                String[] stringArray4 = POIUtil.getStyleNames(POIUtil.createWorkbook(file));
                System.out.println("No:\tStyleName");
                for (int i = 0; i < stringArray4.length; ++i) {
                    System.out.println(i + "\t" + stringArray4[i]);
                }
                break;
            }
            default: {
                System.err.println("Usage: java org.opengion.fukurou.model.POIUtil \u5165\u529b\uff8c\uff67\uff72\uff99\u540d [\u51e6\u7406\u65b9\u5f0f] [\uff74\uff9d\uff7a\uff70\uff84\uff9e]\n\t -A(LL)        \uff65\uff65\uff65 ALL \u4e00\u62ec\u51e6\u7406(\u521d\u671f\u5024)      \n\t -L(INE)       \uff65\uff65\uff65 LINE \u884c\u5358\u4f4d\u51e6\u7406           \n\t -S(heet)      \uff65\uff65\uff65 Sheet\u540d\u4e00\u89a7               \n\t -N(AME)       \uff65\uff65\uff65 NAME:\u540d\u524d\u5b9a\u7fa9             \n\t -C(ellStyle)  \uff65\uff65\uff65 CellStyle:\u66f8\u5f0f\u306e\uff7d\uff80\uff72\uff99  \n");
            }
        }
    }
}

