<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" >
	<script>
//		window.onload = function(){
		window.addEventListener('load', function(){		// 8.3.0.0 (2022/08/01)
			dbCnt = $("#DBCNT").val();
			if(dbCnt == 0) {
				$("#XMLZIP").css('display','none');
			}
		} );
	</script>

	<style>
		table.wd100 td { width: 100px;}
	</style>
</og:head>
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジンサンプル"
	pgid	= "GE0009"
	title	= "XML抜き出し"
	date	= "2007/12/12"
	author	= "K.HASEGAWA"
	text	= "ZZZZ"
	version	= "001"
/>

<!-- 入力チェックを行います。 -->
<og:columnCheck
	command		= "{@command}"
	nullCheck	= "SYSTEM_ID"
/>

<og:value command="SET" key="DIR" value="{@USER.ID}/{@SYSTEM_ID}/db/resource/xml/update" />
<og:value command="SET" key="ZIP" value="{@USER.ID}/{@SYSTEM_ID}/zip" />
<og:equals val1="**" val2="{@SYSTEM_ID}" >
	<og:value command="SET" key="DIR" value="{@USER.ID}/CMN/db/resource/xml/update" />
	<og:value command="SET" key="ZIP" value="{@USER.ID}/CMN/zip" />
</og:equals>

<!-- 出力先フォルダを削除します。 -->
<og:file action="delete" useLocal="true" file1="{@SYS.REAL_PATH}{@SYS.FILE_URL}{@DIR}" caseIf="{@DEL}" />

<!-- ZIP出力の場合、リンクを用意します。 -->
<og:equals val1="{@ZIP_FILE}" notNull="true">
	<og:link href="{@SYS.JSP}/fileDownload" target="_blank" useGamenId="false" id="XMLZIP"
				keys="file,name,useLocal" vals="{@SYS.FILE_URL}{@ZIP}/{@ZIP_FILE}.zip,{@ZIP_FILE}.zip,true" >
		<img src="{@SYS.JSP_IMG}/floppy.gif" alt="Excel Open" /> {@ZIP_FILE}.zip <og:message lbl="MSG0056" /><br />
	</og:link>
</og:equals>

<!-- 出力先フォルダのｱﾄﾞﾚｽ表示 -->
<og:text>{@SYS.REAL_PATH}{@SYS.FILE_URL}{@DIR}</og:text><br />
=============================================================================
<og:switch key="{@TargetDB}" >
	<og:case match="RSC" ><jsp:directive.include file="result_resource.jsp"  /></og:case>
	<og:case match="SYS" ><jsp:directive.include file="result_system.jsp"    /></og:case>
	<og:equals val1="{@CDKH}" isNull="true" >
		<og:case match="RPT" ><jsp:directive.include file="result_report.jsp"     /></og:case>
		<og:case match="RPD" ><jsp:directive.include file="result_reportData.jsp" /></og:case>
	</og:equals>
</og:switch>

<br/>

<!-- ZIPファイルの作成 -->
<og:equals val1="{@ZIP_FILE}" notNull="true">
	<og:equals val1="{@DBCNT}" val2="0" notEquals="true" >
		<og:file action="zip" useLocal="true" file1="{@SYS.REAL_PATH}{@SYS.FILE_URL}{@DIR}" file2="{@ZIP}/{@ZIP_FILE}.zip" />
		<!-- 直接ダウンロードする場合
		<og:forward page="{@SYS.JSP}/fileDownload" useRedirect="true" redirectEncode="UTF-8"
			keys="file,name,useLocal"
			vals="{@SYS.REAL_PATH}{@SYS.FILE_URL}{@ZIP}/{@ZIP_FILE}.zip,{@ZIP_FILE}.zip,true" />
		-->
	</og:equals>
</og:equals>

<!-- 総抜出件数 (0件の場合、ZIPﾌｧｲﾙｱｲｺﾝを非表示にする JavaScript用) -->
<og:hidden name="DBCNT" value="{@DBCNT}" noForm="true" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
