<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE7003"
	title    = "処理定義ﾏｽﾀ"
	date     = "2017/06/27"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:columnCheck command="{@command}" />
<og:entry command="{@command}" />

<!-- 7.2.9.5 (2020/11/28) sqlType はﾏｰｼﾞ対応。ﾒﾓﾘ内での重複ﾁｪｯｸも同時実行 -->
<og:dataCheck
	dbid		= "{@MEM.TO_DBID}"
	command 	= "{@command}"
	sqlType		= "{@sqlType}"
	from		= "GE72"
	where		= "SYSTEM_ID=[SYSTEM_ID] AND EXECID=[EXECID]"
	uniqCheckClms	= "SYSTEM_ID,EXECID"
	errRemove	= "{@errRemove}"
/>

<og:transaction>
	<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate" debug="{@debug}">
		<og:tableUpdateParam
			sqlType		= "{@sqlType}"
			table		= "GE72"
			where		= "SYSTEM_ID=[SYSTEM_ID] AND EXECID=[EXECID]"
		/>
	</og:tableUpdate>

	<!-- SEQNOの再セット -->
	<og:query
		command		= "NEW"
		scope		= "request"
		maxRowCount	= "0" >
			SELECT SYSTEM_ID,SEQNO,UNIQ
			FROM   GE72
			WHERE  FGJ IN ( '0','1' )
			ORDER  BY SYSTEM_ID,SEQNO,EXECID
	</og:query>
	<og:tableFilter classId="SEQRESET" keys="SEQ_CLM,CLEAR_CLM" vals="SEQNO,SYSTEM_ID" selectedAll="true" scope="request" />
	<og:tableUpdate
		command		= "ENTRY"
		scope		= "request"
		selectedAll = "true"
		queryType	= "JDBCTableUpdate" >
			UPDATE GE72 SET
				SEQNO  = [SEQNO]
			WHERE SYSTEM_ID=[SYSTEM_ID] AND UNIQ=[UNIQ]
			AND SEQNO != [SEQNO]
	</og:tableUpdate>
</og:transaction>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
