<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useAjaxSubmit="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン"
	pgid	= "MAIL01"
	title	= "定型文マスタ管理"
	date	= "2009/04/01"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<!-- forward.jsp から command = "COPY/MODIFY/DELETE" がセットされて遷移してきます。-->
<!-- データが選ばれていなければエラー -->
<og:columnCheck command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- entryタグのcommandとcolumnSetのコマンドが同じ場合のみ、動作します。 -->
<og:entry command = "{@command}" >
<og:columnSet command = "INSERT" action = "SET" value = "{@SYS.SYSTEM_ID}" columnId = "SYSTEM_ID" />
</og:entry>
<og:equals val1="{@command}" val2="DELETE" notEquals="true">
<!--
	<og:columnEditor columns="TO_ID,CC_ID,BCC_ID" mustAny="true" />
-->
</og:equals>
<og:message command="{@command}" /><br />  <!-- 動的にコメントを表示します。 -->

<form method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンを作成します。 -->
<!-- HTMLTextField(１点入力)使用時には、EXCEL(CSV)取り込みは使えません。 -->
<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit value="entry" lbl="ENTRY" accesskey="E" />
	<og:submit value="reset" lbl="RESET" accesskey="R" />
	<og:input  type="reset"  name="command" lbl="MSG0011" td="false" />
	<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<!-- viewFormType="HTMLTextField" を使用する場合は、skip="true"が必要です。 -->
<og:view
	viewFormType   = "HTMLFormatTextField"
	command        = "{@command}"
	noDisplay      = "UNIQ,PUP"
	columnWritable = "FROM_ID,TO_ID,CC_ID,BCC_ID,MAIL_TITLE,CONTENTS,JOKEN"
	noMessage      = "true"
	skip           = "true"
>
	<table >
		<tr>[SYSTEM_ID]</tr>
		<tr>[PTN_ID]</tr>
		<tr>[FROM_ID]</tr>
		<tr>[TO_ID]</tr>
		<tr>[CC_ID]</tr>
		<tr>[BCC_ID]</tr>
		<tr>[MAIL_TITLE]</tr>
		<tr>[CONTENTS]</tr>
		<tr>[JOKEN]</tr>
	</table>
</og:view>

<og:hidden name="SQL" >
	UPDATE GE31 SET
		 FROM_ID	= [FROM_ID]
		,TO_ID		= [TO_ID]
		,CC_ID		= [CC_ID]
		,BCC_ID		= [BCC_ID]
		,TITLE		= [MAIL_TITLE]
		,CONTENTS	= [CONTENTS]
		,JOKEN		= [JOKEN]
		,DYUPD		= '{@DATE.YMDHMS}'
		,USRUPD		= '{@USER.ID}'
		,PGUPD		= '{@GUI.KEY}'
	WHERE UNIQ = [UNIQ]
</og:hidden>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
