<jsp:directive.page pageEncoding="UTF-8" />
<!-- 面別総計表示 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select A.GUIKEY,B.NAME_JA
				, sum(A.CNT_ACCESS)		AS SUM_ACCESS
				, sum(A.CNT_ERROR)		AS SUM_ERROR
				, sum(A.CNT_READ)		AS SUM_READ
				, sum(A.CNT_WRITE)		AS SUM_WRITE
				, sum(A.TM_TOTAL_QUERY) AS SUM_TOTAL_QUERY
				, max(A.TM_MAX_QUERY)	AS TM_MAX_QUERY
		from GE15 A left outer join GEA11 B
		on      A.SYSTEM_ID = B.SYSTEM_ID
		and     A.GUIKEY    = B.GUIKEY
		and     B.FGJ       = '1'
		where   A.GUIKEY   is not null
	<og:where startKey="and">
		<og:and value = "A.SYSTEM_ID	=	'{@SYSTEM_ID}'"	/>
		<og:and value = "A.GUIKEY		=	'{@GUIKEY}'"	/>
		<og:and value = "A.DYLOGIN		like '{@DATE}%'"	/>
	</og:where>
	group by A.SYSTEM_ID,A.GUIKEY,B.NAME_JA
	order by A.SYSTEM_ID,{@SORT} A.GUIKEY
</og:query>

<og:viewLink command="{@command}">
	<og:link column="GUIKEY" gamenId="GE0002" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,GUIKEY,LANG"
		vals="NEW,{@SYSTEM_ID},[GUIKEY],ja" />
	<og:link column="TM_MAX_QUERY" href="result.jsp" target="RESULT"
		keys="command,SYSTEM_ID,GUIKEY,ACTION,TM_MAX_QUERY"
		vals="NEW,{@SYSTEM_ID},[GUIKEY],GEM0020,[TM_MAX_QUERY]" />
</og:viewLink>

<og:view
	viewFormType = "HTMLTable"
	command      = "{@command}"
	checked      = "{@checked}"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}" />
