/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.time.Duration;
import java.util.LinkedHashMap;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.system.ThrowUtil;
import org.opengion.fukurou.util.AbstractConnect;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.StringUtil;

public final class FTPConnect
extends AbstractConnect {
    private final FTPClient ftp = new FTPClient();
    private static final int DEF_PORT = 21;
    private boolean isAsciiMode = true;
    private boolean isPassive = true;
    private String encode = "UTF-8";
    private boolean isConnect;
    private String lastRemoteDir = "/";

    @Override
    public void connect() {
        if (this.isDisplay) {
            System.out.println("CONNECT: HOST=" + this.host + ",USER=" + this.user + ",PORT=" + this.port);
        }
        if (this.isConnect) {
            this.disconnect();
        }
        try {
            if (this.encode != null) {
                this.ftp.setControlEncoding(this.encode);
            }
            this.ftp.connect(this.host, this.getPort(21));
            int n = this.ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)n)) {
                this.errAppend((Object)"FTP server refused connection. [PositiveCompletion]");
                this.errAppend("   host    = [", this.host, "]");
                this.errAppend("   user    = [", this.user, "]");
                this.errAppend("   port    = [", this.port, "]");
                this.errAppend((Object)this.ftp.getReplyString());
                this.disconnect();
                throw new OgRuntimeException(this.getErrMsg());
            }
            if (!this.ftp.login(this.user, this.passwd)) {
                this.errAppend((Object)"\u30ed\u30b0\u30a4\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                this.errAppend("   host    = [", this.host, "]");
                this.errAppend("   user    = [", this.user, "]");
                this.errAppend("   port    = [", this.port, "]");
                this.errAppend((Object)this.ftp.getReplyString());
                this.disconnect();
                throw new OgRuntimeException(this.getErrMsg());
            }
            this.paramInit();
        }
        catch (IOException iOException) {
            this.errAppend((Object)"FTP server refused connection.");
            this.errAppend((Object)this.ftp.getReplyString());
            this.errAppend((Object)iOException);
            if (this.isDebug) {
                System.err.println(ThrowUtil.ogStackTrace(iOException));
            }
            this.disconnect();
            throw new OgRuntimeException(this.getErrMsg(), iOException);
        }
        this.isConnect = true;
    }

    private void paramInit() throws IOException {
        this.ftp.setDataTimeout(Duration.ofSeconds(this.timeout));
        if (this.isDisplay && this.isDebug) {
            this.ftp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out)));
        }
        if (this.isPassive) {
            this.ftp.enterLocalPassiveMode();
        } else {
            this.ftp.enterLocalActiveMode();
        }
        boolean bl = true;
        bl = this.isAsciiMode ? this.ftp.setFileType(0) : this.ftp.setFileType(2);
        if (!bl) {
            this.errAppend((Object)"paramInit Error.");
            this.errAppend((Object)this.ftp.getReplyString());
            throw new OgRuntimeException(this.getErrMsg());
        }
    }

    @Override
    public void disconnect() {
        if (this.isDisplay) {
            System.out.println("DISCONNECT:");
        }
        if (this.isConnect) {
            this.isConnect = false;
            try {
                this.ftp.logout();
                if (this.ftp.isConnected()) {
                    this.ftp.disconnect();
                }
            }
            catch (Throwable throwable) {
                this.errAppend((Object)"disconnect Error.");
                this.errAppend((Object)this.ftp.getReplyString());
                this.errAppend((Object)throwable);
                if (this.isDebug) {
                    System.err.println(ThrowUtil.ogStackTrace(throwable));
                }
                throw new OgRuntimeException(this.getErrMsg(), throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionGET(String string, String string2) throws IOException {
        if (this.isDebug) {
            System.out.println("GET: " + string2 + " => " + string);
        }
        if (this.isMkdirs) {
            this.makeLocalDir(string);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            if (!this.ftp.retrieveFile(string2, (OutputStream)fileOutputStream)) {
                this.errAppend((Object)"\u30d5\u30a1\u30a4\u30eb\u306e\u53d6\u5f97(GET)\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                this.errAppend("   localFile  = [", string, "]");
                this.errAppend("   remoteFile = [", string2, "]");
                this.errAppend((Object)this.ftp.getReplyString());
                throw new OgRuntimeException(this.getErrMsg());
            }
        }
        catch (Throwable throwable) {
            Closer.ioClose(fileOutputStream);
            throw throwable;
        }
        Closer.ioClose(fileOutputStream);
    }

    @Override
    protected void actionGETdir(String string, String string2) throws IOException {
        FTPFile[] fTPFileArray = this.ftp.listFiles(string2);
        for (int i = 0; i < fTPFileArray.length; ++i) {
            String string3 = fTPFileArray[i].getName();
            if (fTPFileArray[i].isDirectory()) {
                this.actionGETdir(this.addFile(string, string3), this.addFile(string2, string3));
                continue;
            }
            this.actionGET(this.addFile(string, string3), this.addFile(string2, string3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPUT(String string, String string2) throws IOException {
        if (this.isDebug) {
            System.out.println("PUT: " + string + " => " + string2);
        }
        boolean bl = true;
        if (this.isMkdirs) {
            int n = string2.lastIndexOf(47) + 1;
            String string3 = string2.substring(0, n);
            if (n > 0 && !this.lastRemoteDir.startsWith(string3)) {
                this.lastRemoteDir = string3;
                if (StringUtil.startsChar(string3, '/')) {
                    String[] stringArray = string3.split("/");
                    this.ftp.changeWorkingDirectory("/");
                    for (int i = 1; i < stringArray.length; ++i) {
                        bl = this.ftp.changeWorkingDirectory(stringArray[i]);
                        if (!bl && (bl = this.ftp.makeDirectory(stringArray[i]))) {
                            bl = this.ftp.changeWorkingDirectory(stringArray[i]);
                        }
                        if (bl) continue;
                        this.errAppend((Object)"\u30c1\u30a7\u30f3\u30b8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                        this.errAppend("   remoteDir  = [", this.lastRemoteDir, "]");
                        this.errAppend((Object)this.ftp.getReplyString());
                        throw new OgRuntimeException(this.getErrMsg());
                    }
                }
                if (!bl) {
                    this.errAppend((Object)"\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                    this.errAppend("   remoteDir  = [", this.lastRemoteDir, "]");
                    this.errAppend((Object)this.ftp.getReplyString());
                    throw new OgRuntimeException(this.getErrMsg());
                }
            }
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            if (!this.ftp.storeFile(string2, (InputStream)fileInputStream)) {
                this.errAppend((Object)"\u30d5\u30a1\u30a4\u30eb\u306e\u30b9\u30c8\u30a2(PUT)\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                this.errAppend("   localFile  = [", string, "]");
                this.errAppend("   remoteFile = [", string2, "]");
                this.errAppend((Object)this.ftp.getReplyString());
                throw new OgRuntimeException(this.getErrMsg());
            }
        }
        catch (Throwable throwable) {
            Closer.ioClose(fileInputStream);
            throw throwable;
        }
        Closer.ioClose(fileInputStream);
    }

    @Override
    protected void actionDEL(String string) throws IOException {
        if (this.isDebug) {
            System.out.println("DEL: " + string);
        }
        if (!this.ftp.deleteFile(string)) {
            this.errAppend((Object)"\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664(DEL)\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            this.errAppend("   remoteFile = [", string, "]");
            this.errAppend((Object)this.ftp.getReplyString());
            throw new OgRuntimeException(this.getErrMsg());
        }
    }

    @Override
    protected void actionDELdir(String string) throws IOException {
        FTPFile[] fTPFileArray = this.ftp.listFiles(string);
        for (int i = 0; i < fTPFileArray.length; ++i) {
            String string2 = this.addFile(string, fTPFileArray[i].getName());
            if (fTPFileArray[i].isDirectory()) {
                this.actionDELdir(string2);
                continue;
            }
            this.actionDEL(string2);
        }
        if (!this.ftp.removeDirectory(string)) {
            this.errAppend((Object)"Directory\u306e\u524a\u9664(DEL)\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            this.errAppend("   remoteDir = [", string, "]");
            this.errAppend((Object)this.ftp.getReplyString());
            throw new OgRuntimeException(this.getErrMsg());
        }
    }

    public void setMode(String string) {
        if (string != null) {
            if (!"ASCII".equals(string) && !"BINARY".equals(string)) {
                this.errAppend((Object)"\u30e2\u30fc\u30c9\u6307\u5b9a\u306f\u3001ASCII \u307e\u305f\u306f\u3001BINARY \u3068\u6307\u5b9a\u304f\u3060\u3055\u3044\u3002");
                this.errAppend("   mode  = [", string, "]");
                throw new OgRuntimeException(this.getErrMsg());
            }
            this.isAsciiMode = "ASCII".equals(string);
        }
    }

    public void setPassive(boolean bl) {
        this.isPassive = bl;
    }

    public void setEncode(String string) {
        if (string != null) {
            this.encode = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"ASCII", "BINARY"};
        String[] stringArray3 = new String[]{"GET", "PUT", "DEL", "GETDIR", "PUTDIR", "DELDIR"};
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("host", "\u63a5\u7d9a\u5148\u306eFTP\u30b5\u30fc\u30d0\u30fc\u306e\u30a2\u30c9\u30ec\u30b9\u307e\u305f\u306f\u3001\u30b5\u30fc\u30d0\u30fc\u540d(\u5fc5\u9808)");
        linkedHashMap.put("user", "\u63a5\u7d9a\u3059\u308b\u30e6\u30fc\u30b6\u30fc\u540d(\u5fc5\u9808)");
        linkedHashMap.put("passwd", "\u63a5\u7d9a\u3059\u308b\u30e6\u30fc\u30b6\u30fc\u306e\u30d1\u30b9\u30ef\u30fc\u30c9(\u5fc5\u9808)");
        linkedHashMap.put("remoteFile", "\u63a5\u7d9a\u5148\u306eFTP\u30b5\u30fc\u30d0\u30fc\u5074\u306e\u30d5\u30a1\u30a4\u30eb\u540d(\u5fc5\u9808)");
        LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
        linkedHashMap2.put("localFile", "\u30ed\u30fc\u30ab\u30eb\u306e\u30d5\u30a1\u30a4\u30eb\u540d");
        linkedHashMap2.put("port", "\u63a5\u7d9a\u306b\u5229\u7528\u3059\u308b\u30dd\u30fc\u30c8\u756a\u53f7\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002");
        linkedHashMap2.put("mode", "\u6271\u3046\u30d5\u30a1\u30a4\u30eb\u306e\u7a2e\u985e(ASCII/BINARY)\u3092\u6307\u5b9a\u3057\u307e\u3059(\u521d\u671f\u5024:ASCII)");
        linkedHashMap2.put("command", "FTP\u30b5\u30fc\u30d0\u30fc\u5074\u3067\u306e\u51e6\u7406\u306e\u65b9\u6cd5(GET/PUT/DEL)\u3092\u6307\u5b9a\u3057\u307e\u3059(\u521d\u671f\u5024:GET)");
        linkedHashMap2.put("passive", "\u30d1\u30c3\u30b7\u30d6\u30e2\u30fc\u30c9(\u30ed\u30fc\u30ab\u30eb\u304b\u3089\u30b5\u30fc\u30d0\u30fc\u3078\u63a5\u7d9a\u3092\u5f35\u308b)\u3092\u5229\u7528\u3059\u308b\u304b\u3069\u3046\u304b(\u521d\u671f\u5024:true)");
        linkedHashMap2.put("mkdirs", "\u53d7\u3051\u5074\u30d5\u30a1\u30a4\u30eb(GET\u6642:LOCAL\u3001PUT\u6642:FTP\u30b5\u30fc\u30d0\u30fc)\u306b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3059\u308b\u304b\u3069\u3046\u304b(\u521d\u671f\u5024:true)");
        linkedHashMap2.put("encode", "\u65e5\u672c\u8a9e\u30d5\u30a1\u30a4\u30eb\u540d\u306a\u3069\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u540d\u3092\u6307\u5b9a\u3057\u307e\u3059(\u521d\u671f\u5024:UTF-8)");
        linkedHashMap2.put("timeout", "Data\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8(\u521d\u671f\u5024:600 [\u79d2])");
        linkedHashMap2.put("display", "[false/true]:true\u306f\u3001\u691c\u7d22\u72b6\u6cc1\u3092\u8868\u793a\u3057\u307e\u3059(\u521d\u671f\u5024:false)");
        linkedHashMap2.put("debug", "\u30c7\u30d0\u30c3\u30b0\u60c5\u5831\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
        Argument argument = new Argument("org.opengion.fukurou.util.FTPConnect");
        argument.setMustProparty(linkedHashMap);
        argument.setUsableProparty(linkedHashMap2);
        argument.setArgument(stringArray);
        FTPConnect fTPConnect = new FTPConnect();
        String string = argument.getProparty("host");
        String string2 = argument.getProparty("user");
        String string3 = argument.getProparty("passwd");
        fTPConnect.setHostUserPass(string, string2, string3);
        fTPConnect.setPort(argument.getProparty("port"));
        fTPConnect.setMode(argument.getProparty("mode", "ASCII", stringArray2));
        fTPConnect.setPassive(argument.getProparty("passive", true));
        fTPConnect.setMkdirs(argument.getProparty("mkdirs", true));
        fTPConnect.setEncode(argument.getProparty("encode", "UTF-8"));
        fTPConnect.setTimeout(argument.getProparty("timeout", 600));
        fTPConnect.setDisplay(argument.getProparty("display", false));
        fTPConnect.setDebug(argument.getProparty("debug", false));
        try {
            fTPConnect.connect();
            String string4 = argument.getProparty("command", "GET", stringArray3);
            String string5 = argument.getProparty("localFile");
            String string6 = argument.getProparty("remoteFile");
            fTPConnect.action(string4, string5, string6);
        }
        catch (RuntimeException runtimeException) {
            System.err.println(fTPConnect.getErrMsg());
        }
        finally {
            fTPConnect.disconnect();
        }
    }
}

