<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useJQUI="true" refresh="{@REFRESH}" >
	<link rel="stylesheet" href="monitor.css?x={@DATE.HMS}" />
</og:head>
<jsp:directive.include file="/jsp/custom/none_info.jsp" />

<og:comment
	system	= "GG:拡張ｵﾌﾟｼｮﾝ"
	pgid	= "GG0110"
	title	= "予定状況表示"
	date	= "2021/03/25"
	author	= "K.HASEGAWA"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<!-- 位置情報 の表示のレイアウト設定 -->
<og:value command="SET" key="DEV">
	<og:link gamenId="GG0100" href="index.jsp" target="CONTENTS"
		keys="command,DY_YOTE,DY_HATU,SET_GRP,SET_KEY"
		vals="NEW,[!DY_YOTE],[!DY_HATU],[!SET_GRP],[!SET_KEY]" >
			<table class="MonitorTbl scale">
			  <tbody class="judg[!JUDG]">					<!-- 8.4.3.0 (2023/04/07) -->
				<tr><td colspan="2" class="[TODAY]">[DY_YOTE]</td></tr>
				<tr><td>[CDJISI]</td><td>[JUDG]</td></tr>
				<tr><td colspan="2">[SET_GRP]</td></tr>
				<tr><td colspan="2">[SET_KEY]</td></tr>
			  </tbody>
			</table>
	</og:link>
</og:value>

<!-- 予定日が当日含む過去日で、実施状況が、( 3:不要 4:承認 5:確定) 以外で、判定結果が、(1:不要 2:任意 3:合格) 以外 が対象 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="0" notfoundMsg="">
	select A.SET_GRP , A.SET_KEY , A.NEXTDY , A.CDJISI , A.UNIQ
			 , A.JUDG , A.BG_KEY , A.VIEW_XY, A.DY_YOTE , A.DY_HATU
			 , case when DY_YOTE='{@DATE.YMD}' then 'today' else '' end as TODAY
	from GG11 A
	where	A.DY_YOTE &lt; '{@DATE.YMD}'
	and		A.CDJISI not in ( '3','4','5' )
	and		A.JUDG   not in ( '1','2','3' )
	and		A.BG_KEY = '{@BG_KEY}'
</og:query>

<!-- 背景画像がある場合しかありえない。 -->
<jsp:directive.include file="dragView.jsp" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
