<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GG:拡張ｵﾌﾟｼｮﾝ"
	pgid	= "GG0050"
	title	= "予定実績ﾃｰﾌﾞﾙ"
	date	= "2021/03/25"
	author	= "K.HASEGAWA"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<og:value command="SET" key="YMDFROM" value='{@NVL.DYFROM "@DATE.YMD M-1"}' />	<!-- １ヶ月前 -->
<og:value command="SET" key="YMDTO"   value='{@NVL.DYTO   "@DATE.YMD M2"}' />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" >
		select 	 A.DY_YOTE , A.CDJISI  , A.JUDG
				, A.SET_GRP, A.SET_KEY , A.NEXTDY  , A.DY_HATU
				,A.USRYOTE , A.USRJISI , A.USRAPP
				,A.BG_KEY  , A.CMNT
				,A.UNIQ,A.FGJ,A.USRSET,A.DYSET,A.USRUPD,A.DYUPD
		from GG11 A
	<og:where>
		<og:and value = "A.DY_YOTE	&gt;= '{@YMDFROM}'"		/>
		<og:and value = "A.DY_YOTE	&lt;= '{@YMDTO}'"		/>
		<og:and value = "A.CDJISI	=    '{@CDJISI}'"		/>
		<og:and value = "A.NEXTDY	=    '{@NEXTDY}'"		/>
		<og:and value = "A.JUDG		=    '{@JUDG}'"			/>
		<og:and value = "A.SET_GRP	=    '{@SET_GRP}'"		/>
		<og:and value = "A.SET_KEY	like '{@SET_KEY}'"		/>
		<og:and value = "A.USRYOTE	like '{@USRYOTE}'"		/>
		<og:and value = "A.USRJISI	like '{@USRJISI}'"		/>
		<og:and value = "A.USRAPP	like '{@USRAPP}'"		/>
		<og:and value = "A.BG_KEY	=    '{@BG_KEY}'"		/>
		<og:and value = "A.CMNT		like '{@CMNT}'"			/>
		<!-- 予定日が当日含む過去日で、実施状況が、( 3:不要 4:承認 5:確定) 以外で、判定結果が、(1:不要 2:任意 3:合格) 以外 が対象 -->
		<og:and>
			{@ZAN_FLAG}=1
			and	A.DY_YOTE &lt; '{@DATE.YMD}'
			and A.CDJISI not in ( '3','4','5' )
			and A.JUDG   not in ( '1','2','3' )
		</og:and>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.DY_YOTE,A.SET_GRP,A.SET_KEY" />
</og:query>

<og:columnEditor columns="DY_YOTE,SET_GRP,CDJISI"	must="true" />
<og:columnEditor column="SET_KEY" 	must="true" eventColumn="SET_GRP" />
<og:columnEditor column="BG_KEY"	addNoValue="true" />

<og:viewLink command="{@command}">
	<!-- 予定日のﾘﾝｸは、ﾃﾞｰﾀ登録 画面 -->
	<og:link column="DY_YOTE" gamenId="GG0100" href="index.jsp" target="CONTENTS"
		keys="command,DY_YOTE,DY_HATU,SET_GRP,SET_KEY"
		vals="NEW,[DY_YOTE],[DY_HATU],[SET_GRP],[SET_KEY]" />
	<!-- 発生日 のﾘﾝｸは、履歴ﾃｰﾌﾞﾙ 画面 -->
	<og:link column="DY_HATU" gamenId="GG0040" href="index.jsp" target="CONTENTS"
		keys="command,DYFROM,DYTO,SET_GRP,SET_KEY"
		vals="NEW,[DY_HATU],[DY_HATU],,[SET_GRP][SET_KEY]" />
</og:viewLink>

<og:viewMarker command="{@command}" >
	<og:columnMarker column="JUDG" >
		<div class="judg[!JUDG]">[JUDG]</div>
	</og:columnMarker>
</og:viewMarker>

<form method="POST" action="forward.jsp" target="RESULT" >
	<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
	<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:writeCheck>
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="DY_HATU" />
		<og:submit  action="MODIFY"  columnWritable="JUDG,USRYOTE,USRJISI,USRAPP,BG_KEY,CMNT"  />
		<og:submit  action="DELETE"  columnWritable="null" />
		<pre>　　　　　</pre>
		<!-- 承認ボタンは、roles 指定する -->
		<og:submit  action="MODIFY"  columnWritable="CDJISI,USRAPP,CMNT"
						roles="admin" lbl="CDJISI.4" keys="CDJISI" vals="4" accesskey="" />
	</og:writeCheck>

<!-- 判定結果 の凡例と、CSS -->
<pre>　　　　　</pre>
<jsp:directive.include file="/jsp/customGG/colorCSS.jsp" /><br />

	<!-- DB検索結果を表示させます。 -->
	<!-- checked="true" で、チェック済みの状態で表示できます。 -->
	<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
	<og:view
		viewFormType = "HTMLTable"
		command    = "{@command}"
		noDisplay  = "UNIQ,FGJ,USRSET,DYSET,USRUPD,DYUPD,{@extDisplay}"
		checked    = "{@checked}"
		startNo    = "{@startNo}"
		pageSize   = "{@pageSize}"
	/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
