<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useTabLink="true" useIntervalAccess="true" useAjaxSubmit="true">
	<!-- CDN だと社内無線環境で無茶遅い -->
	<script src='{@SYS.JSP}/common/option/quagga.min.js?v={@SYS.START_TIME}'>			<!-- --></script>	<!-- Editor_BARCODE				-->
	<script src='{@SYS.JSP}/common/option/JsBarcode.code39.min.js?v={@SYS.START_TIME}'>	<!-- --></script>	<!-- Renderer_BARCODE			-->
	<script src='{@SYS.JSP}/common/option/tesseract.min.js?v={@SYS.START_TIME}'>		<!-- --></script>	<!-- Editor_OCR1 , Editor_OCR2	-->
	<script src='{@SYS.JSP}/common/option/jsQR.min.js?v={@SYS.START_TIME}'>				<!-- --></script>	<!-- Editor_QRCODE				-->
						<!-- sm/261261････.map 404エラーが出ます -->
	<script src='{@SYS.JSP}/common/option/qrcode.min.js?v={@SYS.START_TIME}'>			<!-- --></script>	<!-- Renderer_QRCODE			-->
	<script src='{@SYS.JSP}/common/option/videocamera.js?v={@SYS.START_TIME}'>			<!-- --></script>	<!-- ｶﾒﾗｼｽﾃﾑ共通				-->

	<!-- タブリンクの切り替えで、先に記述済みの値を登録するためにサブミットさせる -->
	<!-- 8.4.1.1 (2023/02/24) 別ﾌｧｲﾙ内に移動 -->
	<script src='load_onchange.js?v={@SYS.START_TIME}'>									<!-- --></script>	<!-- onload時にｻﾌﾞﾐｯﾄ			-->

	<style>
		/* ｲﾝﾗｲﾝﾌﾞﾛｯｸ要素(大きさ自動指定)、上寄せ、角を丸くする */
		fieldset { display:inline-block; vertical-align:top; border-radius: 5px; }

		/* 極小ﾌｫﾝﾄ、真ん中寄せ、等倍、整形書式 */
		div.small {
			display:inline-block; font-size: x-small; text-align: center;
			vertical-align:top; font-family: monospace; white-space: pre;
		}

		.R , .S9 , .X9 { width:	80px; }

		.HALF { margin-left : 40px; }
	</style>
</og:head>

<jsp:directive.include file="/jsp/custom/none_info.jsp" />
<!-- <jsp:directive.include file="/jsp/custom/customTAB.jsp" />	-->

<og:comment
	system	= "GG:拡張ｵﾌﾟｼｮﾝ"
	pgid	= "GG0100"
	title	= "ﾃﾞｰﾀ登録"
	date	= "2021/03/25"
	author	= "K.HASEGAWA"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="MSG0065" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- 発生日が引数で与えられていない場合は、本日を設定する。 -->
<og:value command="SET" key="DY_HATU" value="{@DATE.YMD}" caseNull="{@DY_HATU}" />

<!-- 予定日が引数で与えられていない場合は、発生日を設定する。 -->
<og:value command="SET" key="DY_YOTE" defaultVal="{@DY_HATU}" />

<!-- GG1 予定実績ﾃｰﾌﾞﾙ の実施状況(CDJISI) の確認。確定(5)の場合は、ﾎﾞﾀﾝを出さないので、JISI5 を false とする -->
<og:value command="SQL">
	select CDJISI from GG11
	where DY_YOTE='{@DY_YOTE}' and SET_GRP='{@SET_GRP}' and SET_KEY='{@SET_KEY}'
</og:value>

<og:value key="JISI5" value="false" caseKey="{@CDJISI}" caseVal="5" />

<og:text>
<table style="{@style}">
	<tr>
		<og:column name="DY_YOTE" writable="false" /><td style="width:20px;"></td>
		<og:column name="CDJISI"  writable="false" />
	</tr>
</table>
</og:text>

<!-- GG10 履歴ﾃｰﾌﾞﾙ にﾃﾞｰﾀが存在しているかどうかﾁｪｯｸ。ﾎﾞﾀﾝを追加にするか変更にするかの判定 -->
<og:value command="SQL">
	select 1 as CNT from GG10
	where DY_HATU='{@DY_HATU}' and SET_GRP='{@SET_GRP}' and SET_KEY='{@SET_KEY}'
</og:value>

<!-- ﾀﾌﾞ名称 が未指定の場合は、一番最初のﾀﾌﾞを選択する -->
<og:value command="SQL" caseNull="{@TAB_NM}">
	select TAB_NM from GG02 where SET_GRP='{@SET_GRP}'
	group by TAB_NM order by min(ROWNO),min(COLNO)
</og:value>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<!-- UPCNT は、ﾃﾞｰﾀがない場合 NULL になり、entry で初期値が書き込まれるため、全件変更される -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="0" >
		select	'{@DY_HATU}' as DY_HATU	,
				'{@SET_GRP}' as SET_GRP	,
				'{@SET_KEY}' as SET_KEY	,
				COALESCE( B.TOKEN	,A.TOKEN	) as TOKEN			,
				COALESCE( B.TANI	,C.TANI		) as TANI			,
				B.VAL , B.RIYU										,
				B.UPCNT												,
				COALESCE( B.JUDG 	,'0'		) as JUDG			,
				COALESCE( A.TKN_NM	,C.TKN_NM	) as TKN_NM			,
				C.VIEW_LEN , C.DATA_TYPE 							,
				A.DEF_VAL											,
				D.SEL_NM , D.MARKER									,
				A.ROWNO , A.COLNO , A.COLSPAN , A.ROWSPAN			,
				A.CDREC , A.CDDISP 									,
				A.E_MIN , A.W_MIN , A.W_MAX , A.E_MAX , A.OPT_ATTR	,
				COALESCE( '{@DY_YOTE}' ,'{@DY_HATU}' ) as DY_YOTE	,
				B.UNIQ,B.FGJ,B.USRSET,B.DYSET,B.USRUPD,B.DYUPD
		from GG02 A left outer join GG10 B
				on  A.SET_GRP	= B.SET_GRP
				and A.TOKEN		= B.TOKEN
				and B.SET_KEY	= '{@SET_KEY}'
				and B.DY_HATU	= '{@DY_HATU}'
					left outer join GG01 C
					on A.TOKEN = C.TOKEN
						left outer join GG03 D
						on  D.SEL_TYPE = '0'
						and D.SEL_KEY  = 'TKN_GRP'
						and D.SEL_VAL  = A.TKN_GRP
		where A.SET_GRP in ( '{@SET_GRP}','{@SEL_KEY}' )
			<og:where startKey="and">
				<og:and value = "A.TAB_NM = '{@TAB_NM}'" />
			</og:where>
		and   A.FGJ		= '1'
		order by A.ROWNO,A.COLNO,UPCNT DESC
</og:query>

<og:columnEditor columns="DY_HATU,SET_GRP,SET_KEY,TOKEN"	must="true" />

<!-- ２重押し防止 oneClick()関数は、useAjaxSubmit='true' 使用時には使えません。 -->
<form name="form1" method="POST" action="forward.jsp" target="RESULT" >
	<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
	<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:writeCheck writable="{@JISI5}">
		<og:submit action="INSERT" keys="sqlType" vals="INSERT" value="entry" noWritable="null"						caseNull="{@CNT}" />
		<og:submit action="MODIFY" keys="sqlType" vals="MODIFY" value="entry" columnWritable="VAL,TANI,JUDG,RIYU"	caseNN  ="{@CNT}" />
	</og:writeCheck>

	<!-- 判定結果 の凡例と、CSS (追加・変更ボタンの横に出す) -->
	<jsp:directive.include file="/jsp/customGG/colorCSS.jsp" />

<!-- なぜか、div を block 要素に変更しても、fieldset が下に来ない -->
<og:equals val1="{@TAB_NM}" notNull="true" >
	<table><tr>
		<td>
			<!-- onClickで、ｻﾌﾞﾐｯﾄさせる。 -->
			<og:tabLink
				openTabName = "{@TAB_NM}"
				href		= "result.jsp?command=RENEW"
				openTab		= "false"
				onClick		= "return sub(this,'{@JISI5}');"
			>
				select TAB_NM from GG02 where SET_GRP='{@SET_GRP}' group by TAB_NM order by min(ROWNO),min(COLNO)
			</og:tabLink>
		</td>
		<td><div>　　(ﾀﾌﾞの切り替え時にも、ﾃﾞｰﾀを登録します。)</div></td>
	</tr></table>
</og:equals>

<!-- DB検索結果を表示させます。 -->
	<og:view
		viewFormType = "HTMLTokenTable"
		writable	= "{@JISI5}"
		command		= "{@command}"
		noDisplay	= "DY_HATU,SET_GRP,SET_KEY,DY_YOTE,UPCNT,UNIQ,FGJ,USRSET,DYSET,USRUPD,DYUPD,{@extDisplay}"
		checked		= "{@checked}"
		startNo		= "{@startNo}"
		pageSize	= "10000"
		useScrollBar = "false"
	/>

	<!-- クリックされたリンクを、entry.jsp に渡すためのhidden。JavaScriptで value 値を書き換える -->
	<og:hidden name="TAB_NM" value="{@TAB_NM}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
