/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* LOCAL_MSG_RTN ( PROCEDURE )                                              */
/* Created : 2022/11/10 17:41:12                                            */
/****************************************************************************/

CREATE 
PROCEDURE LOCAL_MSG_RTN(
	PI_PG		IN	VARCHAR2,
	PI_STEP		IN	VARCHAR2,
	PI_MSG		IN	VARCHAR2,
	PI_JOBID	IN	VARCHAR2,
	PI_PGNAME	IN	VARCHAR2
	)
/**********************************************************************/
/* エラーメッセージ配列出力用(統合サーバ用。MSG_RTNでログ出力)        */
/*							                                          */
/*    						                                          */
/*                                                                    */
/*   ログに出力するなどの独自対応が必要な場合は各システム毎に         */
/*   再定義して下さい。                                               */
/*                                                                    */
/**********************************************************************/
IS
	G_STATUS NUMBER;
	G_ERR_CODE VARCHAR2(1000);
BEGIN
	MSG_RTN(G_STATUS
PLS-00201: 識別子MSG_RTNを宣言してください。
PLS-00049: バインド変数識別子MSG_RTNを宣言してくださいが正しくありません。
PLS-00103: 記号"PLS"が見つかりました。 次のうちの1つが入るとき:

   . ( ) , * @ % & = - + < / > at in is mod remainder not rem =>
   <an exponent (**)> <> or != or ~= >= <= <> and or default
   like like2 like4 likec as between from using || multiset
   member submultiset
			,G_ERR_CODE
			,PI_JOBID
			,PI_JOBID
			,PI_PG
			,PI_PGNAME
			,NULL
			,NULL
			,SUBSTRB(PI_STEP||' '||PI_MSG,1,1000)
			);
END LOCAL_MSG_RTN;
;
