<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- トークンの件数を確認(現状) -->
<og:value command="SQL">select count(*) AS CNT23A from DR$GF23_TXT_IDX$I</og:value>
<og:value command="SQL">select count(*) AS CNT24A from DR$GF24_TXT_IDX$I</og:value>
<og:value command="SQL">select count(*) AS CNT25A from DR$GF25_TXT_IDX$I</og:value>
<og:value command="SQL">select count(*) AS CNT76A from DR$GF76_TXT_IDX$I</og:value>
<og:value command="SQL">select count(*) AS CNT83A from DR$GF83_TXT_IDX$I</og:value>

<!-- テキスト索引の「SYNC」（同期化） -->
<!-- 新たにINSERTされた行のトークンが索引の末尾に追加される -->
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.SYNC_INDEX( 'GF23_TXT_IDX' ) }
</og:query>
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.SYNC_INDEX( 'GF24_TXT_IDX' ) }
</og:query>
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.SYNC_INDEX( 'GF25_TXT_IDX' ) }
</og:query>
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.SYNC_INDEX( 'GF76_TXT_IDX' ) }
</og:query>
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.SYNC_INDEX( 'GF83_TXT_IDX' ) }
</og:query>

<!-- テキスト索引の「OPTIMIZE」（最適化） -->
<!--
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.OPTIMIZE_INDEX( 'GF23_TXT_IDX','FAST' ) }
</og:query>
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.OPTIMIZE_INDEX( 'GF24_TXT_IDX','FAST' ) }
</og:query>
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.OPTIMIZE_INDEX( 'GF25_TXT_IDX','FAST' ) }
</og:query>
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.OPTIMIZE_INDEX( 'GF76_TXT_IDX','FAST' ) }
</og:query>
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.OPTIMIZE_INDEX( 'GF83_TXT_IDX','FAST' ) }
</og:query>
-->

<!-- テキスト索引の「OPTIMIZE」（最適化） -->
<!-- 複数の同一トークン・エントリがマージされる -->
GF23_TXT_IDX
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.OPTIMIZE_INDEX( 'GF23_TXT_IDX','FULL' ) }
</og:query>
GF24_TXT_IDX
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.OPTIMIZE_INDEX( 'GF24_TXT_IDX','FULL' ) }
</og:query>
GF25_TXT_IDX
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.OPTIMIZE_INDEX( 'GF25_TXT_IDX','FULL' ) }
</og:query>
GF76_TXT_IDX
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.OPTIMIZE_INDEX( 'GF76_TXT_IDX','FULL' ) }
</og:query>
GF83_TXT_IDX
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.OPTIMIZE_INDEX( 'GF83_TXT_IDX','FULL' ) }
</og:query>

<!-- トークンの件数を確認(再編成後) -->
<og:value command="SQL">select count(*) AS CNT23B from DR$GF23_TXT_IDX$I</og:value>
<og:value command="SQL">select count(*) AS CNT24B from DR$GF24_TXT_IDX$I</og:value>
<og:value command="SQL">select count(*) AS CNT25B from DR$GF25_TXT_IDX$I</og:value>
<og:value command="SQL">select count(*) AS CNT76B from DR$GF76_TXT_IDX$I</og:value>
<og:value command="SQL">select count(*) AS CNT83B from DR$GF83_TXT_IDX$I</og:value>

<og:text>
  <table class="box_all" >
	<tr><th>INDEX       </th><th>Old                 </th><th>            </th><th>New                 </th><th>              </th></tr>
	<tr><td>GF23_TXT_IDX</td><td class="S9">{@CNT23A}</td><td>{@LBL.ARROW}</td><td class="S9">{@CNT23B}</td><td>{@LBL.MSG0040}</td></tr>
	<tr><td>GF24_TXT_IDX</td><td class="S9">{@CNT24A}</td><td>{@LBL.ARROW}</td><td class="S9">{@CNT24B}</td><td>{@LBL.MSG0040}</td></tr>
	<tr><td>GF25_TXT_IDX</td><td class="S9">{@CNT25A}</td><td>{@LBL.ARROW}</td><td class="S9">{@CNT25B}</td><td>{@LBL.MSG0040}</td></tr>
	<tr><td>GF76_TXT_IDX</td><td class="S9">{@CNT76A}</td><td>{@LBL.ARROW}</td><td class="S9">{@CNT76B}</td><td>{@LBL.MSG0040}</td></tr>
	<tr><td>GF83_TXT_IDX</td><td class="S9">{@CNT83A}</td><td>{@LBL.ARROW}</td><td class="S9">{@CNT83B}</td><td>{@LBL.MSG0040}</td></tr>
  </table>
</og:text>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
