<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useScrollBar="{@useHeaderScroll}">
	<script src="{@SYS.JSP}/GF7120/timecheck.js?v={@SYS.START_TIME}" ><!-- --></script>
</og:head>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7120"
	title	= "レスポンス調査"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:columnCheck
	command   = "{@command}"
/>

[Test Results]
<table>
<tr>
<td style="vertical-align:top;">
&amp;nbsp;1.JSP Page Processing (Columns: 20,Rows: <og:text>{@maxRowCount}</og:text>(all) <og:text>{@pageSize}</og:text>(view))
<table style="margin-left:20px" >
	<tr>
		<td style="width:100px;">DB(Query) :</td><td id="qTime" style="text-align:right; width:50px;"></td><td>(ms)</td>
	</tr>
	<tr>
		<td style="width:100px;">JSP(View) :</td><td id="vTime" style="text-align:right; width:50px;"></td><td>(ms)</td>
	</tr>
	<tr>
		<td style="width:100px;">IE(Page)  :</td><td id="pTime" style="text-align:right; width:50px;"></td><td>(ms)</td>
	</tr>
	<tr>
		<td style="width:100px;">HeaderFix :</td><td id="hTime" style="text-align:right; width:50px;"></td><td>(ms)</td>
	</tr>
	<tr>
		<td style="width:100px;">Total     :</td><td id="tTime" style="text-align:right; width:50px;"></td><td>(ms)</td>
	</tr>
</table>
</td>
<td style="vertical-align:top; padding-left:20px" >
&amp;nbsp;2.Network Transfer (FileSize: 12MB)
<table style="margin-left:20px" >
	<tr>
		<td style="width:100px;">Time      :</td><td id="sTime" style="text-align:right; width:50px;"></td><td>(ms)</td>
	</tr>
	<tr>
		<td style="width:100px;">Rate      :</td><td id="rTime" style="text-align:right; width:50px;"></td><td>(KB/s)</td>
	</tr>
</table>
</td>
</tr>
</table>

<hr style="width:95%;" />

[Server Information]
<br/>
<table style="margin-left:20px" >
	<tr>
		<td style="width:100px;">Engine version :</td><td><og:text>{@SYS.ENGINE_INFO}</og:text></td>
	</tr>
</table>

[Client Information]
<br/>
<table style="margin-left:20px" >
	<tr>
		<td style="width:100px;">Test User :</td><td style="width:200px;"><og:text>{@USER.ID}</og:text></td>
		<td style="width:100px;">Test Date :</td><td style="width:200px;"><og:text>{@SYS.DATE}</og:text></td>
	</tr>
	<tr>
		<td style="width:100px;">IP Address :</td><td><og:text>{@USER.IPADDRESS}</og:text></td>
		<td style="width:100px;">Remote Host :</td><td><og:text><jsp:scriptlet>out.println( request.getRemoteHost() );</jsp:scriptlet></og:text></td>
	</tr>
</table>
[Client Platform Information]
<br/>
<table style="margin-left:20px" >
	<tr>
		<td style="width:100px;">CPU Info :</td><td id="cpu" ></td>
	</tr>
	<tr>
		<td style="width:100px;">Platform :</td><td id="platform" ></td>
	</tr>
	<tr>
		<td style="width:100px;">Browser :</td><td colspan="3" id="browser" ></td>
	</tr>
	<tr>
		<td style="width:100px;">&amp;nbsp;(version) :</td><td colspan="3" id="version" ></td>
	</tr>
</table>

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	select *
	from GF41
	where rownum &lt;= {@maxRowCount}
	order by SYSTEM_ID,CLM,LANG
</og:query>

<og:view
	command = "{@command}"
	pageSize = "{@pageSize}"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
